/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.utils;

import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.protobuf.BiometricMessage;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BiometricUtilUC {
    public static List<BiometricMessage.BodyPart> getAvailableBodyParts(BiometricPosition position, EnrollmentService enrollmentService) {
        ArrayList<BiometricMessage.BodyPart> bodyPartList = new ArrayList<BiometricMessage.BodyPart>();
        List parts = new ArrayList();
        switch (position) {
            case LEFT_SLAP: {
                parts = enrollmentService.getFingerPrint().getLeftSlap().getAvailableBodyParts();
                break;
            }
            case RIGHT_SLAP: {
                parts = enrollmentService.getFingerPrint().getRightSlap().getAvailableBodyParts();
                break;
            }
            case BOTH_THUMBS: {
                parts = enrollmentService.getFingerPrint().getBothThumbs().getAvailableBodyParts();
                break;
            }
            case LEFT_IRIS: {
                parts = enrollmentService.getIris().getLeftEye().getAvailableBodyParts();
                break;
            }
            case RIGHT_IRIS: {
                parts = enrollmentService.getIris().getRightEye().getAvailableBodyParts();
                break;
            }
            case FACE: {
                parts = enrollmentService.getPhotograph().getPhoto().getAvailableBodyParts();
            }
        }
        parts.forEach(bodyPart -> bodyPartList.add(BiometricMessage.BodyPart.newBuilder().setSubType(bodyPart.getSubType()).setType(bodyPart.getType()).build()));
        return bodyPartList;
    }

    public static List<BiometricMessage.BodyPart> getMissingBodyParts(BiometricPosition position, EnrollmentService enrollmentService) {
        ArrayList<BiometricMessage.BodyPart> missingPartList = new ArrayList<BiometricMessage.BodyPart>();
        List parts = new ArrayList();
        switch (position) {
            case LEFT_SLAP: {
                parts = enrollmentService.getFingerPrint().getLeftSlap().getMissingBodyParts();
                break;
            }
            case RIGHT_SLAP: {
                parts = enrollmentService.getFingerPrint().getRightSlap().getMissingBodyParts();
                break;
            }
            case BOTH_THUMBS: {
                parts = enrollmentService.getFingerPrint().getBothThumbs().getMissingBodyParts();
                break;
            }
            case LEFT_IRIS: {
                parts = enrollmentService.getIris().getLeftEye().getMissingBodyParts();
                break;
            }
            case RIGHT_IRIS: {
                parts = enrollmentService.getIris().getRightEye().getMissingBodyParts();
                break;
            }
            case FACE: {
                parts = enrollmentService.getPhotograph().getPhoto().getMissingBodyParts();
            }
        }
        parts.forEach(bodyPart -> missingPartList.add(BiometricMessage.BodyPart.newBuilder().setSubType(bodyPart.getSubType()).setType(bodyPart.getSubType()).build()));
        return missingPartList;
    }

    /*
     * Exception decompiling
     */
    public static byte[] compress(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void handleErrorGrpcResponse(UosResponse errorResponse, String transactionId) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse), null, errorResponse.getErrorCode(), transactionId, new Object[0]);
    }

    public static void handleGenericError(String message, String code, String transactionId) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(message, null, code, transactionId, new Object[0]);
        OnlineGatewayException exception = new OnlineGatewayException(message, message, code);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }
}

