/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.utils;

import in.gov.uidai.ec.ecmpapi.CIDREncryptorImpl;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.json.StationRegistrationHelperRequest;
import in.gov.uidai.ec.service.machineidentity.MachineIdentityFactory;
import in.gov.uidai.ec.ui.utils.StationRegistrationInfoHelper;
import in.gov.uidai.swing.notify.AlwaysOnTopOptionPane;
import java.time.Duration;
import java.time.Instant;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StationRegistrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationRegistrationHelper.class);
    public static StationRegistrationHelper stationRegistrationHelper;

    public static StationRegistrationHelper getInstance() {
        if (stationRegistrationHelper == null) {
            stationRegistrationHelper = new StationRegistrationHelper();
        }
        return stationRegistrationHelper;
    }

    public void updateStationRegistrationHelperInfo(EcmpApiService ecmpApiService) {
        try {
            CIDREncryptorImpl cidrEncryptor = new CIDREncryptorImpl();
            byte[] encodedPublicKey = Base64.encode((byte[])cidrEncryptor.getPublicKey());
            String uniqueMachineId = MachineIdentityFactory.getIdentity().getUniqueMachineId();
            Instant start = Instant.now();
            String res = StationRegistrationInfoHelper.INSTANCE.fetch(new String(encodedPublicKey), uniqueMachineId);
            StationRegistrationHelperRequest stationRegistrationHelperRequest = new StationRegistrationHelperRequest(res);
            stationRegistrationHelperRequest.addHeader("Content-Type", "application/json");
            ecmpApiService.doPostStationRegistrationHelperInfo(stationRegistrationHelperRequest);
            Duration duration = Duration.between(start, Instant.now());
            LOGGER.info("Response from fetch took " + duration);
        }
        catch (UnsatisfiedLinkError e) {
            AlwaysOnTopOptionPane.create().messageType(1).optionType(-1).message("The application is tampered. Cannot proceed. Please re install the application.").title("Aadhaar").winIcon("res/images/frame_icon.png").show();
            System.exit(0);
        }
        catch (Exception e) {
            LOGGER.error("Could not upload station registration info", (Throwable)e);
        }
    }
}

