/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.vrol;

import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.packet.IPacketSummaryDAO;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.report.PacketStatusWiseSummary;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.vrol.IViewEnrolmentDetailsConstants;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewEnrolmentDetailsControl
implements IOnScreenDisplayAware,
IViewEnrolmentDetailsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewEnrolmentDetailsControl.class);
    private IOnScreenDisplay osd;
    private UnsavedTracker tracker;
    private IPacketService packetService;
    private IPacketSummaryDAO packetSummaryDAO;
    private IPreSyncPreference preSyncPref;
    private IEodReportSearch eodReportSearch;
    private VerificationGuard verificationGuard;
    private TokenManager opTokenManager;

    public void setOpTokenManager(TokenManager opTokenManager) {
        this.opTokenManager = opTokenManager;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setPacketService(IPacketService packetService) {
        this.packetService = packetService;
    }

    public void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public final void setPacketSummaryDAO(IPacketSummaryDAO packetSummaryDAO) {
        this.packetSummaryDAO = packetSummaryDAO;
    }

    public final void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void setEodReportSearch(IEodReportSearch eodReportSearch) {
        this.eodReportSearch = eodReportSearch;
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }

    @EventHandler(name="hID_Vrol_ToolBut_Sel", method="actionPerformed")
    public void onViewEnrollmentDetailsSelect(ILiteEvent evt) {
        if (!this.tracker.selectOther(evt) || !this.verificationGuard.verifyOnStartUp(VerificationService.Type.ViewEnrolmentDetails, evt)) {
            return;
        }
        if (this.opTokenManager.isUniversalClientTransaction() && !this.opTokenManager.isValid()) {
            LOGGER.info("Operator not logged in");
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Operator needs to be logged in for status check", (Component)evt.getEvent().getSource());
            return;
        }
        String scafId = this.osd.recompose(evt.getScaffoldId(), "viewEnrollmentDetailsView");
        ((IViewElement)this.osd.getScaffold(scafId).getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.VIEW_ENROLLMENT_DETAILS);
        this.refreshEnrollmentDetails(this.osd.getView(this.osd.getScaffold(evt.getScaffoldId()).getViewId()));
    }

    @EventHandler(name="hID_Vrol_Refresh", method="actionPerformed")
    public void onRefreshEnrollmentDetails(ILiteEvent evt) {
        this.refreshEnrollmentDetails(this.osd.getView(evt.getViewId()));
    }

    private void refreshEnrollmentDetails(ILiteView view) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Vrol_Packet_Status_Summary")).set("value", new ArrayList());
        PacketStatusWiseSummary statusSummary = this.packetService.getPacketStatusWiseSummary();
        int unUploadedCount = statusSummary.getApprovedCount() + statusSummary.getSyncedCount();
        statusSummary.setUnUploadedCount(unUploadedCount);
        ((IViewElement)eMap.get("eID_Vrol_Packet_Status_Summary")).set("value", Collections.singletonList(statusSummary));
        this.showPacketDataList(eMap);
    }

    private void showPacketDataList(Map<String, IViewElement> eMap) {
        String queryStr = ((String)eMap.get("eID_Vrol_List_Querystr").get("text")).trim().toLowerCase();
        boolean residentOpt = (Boolean)eMap.get("eID_Vrol_List_Opt_Resident").get("isSelected");
        boolean statusOpt = (Boolean)eMap.get("eID_Vrol_List_Opt_Status").get("isSelected");
        boolean skippedOpt = (Boolean)eMap.get("eID_Vrol_List_Opt_Skipped").get("isSelected");
        eMap.get("eID_Vrol_PktList").set("value", new ArrayList());
        List packetDataList = new ArrayList();
        String searchKey = null;
        ArrayList<String> searchValues = new ArrayList<String>(Collections.EMPTY_LIST);
        if (queryStr.isEmpty()) {
            if (skippedOpt) {
                searchKey = "IsSkipped";
            }
        } else if (residentOpt) {
            searchKey = "ResidentName";
            searchValues.add(queryStr);
        } else if (statusOpt) {
            searchKey = "Status";
            searchValues.add(queryStr);
        }
        packetDataList = this.packetService.getDataForListing(searchKey, searchValues);
        eMap.get("eID_Vrol_PktList").set("value", packetDataList);
    }

    private void updateNotificationInfo(Map<String, IViewElement> eMap, int unUploadedCount) {
        String notificationMessage = "<html><br>";
        int unUploadedPacketsPercentage = unUploadedCount * 100 / this.preSyncPref.getMaxUnuploadedPackets();
        if (unUploadedPacketsPercentage > 75) {
            notificationMessage = notificationMessage + "Total un-uploaded packet has reached " + unUploadedPacketsPercentage + "% of max allowed limit.<br>";
        }
        long maxAllowedDays = Long.parseLong(this.preSyncPref.getMaxUnuploadedDateAllowed().substring(0, this.preSyncPref.getMaxUnuploadedDateAllowed().length() - 1));
        long daysOfOldestUnUploadedPacket = this.eodReportSearch.getDaysOfOldestUnUploadedPacket();
        if ((double)daysOfOldestUnUploadedPacket > (double)maxAllowedDays * 0.75) {
            notificationMessage = notificationMessage + "This client has un-uploaded packets older than " + daysOfOldestUnUploadedPacket + " days of max allowed " + maxAllowedDays + " days.";
        }
        notificationMessage = notificationMessage + "</html>";
        eMap.get("eID_Vrol_Notification").set("text", (Object)notificationMessage);
    }
}

