/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.util;

import com.google.common.base.Strings;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.telemetry.TelemetryService;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebviewLocalProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebviewLocalProxy.class);
    private static HttpProxyServer server;
    public static String basicAuth;

    public static void startLocalProxyServer() {
        boolean hasCredentials;
        if (server != null) {
            return;
        }
        Properties props = WebviewLocalProxy.getProperty();
        String proxyHost = props.getProperty("custom.proxy.ip");
        String proxyPort = props.getProperty("custom.port");
        String proxyUserName = props.getProperty("custom.proxy.userName");
        String proxyUserPwd = props.getProperty("custom.proxy.userpwd");
        boolean useProxy = !StringUtils.isBlank((String)proxyHost) && !StringUtils.isBlank((String)proxyPort);
        boolean bl = hasCredentials = StringUtils.isNotBlank((String)proxyUserName) && StringUtils.isNotBlank((String)proxyUserPwd);
        if (!useProxy) {
            return;
        }
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "8888");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "8888");
        final InetSocketAddress companyProxy = new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort));
        if (hasCredentials) {
            System.setProperty("http.proxyUser", proxyUserName);
            System.setProperty("http.proxyPassword", proxyUserPwd);
            System.setProperty("https.proxyUser", proxyUserName);
            System.setProperty("https.proxyPassword", proxyUserPwd);
            basicAuth = Base64.getEncoder().encodeToString((proxyUserName + ":" + proxyUserPwd).getBytes());
        }
        LOGGER.info("PROXY dependency location{}", (Object)DefaultHttpProxyServer.class.getProtectionDomain().getCodeSource().getLocation());
        server = DefaultHttpProxyServer.bootstrap().withPort(8888).withAllowLocalOnly(true).withConnectTimeout(30000).withFiltersSource((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpFiltersAdapter(originalRequest, ctx);
            }
        }).withChainProxyManager((httpRequest, chainedProxies, clientDetails) -> {
            String uri = httpRequest.getUri();
            String[] parts = uri.split(":");
            String ipPart = parts[0];
            String portPart = parts.length > 1 ? ":" + parts[1] : "";
            String hostname = ipPart;
            try {
                InetAddress inet = InetAddress.getByName(ipPart);
                String resolvedHost = inet.getHostName();
                if (resolvedHost != null && !resolvedHost.equals(ipPart)) {
                    hostname = resolvedHost;
                }
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Host resolution failed for " + ipPart + ", forwarding as-is.");
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_118.getErrorCode(), new String[0]);
            }
            String rewritten = hostname + portPart;
            if (!Strings.isNullOrEmpty((String)basicAuth)) {
                httpRequest.headers().add("Proxy-Authorization", (Object)("Basic " + basicAuth));
            }
            httpRequest.headers().add("Proxy-Connection", (Object)"Keep-Alive");
            httpRequest.headers().add("User-Agent", (Object)"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.102 Safari/537.36 ECMP");
            httpRequest.headers().add("Host", (Object)rewritten);
            if (!rewritten.equals(uri)) {
                LOGGER.info("Rewriting CONNECT target: " + uri + " -> " + rewritten);
                httpRequest.setUri(rewritten);
            }
            LOGGER.info("Outgoing CONNECT: " + httpRequest.getUri());
            chainedProxies.add(new ChainedProxyAdapter(){

                public InetSocketAddress getChainedProxyAddress() {
                    return companyProxy;
                }
            });
        }).start();
    }

    public static void stopLocalProxyServer() {
        if (server == null) {
            return;
        }
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("http.proxyUser");
        System.clearProperty("http.proxyPassword");
        System.clearProperty("https.proxyUser");
        System.clearProperty("https.proxyPassword");
        server.stop();
        server = null;
    }

    private static Properties getProperty() {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream("./conf/proxy.properties");){
            props.load(fis);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load Proxy properties");
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_GEN_118.getErrorCode(), new String[0]);
        }
        return props;
    }
}

