/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.translit.core;

import in.gov.uidai.translit.spi.IEditDistance;
import in.gov.uidai.translit.spi.ISoftKeyboardProvider;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransliterationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransliterationManager.class);
    private static final TransliterationManager TLIT_MGR = new TransliterationManager();
    private Map<String, ITransliterationProvider> tlitProviders = new HashMap<String, ITransliterationProvider>();
    private Map<String, ITransliterationProvider> rtlitProviders = new HashMap<String, ITransliterationProvider>();
    private ISoftKeyboardProvider kbdProvider;
    private List<IEditDistance> edList = new ArrayList<IEditDistance>();

    public static TransliterationManager getInst() {
        return TLIT_MGR;
    }

    private TransliterationManager() {
    }

    public synchronized void register(ITransliterationProvider provider) {
        String[] rlocales;
        String[] locales = provider.getSupportedLocales();
        if (locales != null) {
            for (String locale : locales) {
                if (!StringUtils.isNotBlank((String)locale)) continue;
                this.tlitProviders.put(locale.trim().toLowerCase(), provider);
                LOGGER.debug("transliteration provider set for " + locale);
            }
        }
        if ((rlocales = provider.getSupportedReverseLocales()) != null) {
            for (String rlocale : rlocales) {
                if (!StringUtils.isNotBlank((String)rlocale)) continue;
                this.rtlitProviders.put(rlocale.trim().toLowerCase(), provider);
                LOGGER.debug("reverse transliteration provider set for " + rlocale);
            }
        }
    }

    public synchronized void register(ISoftKeyboardProvider provider) {
        if (this.kbdProvider == null) {
            this.kbdProvider = provider;
            LOGGER.debug("soft keyboard provider set to " + provider.getClass().getName());
        }
    }

    public synchronized void register(IEditDistance ed) {
        if (!this.edList.contains(ed)) {
            this.edList.add(ed);
            LOGGER.debug("edit distance algorithm added " + ed.getClass().getName());
        }
    }

    public ITransliterationProvider getTransliterationProvider(String locale) {
        LOGGER.debug("getting provider for locale " + locale);
        if (StringUtils.isNotBlank((String)locale)) {
            return this.tlitProviders.get(locale.trim().toLowerCase());
        }
        return null;
    }

    public ITransliterationProvider getReverseTransliterationProvider(String locale) {
        if (StringUtils.isNotBlank((String)locale)) {
            return this.rtlitProviders.get(locale.trim().toLowerCase());
        }
        return null;
    }

    public ISoftKeyboardProvider getSoftKeyboardProvider() {
        return this.kbdProvider;
    }

    public List<IEditDistance> getEditDistance(String locale1, String locale2) {
        ArrayList<IEditDistance> result = new ArrayList<IEditDistance>();
        for (IEditDistance ed : this.edList) {
            if (!ed.supports(locale1, locale2)) continue;
            result.add(ed);
        }
        return result;
    }
}

