/*
 * Decompiled with CFR 0.152.
 */
package org.bn;

import org.bn.IDecoder;
import org.bn.IEncoder;
import org.bn.coders.ASN1PreparedElementData;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.coders.ber.BERDecoder;
import org.bn.coders.ber.BEREncoder;
import org.bn.coders.der.DERDecoder;
import org.bn.coders.der.DEREncoder;
import org.bn.coders.per.PERAlignedDecoder;
import org.bn.coders.per.PERAlignedEncoder;
import org.bn.coders.per.PERUnalignedDecoder;
import org.bn.coders.per.PERUnalignedEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoderFactory {
    private static CoderFactory instance = new CoderFactory();

    public static CoderFactory getInstance() {
        return instance;
    }

    public <T> IEncoder<T> newEncoder() throws Exception {
        return this.newEncoder("BER");
    }

    public <T> IEncoder<T> newEncoder(String encodingSchema) throws Exception {
        if (encodingSchema.equalsIgnoreCase("BER")) {
            return new BEREncoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Aligned") || encodingSchema.equalsIgnoreCase("PER/A")) {
            return new PERAlignedEncoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER/Unaligned") || encodingSchema.equalsIgnoreCase("PER/U")) {
            return new PERUnalignedEncoder();
        }
        if (encodingSchema.equalsIgnoreCase("DER")) {
            return new DEREncoder();
        }
        return null;
    }

    public IDecoder newDecoder() throws Exception {
        return this.newDecoder("BER");
    }

    public IDecoder newDecoder(String encodingSchema) throws Exception {
        if (encodingSchema.equalsIgnoreCase("BER")) {
            return new BERDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Aligned") || encodingSchema.equalsIgnoreCase("PER/A")) {
            return new PERAlignedDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Unaligned") || encodingSchema.equalsIgnoreCase("PER/U")) {
            return new PERUnalignedDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("DER")) {
            return new DERDecoder();
        }
        return null;
    }

    public IASN1PreparedElementData newPreparedElementData(Class<?> typeInfo) {
        return new ASN1PreparedElementData(typeInfo);
    }
}

