/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.SortedMap;
import org.bn.annotations.ASN1Any;
import org.bn.annotations.ASN1BitString;
import org.bn.annotations.ASN1Boolean;
import org.bn.annotations.ASN1BoxedType;
import org.bn.annotations.ASN1Choice;
import org.bn.annotations.ASN1Element;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1Integer;
import org.bn.annotations.ASN1Null;
import org.bn.annotations.ASN1ObjectIdentifier;
import org.bn.annotations.ASN1OctetString;
import org.bn.annotations.ASN1Real;
import org.bn.annotations.ASN1Sequence;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.annotations.ASN1String;
import org.bn.annotations.constraints.ASN1SizeConstraint;
import org.bn.annotations.constraints.ASN1ValueRangeConstraint;
import org.bn.coders.CoderUtils;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.metadata.ASN1AnyMetadata;
import org.bn.metadata.ASN1BitStringMetadata;
import org.bn.metadata.ASN1BooleanMetadata;
import org.bn.metadata.ASN1BoxedTypeMetadata;
import org.bn.metadata.ASN1ChoiceMetadata;
import org.bn.metadata.ASN1ElementMetadata;
import org.bn.metadata.ASN1EnumMetadata;
import org.bn.metadata.ASN1IntegerMetadata;
import org.bn.metadata.ASN1Metadata;
import org.bn.metadata.ASN1NullMetadata;
import org.bn.metadata.ASN1ObjectIdentifierMetadata;
import org.bn.metadata.ASN1OctetStringMetadata;
import org.bn.metadata.ASN1RealMetadata;
import org.bn.metadata.ASN1SequenceMetadata;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.metadata.ASN1StringMetadata;
import org.bn.metadata.constraints.ASN1SizeConstraintMetadata;
import org.bn.metadata.constraints.ASN1ValueRangeConstraintMetadata;
import org.bn.metadata.constraints.IASN1ConstraintMetadata;
import org.bn.types.BitString;
import org.bn.types.ObjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASN1PreparedElementData
implements IASN1PreparedElementData {
    private ASN1Metadata typeMeta;
    private ASN1ElementMetadata elementInfo;
    private Field[] fields;
    private ASN1PreparedElementData[] fieldsMetadata;
    private Field valueField;
    private ASN1PreparedElementData valueFieldMetadata;
    private IASN1ConstraintMetadata constraint;
    private Method getterMethod = null;
    private Method setterMethod = null;
    private Method doSelectedMethod = null;
    private Method isSelectedMethod = null;
    private boolean memberClassFlag = false;
    private Constructor<?> newInstanceConstructor = null;
    private Class<?> newInstanceClass = null;

    public ASN1PreparedElementData(Class<?> objectClass) {
        this.setupMetadata(objectClass, objectClass);
        this.setupConstructed(objectClass);
        this.setupMemberFlag(objectClass);
        this.setInstanceFactoryInfo(objectClass);
    }

    public ASN1PreparedElementData(Class<?> parentClass, Field field) {
        this.setupMetadata(field, field.getType());
        this.setupAccessors(parentClass, field);
        this.setupMemberFlag(field.getType());
    }

    private void setupMetadata(AnnotatedElement annotated, Class<?> objectClass) {
        if (annotated.isAnnotationPresent(ASN1SequenceOf.class)) {
            this.typeMeta = new ASN1SequenceOfMetadata(annotated.getAnnotation(ASN1SequenceOf.class), ((Field)annotated).getGenericType(), annotated);
        } else if (annotated.isAnnotationPresent(ASN1Sequence.class)) {
            this.typeMeta = new ASN1SequenceMetadata(annotated.getAnnotation(ASN1Sequence.class));
        } else if (annotated.isAnnotationPresent(ASN1Choice.class)) {
            this.typeMeta = new ASN1ChoiceMetadata(annotated.getAnnotation(ASN1Choice.class));
        } else if (annotated.isAnnotationPresent(ASN1Enum.class)) {
            this.typeMeta = new ASN1EnumMetadata(annotated.getAnnotation(ASN1Enum.class));
        } else if (annotated.isAnnotationPresent(ASN1Boolean.class)) {
            this.typeMeta = new ASN1BooleanMetadata(annotated.getAnnotation(ASN1Boolean.class));
        } else if (annotated.isAnnotationPresent(ASN1Any.class)) {
            this.typeMeta = new ASN1AnyMetadata(annotated.getAnnotation(ASN1Any.class));
        } else if (annotated.isAnnotationPresent(ASN1Integer.class)) {
            this.typeMeta = new ASN1IntegerMetadata(annotated.getAnnotation(ASN1Integer.class));
        } else if (annotated.isAnnotationPresent(ASN1Real.class)) {
            this.typeMeta = new ASN1RealMetadata(annotated.getAnnotation(ASN1Real.class));
        } else if (annotated.isAnnotationPresent(ASN1OctetString.class)) {
            this.typeMeta = new ASN1OctetStringMetadata(annotated.getAnnotation(ASN1OctetString.class));
        } else if (annotated.isAnnotationPresent(ASN1BitString.class) || objectClass.equals(BitString.class)) {
            this.typeMeta = new ASN1BitStringMetadata(annotated.getAnnotation(ASN1BitString.class));
        } else if (annotated.isAnnotationPresent(ASN1ObjectIdentifier.class) || objectClass.equals(ObjectIdentifier.class)) {
            this.typeMeta = new ASN1ObjectIdentifierMetadata(annotated.getAnnotation(ASN1ObjectIdentifier.class));
        } else if (annotated.isAnnotationPresent(ASN1String.class)) {
            this.typeMeta = new ASN1StringMetadata(annotated.getAnnotation(ASN1String.class));
        } else if (annotated.isAnnotationPresent(ASN1Null.class)) {
            this.typeMeta = new ASN1NullMetadata(annotated.getAnnotation(ASN1Null.class));
        } else if (annotated.isAnnotationPresent(ASN1BoxedType.class)) {
            this.typeMeta = new ASN1BoxedTypeMetadata(objectClass, annotated.getAnnotation(ASN1BoxedType.class));
        } else if (annotated.isAnnotationPresent(ASN1Element.class)) {
            this.typeMeta = new ASN1ElementMetadata(annotated.getAnnotation(ASN1Element.class));
        } else if (objectClass.equals(String.class)) {
            this.typeMeta = new ASN1StringMetadata();
        } else if (objectClass.equals(Integer.class)) {
            this.typeMeta = new ASN1IntegerMetadata();
        } else if (objectClass.equals(Long.class)) {
            this.typeMeta = new ASN1IntegerMetadata();
        } else if (objectClass.equals(Double.class)) {
            this.typeMeta = new ASN1RealMetadata();
        } else if (objectClass.equals(Boolean.class)) {
            this.typeMeta = new ASN1BooleanMetadata();
        } else if (objectClass.equals(byte[].class)) {
            this.typeMeta = new ASN1OctetStringMetadata();
        }
        if (annotated.isAnnotationPresent(ASN1Element.class)) {
            this.elementInfo = new ASN1ElementMetadata(annotated.getAnnotation(ASN1Element.class));
        }
        this.setupConstrint(annotated);
    }

    @Override
    public ASN1Metadata getTypeMetadata() {
        return this.typeMeta;
    }

    @Override
    public ASN1ElementMetadata getASN1ElementInfo() {
        return this.elementInfo;
    }

    public void setASN1ElementInfo(ASN1ElementMetadata elementData) {
        this.elementInfo = elementData;
    }

    @Override
    public boolean hasASN1ElementInfo() {
        return this.elementInfo != null;
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public Field getField(int index) {
        return this.fields[index];
    }

    @Override
    public ASN1PreparedElementData getFieldMetadata(int index) {
        return this.fieldsMetadata[index];
    }

    private void setupConstructed(Class<?> objectClass) {
        int count = 0;
        Field[] srcFields = null;
        if (this.typeMeta != null && this.typeMeta instanceof ASN1SequenceMetadata && ((ASN1SequenceMetadata)this.typeMeta).isSet()) {
            SortedMap<Integer, Field> fieldOrder = CoderUtils.getSetOrder(objectClass);
            srcFields = new Field[]{};
            srcFields = fieldOrder.values().toArray(srcFields);
            count = srcFields.length;
        } else {
            srcFields = objectClass.getDeclaredFields();
            for (Field field : objectClass.getDeclaredFields()) {
                if (field.getType().equals(IASN1PreparedElementData.class) || field.isSynthetic()) continue;
                ++count;
            }
        }
        this.fields = new Field[count];
        this.fieldsMetadata = new ASN1PreparedElementData[count];
        int idx = 0;
        for (Field field : srcFields) {
            if (field.getType().equals(IASN1PreparedElementData.class) || field.isSynthetic()) continue;
            this.fields[idx] = field;
            this.fieldsMetadata[idx] = new ASN1PreparedElementData(objectClass, field);
            if (this.fields[idx].getName().equalsIgnoreCase("value")) {
                this.setValueField(field, this.fieldsMetadata[idx]);
            }
            ++idx;
        }
    }

    public void setValueField(Field valueField, ASN1PreparedElementData valueFieldMeta) {
        this.valueField = valueField;
        this.valueFieldMetadata = valueFieldMeta;
    }

    @Override
    public Field getValueField() {
        return this.valueField;
    }

    @Override
    public ASN1PreparedElementData getValueMetadata() {
        return this.valueFieldMetadata;
    }

    private void setupConstrint(AnnotatedElement annotated) {
        if (annotated.isAnnotationPresent(ASN1SizeConstraint.class)) {
            this.constraint = new ASN1SizeConstraintMetadata(annotated.getAnnotation(ASN1SizeConstraint.class));
        } else if (annotated.isAnnotationPresent(ASN1ValueRangeConstraint.class)) {
            this.constraint = new ASN1ValueRangeConstraintMetadata(annotated.getAnnotation(ASN1ValueRangeConstraint.class));
        }
    }

    @Override
    public IASN1ConstraintMetadata getConstraint() {
        return this.constraint;
    }

    @Override
    public boolean hasConstraint() {
        return this.constraint != null;
    }

    private void setupAccessors(Class<?> objectClass, Field field) {
        Object ex2;
        Object e2;
        try {
            this.doSelectedMethod = CoderUtils.findDoSelectMethodForField(field, objectClass, field.getType());
            this.doSelectedMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e2) {
            e2 = null;
        }
        catch (SecurityException ex2) {
            ex2 = null;
        }
        try {
            this.isSelectedMethod = CoderUtils.findIsSelectedMethodForField(field, objectClass);
            this.isSelectedMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e3) {
            e2 = null;
        }
        catch (SecurityException ex3) {
            ex2 = null;
        }
        try {
            this.getterMethod = CoderUtils.findGetterMethodForField(field, objectClass);
            this.getterMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e4) {
            e2 = null;
        }
        catch (SecurityException ex4) {
            ex2 = null;
        }
        try {
            this.setterMethod = CoderUtils.findSetterMethodForField(field, objectClass, field.getType());
            this.setterMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e52) {
            Object e52 = null;
        }
        catch (SecurityException ex5) {
            Object var3_13 = null;
        }
        this.setInstanceFactoryInfo(field.getType());
    }

    public void setInstanceFactoryInfo(Class<?> objClass) {
        try {
            this.newInstanceClass = objClass;
            this.newInstanceConstructor = objClass.getDeclaredConstructor(new Class[0]);
            this.newInstanceConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e2) {
            Object e2 = null;
        }
        catch (SecurityException ex) {
            Object var2_5 = null;
        }
    }

    @Override
    public Object invokeSetterMethod(Object object, Object param) throws Exception {
        return this.setterMethod.invoke(object, param);
    }

    @Override
    public Object invokeDoSelectMethod(Object object, Object param) throws Exception {
        return this.doSelectedMethod.invoke(object, param);
    }

    @Override
    public Object invokeGetterMethod(Object object, Object param) throws Exception {
        return this.getterMethod.invoke(object, new Object[0]);
    }

    @Override
    public Object invokeIsSelectedMethod(Object object, Object param) throws Exception {
        return this.isSelectedMethod.invoke(object, new Object[0]);
    }

    @Override
    public boolean isMemberClass() {
        return this.memberClassFlag;
    }

    protected void setupMemberFlag(Class<?> cls) {
        this.memberClassFlag = cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers());
    }

    @Override
    public Object newInstance() throws Exception {
        if (this.newInstanceConstructor != null) {
            return this.newInstanceConstructor.newInstance(new Object[0]);
        }
        return this.newInstanceClass.newInstance();
    }
}

