/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bn.annotations.ASN1Any;
import org.bn.annotations.ASN1Element;
import org.bn.annotations.ASN1Null;
import org.bn.annotations.ASN1Sequence;
import org.bn.annotations.ASN1SequenceOf;
import org.bn.annotations.ASN1String;
import org.bn.annotations.constraints.ASN1SizeConstraint;
import org.bn.annotations.constraints.ASN1ValueRangeConstraint;
import org.bn.coders.ElementInfo;
import org.bn.metadata.ASN1AnyMetadata;
import org.bn.metadata.ASN1NullMetadata;
import org.bn.metadata.ASN1SequenceMetadata;
import org.bn.metadata.ASN1SequenceOfMetadata;
import org.bn.metadata.ASN1StringMetadata;
import org.bn.types.BitString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoderUtils {
    public static int getIntegerLength(int value) {
        int sizeOfInt;
        long mask = 2139095040L;
        if (value < 0) {
            for (sizeOfInt = 4; (mask & (long)value) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
        } else {
            while ((mask & (long)value) == 0L && sizeOfInt > 1) {
                mask >>= 8;
                --sizeOfInt;
            }
        }
        return sizeOfInt;
    }

    public static int getIntegerLength(long value) {
        int sizeOfInt;
        long mask = 9187343239835811840L;
        if (value < 0L) {
            for (sizeOfInt = 8; (mask & value) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
        } else {
            while ((mask & value) == 0L && sizeOfInt > 1) {
                mask >>= 8;
                --sizeOfInt;
            }
        }
        return sizeOfInt;
    }

    public static int getPositiveIntegerLength(int value) {
        if (value < 0) {
            int sizeOfInt;
            long mask = 2139095040L;
            for (sizeOfInt = 4; (mask & (long)(~value)) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
            return sizeOfInt;
        }
        return CoderUtils.getIntegerLength(value);
    }

    public static int getPositiveIntegerLength(long value) {
        if (value < 0L) {
            int sizeOfInt;
            long mask = 9187343239835811840L;
            for (sizeOfInt = 8; (mask & (value ^ 0xFFFFFFFFFFFFFFFFL)) == mask && sizeOfInt > 1; mask >>= 8, --sizeOfInt) {
            }
            return sizeOfInt;
        }
        return CoderUtils.getIntegerLength(value);
    }

    public static BitString defStringToOctetString(String bhString) {
        if (bhString.length() < 4) {
            return new BitString(new byte[0]);
        }
        if (bhString.lastIndexOf(66) == bhString.length() - 1) {
            return CoderUtils.bitStringToOctetString(bhString.substring(1, bhString.length() - 2));
        }
        return CoderUtils.hexStringToOctetString(bhString.substring(1, bhString.length() - 2));
    }

    private static BitString bitStringToOctetString(String bhString) {
        boolean hasTrailBits = bhString.length() % 2 != 0;
        int trailBits = 0;
        byte[] resultBuf = new byte[bhString.length() / 8 + (hasTrailBits ? 1 : 0)];
        int currentStrPos = 0;
        for (int i = 0; i < resultBuf.length; ++i) {
            int bitCnt;
            byte bt = 0;
            for (bitCnt = currentStrPos; bitCnt < currentStrPos + 8 && bitCnt < bhString.length(); ++bitCnt) {
                if (bhString.charAt(bitCnt) == '0') continue;
                bt = (byte)(bt | 1 << 7 - (bitCnt - currentStrPos));
            }
            if (bitCnt != (currentStrPos += 8)) {
                trailBits = 8 - (currentStrPos - bitCnt);
            }
            resultBuf[i] = bt;
        }
        BitString result = new BitString(resultBuf, trailBits);
        return result;
    }

    private static BitString hexStringToOctetString(String bhString) {
        boolean hasTrailBits = bhString.length() % 2 != 0;
        BitString result = new BitString(new byte[bhString.length() / 2 + (hasTrailBits ? 1 : 0)], hasTrailBits ? 4 : 0);
        byte[] hex = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        for (int i = 0; i < result.getLength(); ++i) {
            result.getValue()[i] = (byte)(hex[bhString.charAt(i * 2) - 48] << 4);
            if (hasTrailBits && (!hasTrailBits || i >= result.getLength() - 1)) continue;
            byte[] byArray = result.getValue();
            int n = i;
            byArray[n] = (byte)(byArray[n] | (byte)(hex[bhString.charAt(i * 2 + 1) - 48] & 0xF));
        }
        return result;
    }

    public static SortedMap<Integer, Field> getSetOrder(Class<?> objectClass) {
        TreeMap<Integer, Field> fieldOrder = new TreeMap<Integer, Field>();
        int tagNA = -1;
        for (Field field : objectClass.getDeclaredFields()) {
            ASN1Element element = field.getAnnotation(ASN1Element.class);
            if (element == null) continue;
            if (element.hasTag()) {
                fieldOrder.put(element.tag(), field);
                continue;
            }
            fieldOrder.put(tagNA--, field);
        }
        return fieldOrder;
    }

    public static int getStringTagForElement(ElementInfo elementInfo) {
        int result = 19;
        if (elementInfo.hasPreparedInfo()) {
            result = ((ASN1StringMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).getStringType();
        } else if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1String.class)) {
            ASN1String value = elementInfo.getAnnotatedClass().getAnnotation(ASN1String.class);
            result = value.stringType();
        } else if (elementInfo.getParentAnnotated() != null && elementInfo.getParentAnnotated().isAnnotationPresent(ASN1String.class)) {
            ASN1String value = elementInfo.getParentAnnotated().getAnnotation(ASN1String.class);
            result = value.stringType();
        }
        return result;
    }

    public static void checkConstraints(long value, ElementInfo elementInfo) throws Exception {
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.getPreparedInfo().hasConstraint() && !elementInfo.getPreparedInfo().getConstraint().checkValue(value)) {
                throw new Exception("Length of '" + elementInfo.getAnnotatedClass().toString() + "' out of bound");
            }
        } else {
            Annotation constraint;
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1ValueRangeConstraint.class) && (value > (constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1ValueRangeConstraint.class)).max() || value < constraint.min())) {
                throw new Exception("Length of '" + elementInfo.getAnnotatedClass().toString() + "' out of bound");
            }
            if (elementInfo.getAnnotatedClass().isAnnotationPresent(ASN1SizeConstraint.class) && value != (constraint = elementInfo.getAnnotatedClass().getAnnotation(ASN1SizeConstraint.class)).max()) {
                throw new Exception("Length of '" + elementInfo.getAnnotatedClass().toString() + "' out of bound");
            }
        }
    }

    public static boolean isAnyField(Field field, ElementInfo elementInfo) {
        boolean isAny = false;
        isAny = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getTypeMetadata() instanceof ASN1AnyMetadata : field.isAnnotationPresent(ASN1Any.class);
        return isAny;
    }

    public static boolean isNullField(Field field, ElementInfo elementInfo) {
        boolean isNull = false;
        isNull = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedInfo().getTypeMetadata() instanceof ASN1NullMetadata : field.isAnnotationPresent(ASN1Null.class);
        return isNull;
    }

    public static boolean isOptionalField(Field field, ElementInfo elementInfo) {
        ASN1Element info;
        if (elementInfo.hasPreparedInfo()) {
            if (elementInfo.hasPreparedASN1ElementInfo()) {
                return elementInfo.getPreparedASN1ElementInfo().isOptional() || elementInfo.getPreparedASN1ElementInfo().hasDefaultValue();
            }
            return false;
        }
        return field.isAnnotationPresent(ASN1Element.class) && ((info = field.getAnnotation(ASN1Element.class)).isOptional() || info.hasDefaultValue());
    }

    public static boolean isOptional(ElementInfo elementInfo) {
        boolean result = false;
        result = elementInfo.hasPreparedInfo() ? elementInfo.getPreparedASN1ElementInfo().isOptional() || elementInfo.getPreparedASN1ElementInfo().hasDefaultValue() : elementInfo.getASN1ElementInfo() != null && elementInfo.getASN1ElementInfo().isOptional();
        return result;
    }

    public static void checkForOptionalField(Field field, ElementInfo elementInfo) throws Exception {
        if (CoderUtils.isOptionalField(field, elementInfo)) {
            return;
        }
        throw new IllegalArgumentException("The mandatory field '" + field.getName() + "' does not have a value!");
    }

    public static boolean isSequenceSet(ElementInfo elementInfo) {
        boolean isEqual = false;
        if (elementInfo.hasPreparedInfo()) {
            isEqual = ((ASN1SequenceMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).isSet();
        } else {
            ASN1Sequence seq = elementInfo.getAnnotatedClass().getAnnotation(ASN1Sequence.class);
            isEqual = seq.isSet();
        }
        return isEqual;
    }

    public static boolean isSequenceSetOf(ElementInfo elementInfo) {
        boolean isEqual = false;
        if (elementInfo.hasPreparedInfo()) {
            isEqual = ((ASN1SequenceOfMetadata)elementInfo.getPreparedInfo().getTypeMetadata()).isSetOf();
        } else {
            ASN1SequenceOf seq = elementInfo.getAnnotatedClass().getAnnotation(ASN1SequenceOf.class);
            isEqual = seq.isSetOf();
        }
        return isEqual;
    }

    public static Method findMethodForField(String methodName, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        try {
            return objectClass.getMethod(methodName, paramClass);
        }
        catch (NoSuchMethodException ex) {
            Method[] methods;
            for (Method method : methods = objectClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
            throw ex;
        }
    }

    public static Method findSetterMethodForField(Field field, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        String methodName = "set" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return CoderUtils.findMethodForField(methodName, objectClass, paramClass);
    }

    public static Method findDoSelectMethodForField(Field field, Class<?> objectClass, Class<?> paramClass) throws NoSuchMethodException {
        String methodName = "select" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return CoderUtils.findMethodForField(methodName, objectClass, paramClass);
    }

    public static Method findGetterMethodForField(Field field, Class<?> objectClass) throws NoSuchMethodException {
        String getterMethodName = "get" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1);
        return objectClass.getMethod(getterMethodName, null);
    }

    public static Method findIsSelectedMethodForField(Field field, Class<?> objectClass) throws NoSuchMethodException {
        String methodName = "is" + field.getName().toUpperCase().substring(0, 1) + field.getName().substring(1) + "Selected";
        return objectClass.getMethod(methodName, null);
    }

    public static boolean isMemberClass(Class<?> objectClass, ElementInfo elementInfo) {
        if (elementInfo.hasPreparedInfo()) {
            return elementInfo.getPreparedInfo().isMemberClass();
        }
        return objectClass.isMemberClass();
    }

    public static byte[] ASN1StringToBuffer(Object obj, ElementInfo elementInfo) throws UnsupportedEncodingException {
        byte[] strBuf = null;
        int stringTag = CoderUtils.getStringTagForElement(elementInfo);
        strBuf = stringTag == 12 ? obj.toString().getBytes("utf-8") : (stringTag == 30 ? obj.toString().getBytes("UnicodeBigUnmarked") : obj.toString().getBytes());
        return strBuf;
    }

    public static String bufferToASN1String(byte[] byteBuf, ElementInfo elementInfo) throws UnsupportedEncodingException {
        String result = null;
        int stringTag = CoderUtils.getStringTagForElement(elementInfo);
        result = stringTag == 12 ? new String(byteBuf, "utf-8") : (stringTag == 30 ? new String(byteBuf, "UnicodeBigUnmarked") : new String(byteBuf));
        return result;
    }

    public static Class<?> getCollectionType(ElementInfo elementInfo) {
        ParameterizedType tp = (ParameterizedType)elementInfo.getGenericInfo();
        return CoderUtils.getCollectionType(tp);
    }

    public static Class<?> getCollectionType(ParameterizedType tp) {
        Type tpParam = tp.getActualTypeArguments()[0];
        Class<byte[]> paramType = null;
        if (tpParam instanceof GenericArrayType) {
            paramType = (Class<byte[]>)((Object)((GenericArrayType)tpParam).getGenericComponentType());
            if (paramType.equals(Byte.TYPE)) {
                paramType = byte[].class;
            }
        } else {
            paramType = (Class)tp.getActualTypeArguments()[0];
        }
        return paramType;
    }
}

