/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.ber;

import org.bn.annotations.ASN1Element;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.metadata.ASN1ElementMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BERCoderUtils {
    public static DecodedObject<Integer> getTagValueForElement(ElementInfo info, int tagClass, int elemenType, int universalTag) {
        DecodedObject<Integer> result = new DecodedObject<Integer>();
        result.setSize(1);
        if (universalTag < 31) {
            result.setValue(tagClass | elemenType | universalTag);
        } else {
            result = BERCoderUtils.getTagValue(tagClass, elemenType, universalTag, universalTag, tagClass);
        }
        if (info.hasPreparedInfo()) {
            ASN1ElementMetadata meta = info.getPreparedASN1ElementInfo();
            if (meta != null && meta.hasTag()) {
                result = BERCoderUtils.getTagValue(tagClass, elemenType, universalTag, meta.getTag(), meta.getTagClass());
            }
        } else {
            ASN1Element elementInfo = null;
            if (info.getASN1ElementInfo() != null) {
                elementInfo = info.getASN1ElementInfo();
            } else if (info.getAnnotatedClass().isAnnotationPresent(ASN1Element.class)) {
                elementInfo = info.getAnnotatedClass().getAnnotation(ASN1Element.class);
            }
            if (elementInfo != null && elementInfo.hasTag()) {
                result = BERCoderUtils.getTagValue(tagClass, elemenType, universalTag, elementInfo.tag(), elementInfo.tagClass());
            }
        }
        return result;
    }

    public static DecodedObject<Integer> getTagValue(int tagClass, int elemenType, int universalTag, int userTag, int userTagClass) {
        DecodedObject<Integer> resultObj = new DecodedObject<Integer>();
        int result = tagClass | elemenType | universalTag;
        tagClass = userTagClass;
        if (userTag < 31) {
            result = tagClass | elemenType | userTag;
            resultObj.setSize(1);
        } else {
            result = tagClass | elemenType | 0x1F;
            if (userTag < 128) {
                result <<= 8;
                result |= userTag & 0x7F;
                resultObj.setSize(2);
            } else if (userTag < 16383) {
                result <<= 16;
                result |= ((userTag & 0x3FFF) >> 7 | 0x80) << 8;
                result |= userTag & 0x3FFF & 0x7F;
                resultObj.setSize(3);
            } else if (userTag < 262143) {
                result <<= 24;
                result |= ((userTag & 0x3FFFF) >> 15 | 0x80) << 16;
                result |= ((userTag & 0x3FFFF) >> 7 | 0x80) << 8;
                result |= userTag & 0x3FFFF & 0x3F;
                resultObj.setSize(4);
            }
        }
        resultObj.setValue(result);
        return resultObj;
    }
}

