/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.ber;

import java.util.ArrayList;

public class BERObjectIdentifier {
    public static byte[] Encode(int[] oidArcArray) {
        int arcLength = oidArcArray.length;
        assert (arcLength >= 2) : "Object id must contain at least 2 arcs";
        byte[] result = new byte[arcLength * 5];
        int nextAvailable = 0;
        nextAvailable += BERObjectIdentifier.EncodeFirstTwoArcs(oidArcArray[0], oidArcArray[1], result, nextAvailable);
        for (int i = 2; i < arcLength; ++i) {
            nextAvailable += BERObjectIdentifier.EncodeOneArc(oidArcArray[i], result, nextAvailable);
        }
        assert (nextAvailable <= 255) : "Encoded length of object id exceeded 255 bytes";
        byte[] ba = BERObjectIdentifier.Truncate(result, nextAvailable);
        return ba;
    }

    private static int EncodeFirstTwoArcs(int topArc, int secondArc, byte[] result, int nextAvailable) {
        assert (topArc >= 0 && topArc <= 2) : "Top-level arc must be 0, 1 or 2";
        assert (secondArc >= 0 && secondArc <= 39) : "Second-level arc must be less than 40";
        int combinedArc = topArc * 40 + secondArc;
        return BERObjectIdentifier.EncodeOneArc(combinedArc, result, nextAvailable);
    }

    private static int EncodeOneArc(int arc, byte[] result, int nextAvailable) {
        long arc1 = arc & 0x7F;
        long arc2 = (arc & 0x3F80) << 1;
        long arc3 = (arc & 0x1FC000) << 2;
        long arc4 = (arc & 0xFE00000) << 3;
        long arc5 = (arc & 0xF0000000) << 4;
        long all = arc1 | arc2 | arc3 | arc4 | arc5;
        byte[] temp = new byte[5];
        temp[4] = (byte)(all & 0xFFL);
        temp[3] = (byte)((all & 0xFF00L) >> 8);
        temp[2] = (byte)((all & 0xFF0000L) >> 16);
        temp[1] = (byte)((all & 0xFFFFFFFFFF000000L) >> 24);
        int resultLength = 1;
        if (temp[0] > 0) {
            resultLength = 5;
        } else if (temp[1] > 0) {
            resultLength = 4;
        } else if (temp[2] > 0) {
            resultLength = 3;
        } else if (temp[3] > 0) {
            resultLength = 2;
        }
        temp[0] = (byte)(temp[0] | 0x80);
        temp[1] = (byte)(temp[1] | 0x80);
        temp[2] = (byte)(temp[2] | 0x80);
        temp[3] = (byte)(temp[3] | 0x80);
        temp[4] = (byte)(temp[4] & 0x7F);
        int sourceIndex = 5 - resultLength;
        System.arraycopy(temp, sourceIndex, result, nextAvailable, resultLength);
        return resultLength;
    }

    private static byte[] Truncate(byte[] b1, int nextAvailable) {
        byte[] b2 = new byte[nextAvailable];
        System.arraycopy(b1, 0, b2, 0, nextAvailable);
        return b2;
    }

    public static String Decode(byte[] oidBytes) {
        int arc2;
        int arc1;
        int[] intArray1 = BERObjectIdentifier.BerByteArrayToIntArray(oidBytes);
        assert (intArray1.length >= 1) : "Object id must contain at least 2 arcs";
        int[] intArray2 = new int[intArray1.length + 1];
        int combinedArc = intArray1[0];
        if (combinedArc < 40) {
            arc1 = 0;
            arc2 = combinedArc;
        } else if (combinedArc < 80) {
            arc1 = 1;
            arc2 = combinedArc - 40;
        } else {
            arc1 = 2;
            arc2 = combinedArc - 80;
        }
        intArray2[0] = arc1;
        intArray2[1] = arc2;
        System.arraycopy(intArray1, 1, intArray2, 2, intArray2.length - 2);
        return BERObjectIdentifier.IntArrayToDottedDecimal(intArray2);
    }

    public static String IntArrayToDottedDecimal(int[] oidIntArray) {
        StringBuilder sb = new StringBuilder(oidIntArray.length * 4);
        for (int i = 0; i < oidIntArray.length; ++i) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(new Integer(oidIntArray[i]).toString().trim());
        }
        return sb.toString();
    }

    public static int[] BerByteArrayToIntArray(byte[] berBytes) {
        ArrayList<Integer> intArrayList = new ArrayList<Integer>();
        ArrayList<Byte> oneArcSequence = new ArrayList<Byte>();
        int byteCount = 0;
        for (int i = 0; i < berBytes.length; ++i) {
            if ((berBytes[i] & 0x80) == 0) {
                oneArcSequence.add(berBytes[i]);
                intArrayList.add(BERObjectIdentifier.DecodeOneArc(oneArcSequence));
                oneArcSequence = new ArrayList();
                byteCount = 0;
                continue;
            }
            assert (byteCount < 5) : "Conversion can only handle 5 bytes";
            oneArcSequence.add(berBytes[i]);
            ++byteCount;
        }
        int[] ints = new int[intArrayList.size()];
        for (int i = 0; i < ints.length; ++i) {
            Integer integer = (Integer)intArrayList.get(i);
            ints[i] = integer;
        }
        return ints;
    }

    private static int DecodeOneArc(ArrayList berByteList) {
        int i;
        assert (berByteList.size() >= 1 && berByteList.size() <= 5) : "Conversion requires from 1 to 5 bytes";
        long all = 0L;
        int startByteIndex = berByteList.size() - 1;
        byte[] berBytes = new byte[berByteList.size()];
        for (i = 0; i < berBytes.length; ++i) {
            Byte bb = (Byte)berByteList.get(i);
            berBytes[i] = bb;
        }
        for (i = 0; i <= startByteIndex; ++i) {
            berBytes[i] = (byte)(berBytes[i] & 0x7F);
            if (i != 0) {
                all <<= 7;
            }
            all |= (long)berBytes[i];
        }
        return (int)all;
    }
}

