/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.der;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.SortedMap;
import org.bn.annotations.ASN1Sequence;
import org.bn.coders.CoderUtils;
import org.bn.coders.ElementInfo;
import org.bn.coders.ber.BERCoderUtils;
import org.bn.coders.ber.BEREncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEREncoder<T>
extends BEREncoder<T> {
    @Override
    public int encodeSequence(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        ASN1Sequence seqInfo = elementInfo.getAnnotatedClass().getAnnotation(ASN1Sequence.class);
        if (!CoderUtils.isSequenceSet(elementInfo)) {
            return super.encodeSequence(object, stream, elementInfo);
        }
        int resultSize = 0;
        Field[] fields = null;
        if (elementInfo.hasPreparedInfo()) {
            fields = elementInfo.getPreparedInfo().getFields();
        } else {
            SortedMap<Integer, Field> fieldOrder = CoderUtils.getSetOrder(object.getClass());
            fields = new Field[]{};
            fields = fieldOrder.values().toArray(fields);
        }
        for (int i = 0; i < fields.length; ++i) {
            resultSize += this.encodeSequenceField(object, fields.length - 1 - i, fields[fields.length - 1 - i], stream, elementInfo);
        }
        resultSize += this.encodeHeader(BERCoderUtils.getTagValueForElement(elementInfo, 0, 32, 17), resultSize, stream);
        return resultSize;
    }
}

