/*
 * Decompiled with CFR 0.152.
 */
package org.bn.coders.per;

import java.io.OutputStream;
import org.bn.coders.ElementInfo;
import org.bn.coders.per.PERAlignedEncoder;
import org.bn.coders.per.PERCoderUtils;
import org.bn.utils.BitArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PERUnalignedEncoder<T>
extends PERAlignedEncoder<T> {
    @Override
    protected int encodeConstraintNumber(long value, long min, long max, BitArrayOutputStream stream) throws Exception {
        int result = 0;
        long valueRange = max - min;
        long narrowedVal = value - min;
        int maxBitLen = PERCoderUtils.getMaxBitLength(valueRange);
        if (valueRange == 0L) {
            return result;
        }
        int currentBit = maxBitLen;
        while (currentBit > 8) {
            ++result;
            stream.write((int)(narrowedVal >>> (currentBit -= 8)));
        }
        if (currentBit > 0) {
            for (int i = currentBit - 1; i >= 0; --i) {
                int bitValue = (int)(narrowedVal >> i & 1L);
                stream.writeBit(bitValue);
            }
            ++result;
        }
        return result;
    }

    @Override
    public int encodeString(Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        int resultSize = 0;
        if (!PERCoderUtils.is7BitEncodedString(elementInfo)) {
            resultSize = super.encodeString(object, stream, elementInfo);
        } else {
            byte[] value = object.toString().getBytes();
            resultSize = this.encodeLength(value.length, elementInfo, stream);
            if (value.length == 0) {
                return resultSize;
            }
            BitArrayOutputStream bitStream = (BitArrayOutputStream)stream;
            for (int i = 0; i < value.length; ++i) {
                bitStream.writeBits(value[i], 7);
            }
        }
        return resultSize;
    }

    @Override
    protected void doAlign(OutputStream stream) {
    }
}

