/*
 * Decompiled with CFR 0.152.
 */
package org.bn.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.bn.annotations.ASN1BoxedType;
import org.bn.coders.ASN1PreparedElementData;
import org.bn.coders.CoderUtils;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1PreparedElement;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.coders.IASN1TypesDecoder;
import org.bn.coders.IASN1TypesEncoder;
import org.bn.metadata.ASN1ElementMetadata;
import org.bn.metadata.ASN1FieldMetadata;

public class ASN1BoxedTypeMetadata
extends ASN1FieldMetadata {
    private Field valueField;
    private ASN1PreparedElementData valueFieldMeta;

    public ASN1BoxedTypeMetadata(String name) {
        super(name);
    }

    public ASN1BoxedTypeMetadata(Class objClass, ASN1BoxedType annotation) {
        this(annotation.name());
        this.setupValueField(objClass);
    }

    public void setupValueField(Class objClass) {
        try {
            this.valueField = objClass.getDeclaredField("value");
            this.valueFieldMeta = new ASN1PreparedElementData(objClass, this.valueField);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public int encode(IASN1TypesEncoder encoder, Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        Object result = null;
        ASN1ElementMetadata saveInfo = elementInfo.getPreparedASN1ElementInfo();
        elementInfo.setPreparedInfo(this.valueFieldMeta);
        if (!CoderUtils.isNullField(this.valueField, elementInfo)) {
            result = encoder.invokeGetterMethodForField(this.valueField, object, elementInfo);
        }
        if (saveInfo != null) {
            if (!saveInfo.hasTag() && elementInfo.hasPreparedASN1ElementInfo() && elementInfo.getPreparedASN1ElementInfo().hasTag()) {
                ASN1ElementMetadata elData = new ASN1ElementMetadata(saveInfo.getName(), saveInfo.isOptional(), elementInfo.getPreparedASN1ElementInfo().hasTag(), elementInfo.getPreparedASN1ElementInfo().isImplicitTag(), elementInfo.getPreparedASN1ElementInfo().getTagClass(), elementInfo.getPreparedASN1ElementInfo().getTag(), saveInfo.hasDefaultValue());
                elementInfo.setPreparedASN1ElementInfo(elData);
            } else {
                elementInfo.setPreparedASN1ElementInfo(saveInfo);
            }
        }
        return this.valueFieldMeta.getTypeMetadata().encode(encoder, result, stream, elementInfo);
    }

    public DecodedObject decode(IASN1TypesDecoder decoder, DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        DecodedObject decodedResult;
        IASN1PreparedElementData saveInfo = elementInfo.getPreparedInfo();
        IASN1PreparedElement instance = (IASN1PreparedElement)elementInfo.getPreparedInstance();
        ASN1ElementMetadata saveElemInfo = elementInfo.getPreparedASN1ElementInfo();
        elementInfo.setPreparedInfo(this.valueFieldMeta);
        elementInfo.setGenericInfo(this.valueField.getGenericType());
        if (elementInfo.getPreparedInfo().isMemberClass()) {
            elementInfo.setParentObject(elementInfo.getPreparedInstance());
        }
        if (saveElemInfo != null) {
            if (!saveElemInfo.hasTag() && elementInfo.hasPreparedASN1ElementInfo() && elementInfo.getPreparedASN1ElementInfo().hasTag()) {
                ASN1ElementMetadata elData = new ASN1ElementMetadata(saveElemInfo.getName(), saveElemInfo.isOptional(), elementInfo.getPreparedASN1ElementInfo().hasTag(), elementInfo.getPreparedASN1ElementInfo().isImplicitTag(), elementInfo.getPreparedASN1ElementInfo().getTagClass(), elementInfo.getPreparedASN1ElementInfo().getTag(), saveElemInfo.hasDefaultValue());
                elementInfo.setPreparedASN1ElementInfo(elData);
            } else {
                elementInfo.setPreparedASN1ElementInfo(saveElemInfo);
            }
        }
        if ((decodedResult = this.valueFieldMeta.getTypeMetadata().decode(decoder, decodedTag, this.valueField.getType(), elementInfo, stream)) != null && !CoderUtils.isNullField(this.valueField, elementInfo)) {
            decoder.invokeSetterMethodForField(this.valueField, instance, decodedResult.getValue(), elementInfo);
        }
        elementInfo.setPreparedInfo(saveInfo);
        elementInfo.setPreparedInstance(instance);
        elementInfo.setPreparedASN1ElementInfo(saveElemInfo);
        if (decodedResult != null) {
            return new DecodedObject<IASN1PreparedElement>(instance, decodedResult.getSize());
        }
        return decodedResult;
    }
}

