/*
 * Decompiled with CFR 0.152.
 */
package org.bn.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import org.bn.annotations.ASN1String;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1TypesDecoder;
import org.bn.coders.IASN1TypesEncoder;
import org.bn.metadata.ASN1FieldMetadata;

public class ASN1StringMetadata
extends ASN1FieldMetadata {
    private boolean isUCS = false;
    private int stringType = 19;
    private boolean hasDefaults = false;

    public ASN1StringMetadata() {
        this.hasDefaults = true;
    }

    public ASN1StringMetadata(ASN1String annotation) {
        this(annotation.name(), annotation.isUCS(), annotation.stringType());
    }

    public ASN1StringMetadata(String name, boolean isUCS, int stringType) {
        super(name);
        this.isUCS = isUCS;
        this.stringType = stringType;
    }

    public boolean isUCS() {
        return this.isUCS;
    }

    public int getStringType() {
        return this.stringType;
    }

    public void setParentAnnotated(AnnotatedElement parent) {
        if (parent != null && parent.isAnnotationPresent(ASN1String.class)) {
            ASN1String value = parent.getAnnotation(ASN1String.class);
            this.stringType = value.stringType();
        }
    }

    public int encode(IASN1TypesEncoder encoder, Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        return encoder.encodeString(object, stream, elementInfo);
    }

    public DecodedObject decode(IASN1TypesDecoder decoder, DecodedObject decodedTag, Class objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        return decoder.decodeString(decodedTag, objectClass, elementInfo, stream);
    }
}

