/*
 * Decompiled with CFR 0.152.
 */
package org.bn.utils;

import java.io.ByteArrayOutputStream;

public class BitArrayOutputStream
extends ByteArrayOutputStream {
    int currentBit = 0;

    public BitArrayOutputStream() {
        super(1024);
    }

    public BitArrayOutputStream(int initialSize) {
        super(initialSize);
    }

    public void align() {
        this.currentBit = 0;
    }

    public synchronized void write(int b) {
        if (this.currentBit == 0) {
            super.write(b);
        } else {
            byte nBt;
            byte lBt = this.buf[this.count - 1];
            this.buf[this.count - 1] = nBt = (byte)(lBt | b >> this.currentBit);
            lBt = (byte)(b << 8 - this.currentBit);
            super.write(lBt);
        }
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        if (this.currentBit == 0) {
            super.write(b, off, len);
        } else {
            byte lBt = this.buf[this.count - 1];
            for (int i = off; i < off + len; ++i) {
                int bufByte = b[i] < 0 ? 256 + b[i] : b[i];
                byte nBt = (byte)(lBt | bufByte >> this.currentBit);
                if (i == off) {
                    this.buf[this.count - 1] = nBt;
                } else {
                    super.write(nBt);
                }
                lBt = (byte)(bufByte << 8 - this.currentBit);
            }
            super.write(lBt);
        }
    }

    public void writeBit(boolean value) {
        this.writeBit(value ? 1 : 0);
    }

    public synchronized void writeBit(int bit) {
        if (this.currentBit < 8 && this.currentBit > 0) {
            if (bit != 0) {
                int n = this.count - 1;
                this.buf[n] = (byte)(this.buf[n] | (byte)(128 >> this.currentBit));
            }
        } else {
            super.write(bit == 0 ? 0 : 128);
        }
        ++this.currentBit;
        if (this.currentBit >= 8) {
            this.currentBit = 0;
        }
    }

    public synchronized void writeBits(int bt, int count) {
        for (int i = count - 1; i >= 0; --i) {
            this.writeBit(bt >> i & 1);
        }
    }

    public void reset() {
        this.currentBit = 0;
        super.reset();
    }

    public int getTrailBitsCnt() {
        return this.currentBit;
    }
}

