/*
 * Decompiled with CFR 0.152.
 */
package org.bn.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ReverseByteArrayOutputStream
extends ByteArrayOutputStream {
    public ReverseByteArrayOutputStream() {
        super(1024);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        byte[] bufTmp = this.toByteArray();
        out.write(bufTmp, 0, bufTmp.length);
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, this.buf.length - this.count, newbuf, 0, this.count);
        return newbuf;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), enc);
    }

    public synchronized void write(int b) {
        int newcount = this.count + 1;
        this.resizeBuffer(newcount);
        this.buf[this.buf.length - 1 - this.count] = (byte)b;
        this.count = newcount;
    }

    protected void resizeBuffer(int newcount) {
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, this.buf.length - this.count, newbuf, newbuf.length - this.count, this.count);
            this.buf = newbuf;
        }
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        this.resizeBuffer(newcount);
        System.arraycopy(b, off, this.buf, this.buf.length - this.count - len, len);
        this.count = newcount;
    }
}

