/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransEditDistance;
import com.cognirel.cognitrans.CogniTransTranslator;
import com.cognirel.cognitrans.CogniTransTransliterationProvider;
import com.cognirel.cognitrans.EditDistance;
import com.cognirel.cognitrans.Language;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.ArrayList;
import java.util.Arrays;

public class AddressMatcher {
    private Language m_lang1;
    private Language m_lang2;
    private boolean syncDict;

    public AddressMatcher(Language lang1, Language lang2, boolean syncPersist) {
        this.m_lang1 = lang1;
        this.m_lang2 = lang2;
        this.syncDict = syncPersist;
    }

    public double match(String sAddr1, String sAddr2) {
        boolean swapped;
        String[] sFields1 = sAddr1.split("[,\u060c]");
        String[] sFields2 = sAddr2.split("[,\u060c]");
        CogniTransTranslator translator = CogniTransTransliterationProvider.translators.get(Language.getAliases(this.m_lang2)[0]);
        int i = 0;
        while (i < sFields1.length) {
            sFields1[i] = sFields1[i].toLowerCase().trim();
            if (this.m_lang1 == Language.ENGLISH && this.m_lang2 != Language.ENGLISH && translator != null) {
                sFields1[i] = translator.applyRule("equivalence", sFields1[i]);
            }
            ++i;
        }
        translator = CogniTransTransliterationProvider.translators.get(Language.getAliases(this.m_lang1)[0]);
        i = 0;
        while (i < sFields2.length) {
            sFields2[i] = sFields2[i].toLowerCase().trim();
            if (this.m_lang1 != Language.ENGLISH && this.m_lang2 == Language.ENGLISH && translator != null) {
                sFields2[i] = translator.applyRule("equivalence", sFields2[i]);
            }
            ++i;
        }
        int nMax = Math.max(sFields1.length, sFields2.length);
        int nMin = Math.min(sFields1.length, sFields2.length);
        String[] sLarge = sFields1.length >= sFields2.length ? sFields1 : sFields2;
        String[] sSmall = sFields1.length < sFields2.length ? sFields1 : sFields2;
        boolean bl = swapped = sFields1.length < sFields2.length;
        if (swapped) {
            this.swapLanguages();
        }
        double iWeight = 1 << nMin;
        double iTotalWeight = 0.0;
        double fTotalScore = 0.0;
        int i2 = nMin - 1;
        while (i2 >= 0) {
            double fMaxScore = -1.0;
            int j = nMax - 1;
            while (j >= 0) {
                double fScore;
                String[] smallWords = sSmall[i2].split("\\s+");
                String[] largeWords = sLarge[j].split("\\s+");
                if (sSmall[i2].isEmpty() || largeWords.length == 0) {
                    fMaxScore = 0.0;
                    break;
                }
                if (!sLarge[j].isEmpty() && smallWords.length != 0 && (fScore = this.compareAddressLines(largeWords, smallWords)) > fMaxScore) {
                    fMaxScore = fScore;
                }
                --j;
            }
            double score = 1.0 * iWeight * fMaxScore;
            fTotalScore += score;
            iTotalWeight += iWeight;
            if (fMaxScore < 0.4) {
                iWeight /= 2.0;
            }
            --i2;
        }
        fTotalScore /= iTotalWeight;
        fTotalScore = fTotalScore * (double)nMin / (1.0 * (double)nMax);
        return fTotalScore;
    }

    private double compareAddressLines(String[] sWords1, String[] sWords2) {
        int n1 = sWords1.length;
        int n2 = sWords2.length;
        int nMax = Math.max(n1, n2);
        int nMin = Math.min(n1, n2);
        boolean swapped = n1 < n2;
        String[] sLarge = n1 >= n2 ? sWords1 : sWords2;
        String[] sSmall = n1 < n2 ? sWords1 : sWords2;
        String regLang1 = Language.getLanguageName(this.m_lang1);
        String regLang2 = Language.getLanguageName(this.m_lang2);
        double fTotalScore = 0.0;
        int i = 0;
        while (i < nMin) {
            double fMaxScore = -1.0;
            int j = 0;
            while (j < nMax) {
                double fScore;
                if (sLarge[j] == "") {
                    return 0.0;
                }
                double d = fScore = swapped ? this.compareAddressWord(sLarge[j], regLang2, sSmall[i], regLang1) : this.compareAddressWord(sLarge[j], regLang1, sSmall[i], regLang2);
                if (fScore > fMaxScore) {
                    fMaxScore = fScore;
                }
                ++j;
            }
            fTotalScore += fMaxScore;
            ++i;
        }
        return fTotalScore /= (double)nMin;
    }

    private double compareAddressWord(String string1, String regLang1, String string2, String regLang2) {
        if (string1 == "" || string2 == "") {
            return 0.0;
        }
        if (regLang1.equals("english") && regLang2.equals("english")) {
            return this.match2Words(string1, string2);
        }
        if (regLang1.equals("english") && !regLang2.equals("english")) {
            String[] tmpLocalSuggestions;
            TransliterationHints[] hint = this.syncDict ? new TransliterationHints[]{TransliterationHints.PERSIST, TransliterationHints.TRANSLATE} : new TransliterationHints[]{TransliterationHints.TRANSLATE};
            String tmpLocal = CogniTransEditDistance.qp.transliterate(string1, regLang2, hint);
            String[] tmp2 = CogniTransEditDistance.qp.rsuggest(string2, regLang2, new TransliterationHints[0]);
            String[] tmp1 = CogniTransEditDistance.qp.rsuggest(tmpLocal, regLang2, new TransliterationHints[0]);
            String[] stringArray = tmpLocalSuggestions = CogniTransEditDistance.qp.suggest(string1, regLang2, new TransliterationHints[0]);
            int n = tmpLocalSuggestions.length;
            int n2 = 0;
            while (n2 < n) {
                String localSuggestion = stringArray[n2];
                String[] tmp = CogniTransEditDistance.qp.rsuggest(localSuggestion, regLang2, new TransliterationHints[0]);
                int index = 0;
                while (index < tmp.length && index < 3) {
                    tmp1 = this.addReverseTranslateOption(tmp1, tmp[index]);
                    ++index;
                }
                ++n2;
            }
            String sRevTransLated2 = this.findUninflectedTranslation(string2, regLang2);
            tmp2 = this.addReverseTranslateOption(tmp2, sRevTransLated2);
            return this.match2WordsArrays(tmp1, tmp2);
        }
        if (!regLang1.equals("english") && regLang2.equals("english")) {
            String[] tmpLocalSuggestions;
            TransliterationHints[] hint = this.syncDict ? new TransliterationHints[]{TransliterationHints.PERSIST, TransliterationHints.TRANSLATE} : new TransliterationHints[]{TransliterationHints.TRANSLATE};
            String tmpLocal = CogniTransEditDistance.qp.transliterate(string2, regLang1, hint);
            String[] tmp1 = CogniTransEditDistance.qp.rsuggest(string1, regLang1, new TransliterationHints[0]);
            String[] tmp2 = CogniTransEditDistance.qp.rsuggest(tmpLocal, regLang1, new TransliterationHints[0]);
            String[] stringArray = tmpLocalSuggestions = CogniTransEditDistance.qp.suggest(string2, regLang1, new TransliterationHints[0]);
            int n = tmpLocalSuggestions.length;
            int n3 = 0;
            while (n3 < n) {
                String localSugestion = stringArray[n3];
                String[] tmp = CogniTransEditDistance.qp.rsuggest(localSugestion, regLang1, new TransliterationHints[0]);
                int index = 0;
                while (index < tmp.length && index < 3) {
                    tmp2 = this.addReverseTranslateOption(tmp2, tmp[index]);
                    ++index;
                }
                ++n3;
            }
            String sRevTransLated1 = this.findUninflectedTranslation(string1, regLang1);
            tmp1 = this.addReverseTranslateOption(tmp1, sRevTransLated1);
            return this.match2WordsArrays(tmp1, tmp2);
        }
        TransliterationHints[] hint = this.syncDict ? new TransliterationHints[]{TransliterationHints.PERSIST, TransliterationHints.TRANSLATE} : new TransliterationHints[]{TransliterationHints.TRANSLATE};
        String[] tmp1 = CogniTransEditDistance.qp.rsuggest(string1, regLang1, hint);
        String[] tmp2 = CogniTransEditDistance.qp.rsuggest(string2, regLang2, hint);
        String sRevTransLated1 = this.findUninflectedTranslation(string1, regLang1);
        String sRevTransLated2 = this.findUninflectedTranslation(string2, regLang2);
        tmp1 = this.addReverseTranslateOption(tmp1, sRevTransLated1);
        tmp2 = this.addReverseTranslateOption(tmp2, sRevTransLated2);
        return this.match2WordsArrays(tmp1, tmp2);
    }

    public String[] addReverseTranslateOption(String[] sOpts, String sRevTranslated) {
        if (!sRevTranslated.equals("")) {
            ArrayList<String> a2 = new ArrayList<String>(Arrays.asList(sOpts));
            a2.add(sRevTranslated);
            sOpts = a2.toArray(sOpts);
        }
        return sOpts;
    }

    private double match2WordsArrays(String[] sWords1, String[] sWords2) {
        int n1 = sWords1.length;
        int n2 = sWords2.length;
        int nMax = Math.max(n1, n2);
        int nMin = Math.min(n1, n2);
        String[] sLarge = n1 > n2 ? sWords1 : sWords2;
        String[] sSmall = n1 <= n2 ? sWords1 : sWords2;
        double fMaxScore = -1.0;
        int i = 0;
        while (i < nMin) {
            int j = 0;
            while (j < nMax) {
                double fScore = this.match2Words(sSmall[i], sLarge[j]);
                if (fScore > fMaxScore) {
                    fMaxScore = fScore;
                }
                ++j;
            }
            ++i;
        }
        return fMaxScore;
    }

    private double match2Words(String string1, String string2) {
        String rexNumber;
        double score = 0.0;
        String rexNonDigit = "[^0-9]+";
        if (string1.matches("[^0-9]*[0-9]+[^0-9]*") && string2.matches("[^0-9]*[0-9]+[^0-9]*")) {
            string2 = string2.replaceAll(rexNonDigit, "");
            string1 = string1.replaceAll(rexNonDigit, "");
        }
        if (string1.matches(rexNumber = "^[0-9]+$")) {
            return string1.equals(string2) ? 1 : 0;
        }
        String[] words = new String[]{string1, string2};
        boolean[] isInitial = new boolean[2];
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (word.length() == 1 && word.matches("[a-z]+")) {
                isInitial[i] = true;
            }
            ++i;
        }
        if (isInitial[0] && isInitial[1] && string1.equals(string2)) {
            score = 1.0;
        } else if (isInitial[0] || isInitial[1]) {
            if (words[0].charAt(0) == words[1].charAt(0)) {
                score = 0.75;
            }
        } else {
            score = EditDistance.getBigramMatch(words);
        }
        return score;
    }

    private int getLeftMatch(String s1, String s2) {
        int nMin = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < nMin) {
            if (s1.charAt(i) != s2.charAt(i)) break;
            ++i;
        }
        return i;
    }

    private int getRiteMatch(String s1, String s2) {
        int nMin = Math.min(s1.length(), s2.length());
        int i = 1;
        while (i <= nMin) {
            if (s1.charAt(s1.length() - i) != s2.charAt(s2.length() - i)) break;
            ++i;
        }
        return i - 1;
    }

    public BestMatch getBestStr(ArrayList<CogniTransTranslator.TranslateRule> opts, String sIn, MatchDir dir) {
        double fMin = 1.0;
        BestMatch ret = new BestMatch();
        int nMatched = 0;
        for (CogniTransTranslator.TranslateRule t : opts) {
            int nMax;
            String sOpt;
            nMatched = dir == MatchDir.MatchLeft ? this.getLeftMatch(sIn, sOpt) : this.getRiteMatch(sIn, sOpt);
            double fDist = 1.0 - (double)nMatched / (double)(nMax = Math.max((sOpt = t.substitute).length(), sIn.length()));
            if (!(fDist < fMin)) continue;
            fMin = fDist;
            ret.sRegex = t.regex;
            ret.sSubst = t.substitute;
            ret.fMinDist = fDist;
            ret.nMatched = nMatched;
        }
        return ret;
    }

    public String findUninflectedTranslation(String sInf, String sLang) {
        String sRegEx;
        int nLeftMatch;
        CogniTransTranslator translator = CogniTransTransliterationProvider.translators.get(sLang.toLowerCase());
        BestMatch matchTrns = this.getBestStr(translator.allRules.get("translate"), sInf, MatchDir.MatchLeft);
        BestMatch matchTrnsSwap = this.getBestStr(translator.allRules.get("translate_swap"), sInf, MatchDir.MatchLeft);
        BestMatch matchInfl = this.getBestStr(translator.allRules.get("inflexion"), sInf, MatchDir.MatchRite);
        int nRightMatch = matchInfl.nMatched;
        if (matchTrns.nMatched > matchTrnsSwap.nMatched) {
            nLeftMatch = matchTrns.nMatched;
            sRegEx = matchTrns.sRegex;
        } else {
            nLeftMatch = matchTrnsSwap.nMatched;
            sRegEx = matchTrnsSwap.sRegex;
        }
        int nSubstMismatch = matchTrns.sSubst.length() - (nLeftMatch + nRightMatch);
        int nMainMismatch = sInf.length() - (nLeftMatch + nRightMatch);
        int nMismatch = Math.max(nSubstMismatch, nMainMismatch);
        if (nMismatch < 2) {
            return sRegEx.replaceAll("[^a-z/s+]", "");
        }
        return "";
    }

    private void swapLanguages() {
        Language x = this.m_lang1;
        this.m_lang1 = this.m_lang2;
        this.m_lang2 = x;
    }

    class BestMatch {
        public String sRegex = "";
        public String sSubst = "";
        public double fMinDist = 1.0;
        public int nMatched = 0;

        BestMatch() {
        }
    }

    static enum MatchDir {
        MatchLeft,
        MatchRite;

    }
}

