/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.AddressMatcher;
import com.cognirel.cognitrans.CogniTransTransliterationProvider;
import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.NameMatcher;
import com.cognirel.cognitrans.exceptions.LanguageMismatchException;
import com.cognirel.cognitrans.exceptions.LanguageNotSupportedException;
import com.cognirel.util.CogniLogger;
import in.gov.uidai.translit.spi.IEditDistance;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.Hashtable;

public class CogniTransEditDistance
implements IEditDistance {
    private static Hashtable<String, Language> languages = new Hashtable();
    private static String delims = "[#\\-\\./\\()':\"]";
    static CogniTransTransliterationProvider qp = new CogniTransTransliterationProvider();

    public CogniTransEditDistance() {
        this.addLanguageAliases(Language.ASSAMESE);
        this.addLanguageAliases(Language.BENGALI);
        this.addLanguageAliases(Language.GUJARATI);
        this.addLanguageAliases(Language.HINDI);
        this.addLanguageAliases(Language.KANNADA);
        this.addLanguageAliases(Language.KONKANI);
        this.addLanguageAliases(Language.MALAYALAM);
        this.addLanguageAliases(Language.MANIPURI);
        this.addLanguageAliases(Language.MARATHI);
        this.addLanguageAliases(Language.NEPALI);
        this.addLanguageAliases(Language.ORIYA);
        this.addLanguageAliases(Language.PUNJABI);
        this.addLanguageAliases(Language.TAMIL);
        this.addLanguageAliases(Language.TELUGU);
        this.addLanguageAliases(Language.URDU);
        this.addLanguageAliases(Language.ENGLISH);
    }

    private void addLanguageAliases(Language l) {
        String[] aliases;
        String[] stringArray = aliases = Language.getAliases(l);
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            String al = alias.toLowerCase();
            languages.put(al, l);
            ++n2;
        }
    }

    public boolean supports(String locale1, String locale2) {
        return languages.containsKey(locale1.toLowerCase()) && languages.containsKey(locale2.toLowerCase());
    }

    private boolean shouldWePersist(TransliterationHints ... hints) {
        TransliterationHints[] transliterationHintsArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            TransliterationHints x = transliterationHintsArray[n2];
            if (x.equals((Object)TransliterationHints.PERSIST)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int findSimilarity(String text1, String locale1, String text2, String locale2, TransliterationHints ... hints) {
        String errorMsg;
        Object lang1;
        String lang;
        locale1 = locale1.toLowerCase();
        locale2 = locale2.toLowerCase();
        text1 = text1.trim();
        text2 = text2.trim();
        text1 = text1.replaceAll(delims, "");
        text2 = text2.replaceAll(delims, "");
        if (languages.get(locale1) == null) {
            String errorMsg2 = "First Language not supported: " + locale1;
            CogniLogger.error(errorMsg2, new LanguageNotSupportedException(errorMsg2));
            throw new LanguageNotSupportedException(errorMsg2);
        }
        if (languages.get(locale2) == null) {
            String errorMsg3 = "Second language not supported: " + locale2;
            CogniLogger.error(errorMsg3, new LanguageNotSupportedException(errorMsg3));
            throw new LanguageNotSupportedException(errorMsg3);
        }
        Language langText1 = languages.get(locale1);
        Language langText2 = languages.get(locale2);
        String[] langSetText1 = Language.getLanguagesOnUnicode(text1);
        String[] langSetText2 = Language.getLanguagesOnUnicode(text2);
        boolean exceptionFlag = true;
        String[] stringArray = langSetText1;
        int n = langSetText1.length;
        int n2 = 0;
        while (n2 < n) {
            lang = stringArray[n2];
            lang1 = languages.get(lang);
            if (lang1 == langText1) {
                exceptionFlag = false;
                break;
            }
            ++n2;
        }
        if (exceptionFlag) {
            errorMsg = "locale1: " + locale1 + " does not match the language of text1: " + text1;
            CogniLogger.error(errorMsg, new LanguageMismatchException(errorMsg));
            throw new LanguageMismatchException(errorMsg);
        }
        stringArray = langSetText2;
        n = langSetText2.length;
        n2 = 0;
        while (n2 < n) {
            lang = stringArray[n2];
            lang1 = languages.get(lang);
            if (lang1 == langText2) {
                exceptionFlag = false;
                break;
            }
            ++n2;
        }
        if (exceptionFlag) {
            errorMsg = "locale2: " + locale2 + " does not match the language of text2: " + text2;
            CogniLogger.error(errorMsg, new LanguageMismatchException(errorMsg));
            throw new LanguageMismatchException(errorMsg);
        }
        TransliterationHints hint = TransliterationHints.ADDRESS;
        lang1 = hints;
        int n3 = hints.length;
        n = 0;
        while (n < n3) {
            TransliterationHints x = lang1[n];
            if (x == TransliterationHints.NAME) {
                hint = x;
                break;
            }
            ++n;
        }
        boolean syncPersist = this.shouldWePersist(hints);
        try {
            if (hint == TransliterationHints.NAME) {
                NameMatcher nm = new NameMatcher(syncPersist);
                if (text1.length() < text2.length()) {
                    String sTemp = text1;
                    text1 = text2;
                    text2 = sTemp;
                    Language lTemp = langText1;
                    langText1 = langText2;
                    langText2 = lTemp;
                }
                double score = nm.match(text1, langText1, text2, langText2);
                return (int)(score * 100.0);
            }
            if (hint == TransliterationHints.ADDRESS) {
                AddressMatcher am = new AddressMatcher(langText1, langText2, syncPersist);
                double score = am.match(text1, text2);
                return (int)(score * 100.0);
            }
            return 0;
        }
        catch (Exception e) {
            String errorMsg4 = "Error in Fuzzy Matching: " + text1 + " (" + locale1 + ")\t" + text2 + "(" + locale2 + ")";
            CogniLogger.error(errorMsg4, e);
            throw new IllegalArgumentException(errorMsg4);
        }
    }
}

