/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.NumberProcessor;
import com.cognirel.cognitrans.engine.Charmap;
import com.cognirel.cognitrans.engine.CogniTransLanguage;
import com.cognirel.cognitrans.engine.Dictionary;
import com.cognirel.cognitrans.engine.ExtraDictionary;
import com.cognirel.cognitrans.engine.OldUserDictException;
import com.cognirel.cognitrans.engine.Option;
import com.cognirel.cognitrans.engine.PredictiveFeatures;
import com.cognirel.cognitrans.engine.UserDictionary;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CogniTransEngine {
    private CogniTransLanguage ql;
    private Language lang;
    private Pattern NumPattern;
    private Pattern NumOrLetterPattern;
    private ExtraDictionary englishDict;
    private ExtraDictionary specialWords;
    private UserDictionary userWords;
    static Hashtable<String, String> splCharsReplacement = new Hashtable();

    private void addSplCharReplacements() {
        splCharsReplacement.put("&", "and");
    }

    public CogniTransEngine(Language _lang, boolean persistSync) {
        this.addSplCharReplacements();
        this.lang = _lang;
        this.NumPattern = Pattern.compile("([0-9]+)(st|nd|rd|th)");
        this.NumOrLetterPattern = Pattern.compile("[a-zA-Z]+|[0-9]+");
        this.englishDict = new ExtraDictionary();
        this.englishDict.loadDict(this.path("english.txt"));
        this.englishDict.loadClash(this.path("clash.txt"));
        this.specialWords = new ExtraDictionary();
        this.specialWords.loadDict(this.path("special.txt"));
        this.userWords = new UserDictionary(this.lang, persistSync);
        PredictiveFeatures pf = new PredictiveFeatures(this.path("predictiveFeatures.dat"));
        Charmap cmap = null;
        Dictionary dict = new Dictionary();
        dict.load(this.path("dict.dat"), this.path("vowels.txt"), this.path("mathras.txt"));
        this.ql = new CogniTransLanguage(this.lang, this.path(""), pf, cmap, dict);
        this.ql.load();
    }

    private String numberPreproc(String input) {
        StringBuffer sb = new StringBuffer();
        Pattern p = this.NumPattern;
        Matcher result = p.matcher(input);
        while (result.find()) {
            String num = result.group(1);
            String suffix = result.group(2);
            result.appendReplacement(sb, NumberProcessor.numProc(this.lang, num, suffix)[0]);
        }
        result.appendTail(sb);
        return sb.toString();
    }

    public String[] transliterate(String input) {
        if (input.matches("^[0-9]+(st|nd|rd|th)$")) {
            Pattern p = this.NumPattern;
            Matcher result = p.matcher(input);
            if (result.find()) {
                String num = result.group(1);
                String suffix = result.group(2);
                return NumberProcessor.numProc(this.lang, num, suffix);
            }
            return null;
        }
        if (input.matches("^[a-zA-Z]+")) {
            return this._transliterate(input);
        }
        input = this.numberPreproc(input);
        StringBuffer sb = new StringBuffer();
        Pattern p = this.NumOrLetterPattern;
        Matcher result = p.matcher(input);
        while (result.find()) {
            String word = result.group();
            if (Character.isDigit(word.charAt(0))) {
                result.appendReplacement(sb, NumberProcessor.processDigits(this.lang, word));
                continue;
            }
            String[] xlitWords = this._transliterate(word);
            if (xlitWords.length > 0) {
                result.appendReplacement(sb, xlitWords[0]);
                continue;
            }
            result.appendReplacement(sb, "");
        }
        result.appendTail(sb);
        String[] ret = new String[]{sb.toString()};
        return ret;
    }

    protected ArrayList<String> getOptions(String lowerCasedInput) {
        ArrayList<String> options = new ArrayList<String>();
        Option opt = this.ql.convert(lowerCasedInput);
        int i = 0;
        while (i < opt.getOptionsCount()) {
            options.add(opt.getOption(i));
            ++i;
        }
        return options;
    }

    private String[] _transliterate(String input) {
        String lowerCasedInput = input.toLowerCase();
        ArrayList<String> options = this.getOptions(lowerCasedInput);
        String engWord = this.englishDict.get(lowerCasedInput);
        String special = this.specialWords.get(lowerCasedInput);
        ArrayList<String> userWord = this.userWords.get(lowerCasedInput);
        if (engWord != null) {
            if (!this.englishDict.isClashing(lowerCasedInput)) {
                options.add(0, engWord);
            } else {
                options.add(1, engWord);
            }
        }
        if (input.matches("[A-Z]+")) {
            StringBuffer sb = new StringBuffer();
            boolean fail = false;
            int i = 0;
            while (i < lowerCasedInput.length()) {
                String s = lowerCasedInput.substring(i, i + 1);
                String e = this.englishDict.get(s);
                if (e == null) {
                    fail = true;
                    break;
                }
                sb.append(e);
                ++i;
            }
            if (!fail) {
                int len = sb.length() - 1;
                if (sb.codePointAt(len) == 8204 || sb.codePointAt(len) == 8205) {
                    sb = sb.deleteCharAt(sb.length() - 1);
                }
                options.add(0, sb.toString());
            }
        }
        if (special != null) {
            options.add(0, special);
        }
        if (userWord != null && userWord.size() != 0) {
            options.addAll(0, userWord);
        }
        return this.removeDuplicates(options);
    }

    private String[] removeDuplicates(ArrayList<String> options) {
        TreeSet<String> set = new TreeSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : options) {
            if (set.contains(s)) continue;
            set.add(s);
            list.add(s);
        }
        String[] ret = new String[set.size()];
        return list.toArray(ret);
    }

    public String path(String file) {
        return String.valueOf(Language.getLanguageName(this.lang)) + "/" + file;
    }

    public void addWord(String english, String indic) {
        this.userWords.addUserWord(english, indic);
    }

    public void store(ObjectOutputStream out) throws IOException {
        this.userWords.store(out);
    }

    public void load(ObjectInputStream in) throws IOException, OldUserDictException {
        this.userWords.load(in);
    }

    public void loadOld(ObjectInputStream in) throws IOException {
        this.userWords.loadOld(in);
    }

    public void commitUserDict() throws IOException {
        this.userWords.commit();
    }

    public void closeUserDict() throws Exception {
        this.userWords.close();
    }
}

