/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransLanguageInterface;
import com.cognirel.cognitrans.Features;
import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.LiteralProducer;
import com.cognirel.cognitrans.Tuple;
import com.cognirel.cognitrans.engine.ExtraDictionary;
import com.cognirel.util.CogniLogger;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class CogniTransLanguage
implements CogniTransLanguageInterface {
    private String wordValidatorPattern;
    private Pattern wordValidatorRe;
    private Hashtable<String, Features> alphabet = new Hashtable();
    private ExtraDictionary reverseDict;
    private Language lang;

    public CogniTransLanguage(Reader reader) {
        this.loadLanguageDef(reader);
        this.compileFeatureRegexes();
        this.wordValidatorRe = this.compileRegex(this.wordValidatorPattern);
        this.reverseDict = new ExtraDictionary();
        this.reverseDict.loadRevDict(this.path("special.txt"));
        this.reverseDict.loadRevDict(this.path("english.txt"));
    }

    int decodeHexChar(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        assert (false);
        return -1;
    }

    int decodeHex(String input) {
        int ret = 0;
        assert (input.length() <= 8);
        int v = 0;
        int i = input.length() - 1;
        while (i >= 0) {
            ret |= this.decodeHexChar(input.charAt(i)) << v;
            v += 4;
            --i;
        }
        return ret;
    }

    private String evalUnicodeValue(String val) {
        assert (val.charAt(val.length() - 1) == '\'');
        int start = 1;
        if (val.charAt(0) == 'u') {
            start = 2;
        }
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < val.length() - 1) {
            char c = val.charAt(i);
            if (c == '\\') {
                assert (val.charAt(i + 1) == 'u');
                int hexVal = this.decodeHex(val.substring(i + 2, i + 6).toLowerCase());
                sb.append((char)hexVal);
                i += 6;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private String[] evalValue(String val) {
        assert (val.charAt(0) == '(');
        assert (val.charAt(val.length() - 1) == ')');
        int idx1 = val.indexOf(93);
        int idx2 = val.indexOf(91, idx1);
        int idx3 = val.indexOf(93, idx2);
        String s = val.substring(idx2 + 1, idx3);
        String[] sp = s.split(",");
        String[] ret = new String[sp.length];
        int i = 0;
        while (i < sp.length) {
            ret[i] = this.evalUnicodeValue(sp[i]);
            ++i;
        }
        return ret;
    }

    private void compileFeatureRegexes() {
        for (Features features : this.alphabet.values()) {
            ArrayList<LiteralProducer> literalProducers = features.getProducers();
            for (LiteralProducer literalProducer : literalProducers) {
                literalProducer.setRegex(this.compileRegex(literalProducer.getRegex().pattern()));
            }
        }
    }

    private ArrayList<String> getLetters(String property) {
        ArrayList<String> letters = new ArrayList<String>();
        for (Map.Entry<String, Features> pair : this.alphabet.entrySet()) {
            if (!pair.getValue().hasProperty(property)) continue;
            letters.add(pair.getKey());
        }
        return letters;
    }

    public static String join(ArrayList<String> strings, String sep) {
        if (strings.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(strings.get(0));
        int i = 1;
        while (i < strings.size()) {
            sb.append(sep);
            sb.append(strings.get(i));
            ++i;
        }
        return sb.toString();
    }

    private Pattern compileRegex(String regex) {
        Pattern m = Pattern.compile("_([^_]+)_");
        Matcher result = m.matcher(regex);
        StringBuffer sb = new StringBuffer();
        while (result.find()) {
            String prop = result.group(1);
            ArrayList<String> orList = this.getLetters(prop);
            String orRegex = "(?:" + CogniTransLanguage.join(orList, "|") + ")";
            result.appendReplacement(sb, orRegex);
        }
        result.appendTail(sb);
        return Pattern.compile(sb.toString());
    }

    public ArrayList<String> getValidWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        Matcher m = this.wordValidatorRe.matcher(text);
        while (m.find()) {
            words.add(m.group());
        }
        return words;
    }

    private void extractLanguage(Element elem) {
        String language = elem.getAttributeValue("lang");
        this.lang = Language.valueOf(language.toUpperCase());
    }

    private void extractFeatures(Element elem) {
        String unicode = this.evalUnicodeValue(elem.getAttributeValue("unicode"));
        Elements children = elem.getChildElements();
        Features features = new Features(unicode);
        int i = 0;
        while (i < children.size()) {
            Element node = children.get(i);
            String tag = node.getLocalName();
            if (tag.equals("properties")) {
                String text = node.getValue();
                String[] props = text.split(",");
                String[] processedProps = new String[props.length];
                int j = 0;
                while (j < props.length) {
                    processedProps[j] = this.evalUnicodeValue(props[j]);
                    ++j;
                }
                features.setProps(processedProps);
            } else if (tag.equals("producer")) {
                String regex = this.evalUnicodeValue(node.getAttributeValue("regex"));
                String[] value = this.evalValue(node.getAttributeValue("value"));
                features.addProducer(Pattern.compile(regex), value);
                this.alphabet.put(unicode, features);
            } else assert (false);
            ++i;
        }
    }

    public Features getFeatures(char ch) {
        String s = new String();
        s = String.valueOf(s) + ch;
        return this.alphabet.get(s);
    }

    public String[] flattenLitChainPair(String[][] literalsChain) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add("");
        int i = 0;
        while (i < literalsChain.length) {
            String[] chain = literalsChain[i];
            ArrayList<String> wordListNew = new ArrayList<String>();
            String[] stringArray = chain;
            int n = chain.length;
            int n2 = 0;
            while (n2 < n) {
                String literal = stringArray[n2];
                for (String word : wordList) {
                    wordListNew.add(String.valueOf(word) + literal);
                }
                ++n2;
            }
            wordList = wordListNew;
            ++i;
        }
        String[] ret = new String[wordList.size()];
        return wordList.toArray(ret);
    }

    @Override
    public String[] reverseTransliterate(String word) {
        String[] returnList;
        String engWord = this.reverseDict.get(word);
        String[][] literalsChain = this.allLiteralsChain(word);
        double factor = 1.0;
        ArrayList<Tuple> lengths = new ArrayList<Tuple>();
        int i = 0;
        while (i < literalsChain.length) {
            Tuple t = new Tuple();
            t.iIndex = i;
            t.iLen = literalsChain[i].length;
            lengths.add(t);
            factor *= (double)t.iLen;
            ++i;
        }
        if (factor > 10.0) {
            String[][] ret = new String[literalsChain.length][];
            Collections.sort(lengths);
            int i2 = lengths.size() - 1;
            while (i2 >= 0) {
                int iCurrLen = ((Tuple)lengths.get((int)i2)).iLen;
                int iNextLen = i2 - 1 >= 0 ? ((Tuple)lengths.get((int)(i2 - 1))).iLen - 1 : 0;
                int currIndex = ((Tuple)lengths.get((int)i2)).iIndex;
                if (iNextLen == 0 || factor < 10.0) {
                    iNextLen = iCurrLen;
                }
                ret[currIndex] = new String[iNextLen];
                int j = 0;
                while (j < iNextLen) {
                    ret[currIndex][j] = literalsChain[currIndex][j];
                    ++j;
                }
                factor *= (double)iNextLen;
                factor /= (double)iCurrLen;
                --i2;
            }
            returnList = this.flattenLitChainPair(ret);
        } else {
            returnList = this.flattenLitChainPair(literalsChain);
        }
        if (engWord != null) {
            returnList[0] = engWord;
        }
        return returnList;
    }

    public String[][] allLiteralsChain(String word) {
        String[][] chain = new String[word.length()][];
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            Features f = this.getFeatures(ch);
            int bestMatchLen = 0;
            try {
                ArrayList<LiteralProducer> literalProducers = f.getProducers();
                try {
                    for (LiteralProducer literalProducer : literalProducers) {
                        Matcher match = literalProducer.getRegex().matcher(word);
                        while (match.find()) {
                            int matchLen = match.group().length();
                            int matchIndex = match.start(1);
                            if (matchLen <= bestMatchLen || matchIndex != i) continue;
                            chain[i] = literalProducer.getValue();
                            bestMatchLen = matchLen;
                        }
                    }
                }
                catch (Exception e) {
                    chain[i] = new String[1];
                    chain[i][0] = "";
                }
            }
            catch (Exception exp) {
                CogniLogger.error("Transliteration failure for word: " + word + " at i: " + i, exp);
                throw new IllegalArgumentException();
            }
            ++i;
        }
        return chain;
    }

    private void loadLanguageDef(Reader reader) {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(reader);
            Element root = doc.getRootElement();
            String rootTag = root.getLocalName();
            if (rootTag.equals("Quill")) {
                this.extractLanguage(root);
            }
            Elements children = root.getChildElements();
            int i = 0;
            while (i < children.size()) {
                Element node = children.get(i);
                String tag = node.getLocalName();
                if (tag.equals("valid-word-pattern")) {
                    this.wordValidatorPattern = this.evalUnicodeValue(node.getAttributeValue("regex"));
                } else if (tag.equals("features")) {
                    this.extractFeatures(node);
                }
                ++i;
            }
        }
        catch (ParsingException ex) {
            CogniLogger.error("Error in loading Language File", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            CogniLogger.error("Error in loading Language File", ex);
        }
    }

    private String path(String file) {
        return String.valueOf(Language.getLanguageName(this.lang)) + "/" + file;
    }
}

