/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransEngine;
import com.cognirel.cognitrans.CogniTransLanguage;
import com.cognirel.cognitrans.Features;
import com.cognirel.util.CogniLogger;
import com.cognirel.util.LineReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CogniTransTranslator {
    private CogniTransEngine engine;
    private CogniTransLanguage ql;
    boolean failed = true;
    public static boolean MINIMAL_TRANSLATE = false;
    Hashtable<String, ArrayList<TranslateRule>> allRules = new Hashtable();

    public CogniTransTranslator(CogniTransLanguage ql_, CogniTransEngine engine_) {
        this.engine = engine_;
        this.ql = ql_;
    }

    private boolean isEmpty(String input) {
        String test = input.replaceAll("\\s+", "");
        return test.length() == 0;
    }

    private String strip(String input) {
        return input.replaceAll("\\s+$", "");
    }

    private String lstrip(String input) {
        return input.replaceAll("^\\s+", "");
    }

    private void readRules(ArrayList<TranslateRule> list, LineReader r) throws IOException {
        String line;
        while (!this.isEmpty(line = r.readLineUnicode())) {
            String[] parts = line.split("--->");
            if (parts.length != 2) continue;
            list.add(new TranslateRule(this.strip(parts[0]), this.strip(parts[1])));
        }
    }

    public void load(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        if (!r.isOK()) {
            CogniLogger.info("failed to load '" + filename + "' in CogniTransTranslator");
            return;
        }
        String ruleName = null;
        ArrayList<TranslateRule> rules = null;
        try {
            try {
                while (true) {
                    String line;
                    if ((line = r.readLineUnicode()).isEmpty() || !line.matches("^#.*$")) {
                        continue;
                    }
                    ruleName = this.strip(line).substring(1).toLowerCase();
                    rules = new ArrayList<TranslateRule>();
                    this.readRules(rules, r);
                    this.allRules.put(ruleName, rules);
                    rules = null;
                }
            }
            catch (IOException e) {
                if (!e.getMessage().equals("EOF")) {
                    CogniLogger.info("Problem, sudden EOF in English Dictionary - " + e);
                }
                if (rules != null) {
                    this.allRules.put(ruleName, rules);
                }
            }
        }
        catch (Throwable throwable) {
            if (rules != null) {
                this.allRules.put(ruleName, rules);
            }
            throw throwable;
        }
        this.failed = false;
    }

    public String mergeWords(String ustr1, String ustr2) {
        char leftEnd = ustr1.charAt(ustr1.length() - 1);
        char rightStart = ustr2.charAt(0);
        if (ustr2.charAt(0) == ' ') {
            rightStart = ustr2.charAt(1);
        }
        Features leftEndFs = this.ql.getFeatures(leftEnd);
        Features rightStartFs = this.ql.getFeatures(rightStart);
        String zwnj = "\u200c";
        String outStr = ustr1;
        if (ustr2.charAt(0) == ' ') {
            outStr = String.valueOf(outStr) + " ";
            ustr2 = ustr2.trim();
        }
        outStr = leftEndFs.hasProperty("halanth") ? (rightStartFs.hasProperty("mathra") ? String.valueOf(outStr) + zwnj + ustr2.substring(1) : (rightStartFs.hasProperty("vowel") ? String.valueOf(outStr) + zwnj + ustr2.substring(1) : String.valueOf(outStr) + ustr2)) : (leftEndFs.hasProperty("mathra") ? (rightStartFs.hasProperty("mathra") ? String.valueOf(outStr.substring(0, outStr.length() - 1)) + ustr2 : (rightStartFs.hasProperty("vowel") ? String.valueOf(outStr) + ustr2.substring(1) : String.valueOf(outStr) + ustr2)) : (rightStartFs.hasProperty("mathra") ? String.valueOf(outStr) + ustr2 : (rightStartFs.hasProperty("vowel") ? String.valueOf(outStr) + ustr2.substring(1) : String.valueOf(outStr) + ustr2)));
        return outStr;
    }

    String applyRule(String ruleName, String input, String extra) {
        if (!this.allRules.containsKey(ruleName)) {
            return input;
        }
        ArrayList<TranslateRule> rules = this.allRules.get(ruleName);
        for (TranslateRule rule : rules) {
            input = input.replaceAll(rule.regex, String.valueOf(extra) + rule.substitute);
        }
        return input;
    }

    String applyRule(String ruleName, String input) {
        return this.applyRule(ruleName, input, "");
    }

    public String[] makeArray(String ... args) {
        return args;
    }

    public static String[] reSplit(String text, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        String prev = null;
        ArrayList<String> list = new ArrayList<String>();
        int prevIdx = 0;
        boolean found = false;
        while (m.find()) {
            prev = text.substring(prevIdx, m.start());
            list.add(prev);
            if (m.groupCount() > 0) {
                int i = 1;
                while (i <= m.groupCount()) {
                    list.add(m.group(i));
                    ++i;
                }
            }
            prevIdx = m.end();
            found = true;
        }
        if (!found) {
            list.add(text);
        } else {
            prev = text.substring(prevIdx);
            list.add(prev);
        }
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }

    public String[] translate(String sen) {
        try {
            return this.translate_(sen);
        }
        catch (Exception ex) {
            return this.engine.transliterate(sen);
        }
    }

    private String[] translate_(String sen) {
        String[] senParts;
        if (this.failed) {
            CogniLogger.info("Translation failed");
            return this.engine.transliterate(sen);
        }
        String[] parts = CogniTransTranslator.reSplit(sen, "(\\W+)");
        sen = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            sen = part.matches("[A-Z0-9]+$") ? String.valueOf(sen) + part : String.valueOf(sen) + part.toLowerCase();
            ++n2;
        }
        sen = this.applyRule("equivalence", sen);
        sen = sen.replaceAll("[#]", "~#");
        if (!MINIMAL_TRANSLATE) {
            sen = this.applyRule("translate_swap", sen, "#");
            sen = this.applyRule("translate", sen);
        }
        if ((senParts = CogniTransTranslator.reSplit(sen, "(\\W+)")).length == 1) {
            return this.engine.transliterate(senParts[0]);
        }
        String unicodeSen = "";
        String[] stringArray2 = senParts;
        int n3 = senParts.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            unicodeSen = part.matches("[a-zA-Z0-9]+") ? String.valueOf(unicodeSen) + this.engine.transliterate(part)[0] : String.valueOf(unicodeSen) + part;
            ++n4;
        }
        String[] unicodeSenParts = CogniTransTranslator.reSplit(unicodeSen, "(?<![~^])[#]");
        String addrSep = "(\\s+|\\s*[,]\\s*|\\s*[.;:-]\\s+)";
        ArrayList<String> outParts = new ArrayList<String>();
        if (unicodeSenParts.length < 2) {
            outParts.add(unicodeSen);
        } else {
            int prevWordPos = -1;
            int start = 0;
            if (!unicodeSenParts[0].equals("")) {
                outParts.add(unicodeSenParts[0]);
                prevWordPos = 0;
                start = 1;
            }
            int partIdx = start;
            while (partIdx < unicodeSenParts.length) {
                String part = unicodeSenParts[partIdx];
                if (this.strip(part).equals("")) {
                    outParts.add(part);
                } else {
                    String[] wList = CogniTransTranslator.reSplit(part, addrSep);
                    String swapWord = wList[0];
                    swapWord = swapWord.replace('\u200c', ' ');
                    char[] charArray = new char[swapWord.length()];
                    swapWord.getChars(0, swapWord.length(), charArray, 0);
                    int i = 0;
                    while (i < charArray.length) {
                        if (charArray[i] == '\u200c') {
                            charArray[i] = 32;
                        }
                        ++i;
                    }
                    swapWord = new String(charArray);
                    boolean swappingDone = false;
                    if (wList.length > 1) {
                        wList[1] = this.lstrip(wList[1].substring(1));
                        int idx = 1;
                        while (idx < wList.length) {
                            String w = wList[idx];
                            if (w.matches("^ +\\Z") || swappingDone) {
                                outParts.add(w);
                            } else if (!w.matches(addrSep)) {
                                outParts.add(w);
                                prevWordPos = outParts.size() - 1;
                            } else if (prevWordPos != -1) {
                                String prevWord = outParts.get(prevWordPos);
                                ArrayList<TranslateRule> rules = this.allRules.get("inflexion");
                                for (TranslateRule rule : rules) {
                                    if (!prevWord.matches(rule.regex)) continue;
                                    String inflectedWord = this.mergeWords(prevWord, rule.substitute.substring(1));
                                    outParts.set(prevWordPos, inflectedWord);
                                    swappingDone = true;
                                    break;
                                }
                                if (!this.strip(outParts.get(outParts.size() - 1)).equals("")) {
                                    outParts.add(" ");
                                }
                                outParts.add(swapWord);
                                outParts.add(w);
                                swapWord = "";
                            }
                            ++idx;
                        }
                    }
                    if (!swapWord.equals("")) {
                        try {
                            String prevWord = outParts.get(prevWordPos);
                            ArrayList<TranslateRule> rules = this.allRules.get("inflexion");
                            for (TranslateRule rule : rules) {
                                if (!prevWord.matches(rule.regex)) continue;
                                String inflectedWord = "";
                                try {
                                    inflectedWord = this.mergeWords(prevWord, rule.substitute.substring(1));
                                }
                                catch (Exception e) {
                                    inflectedWord = prevWord;
                                }
                                outParts.set(prevWordPos, inflectedWord);
                                break;
                            }
                            if (!this.strip(outParts.get(outParts.size() - 1)).equals("")) {
                                outParts.add(" ");
                            }
                            outParts.add(swapWord);
                            outParts.add(" ");
                        }
                        catch (ArrayIndexOutOfBoundsException exp) {
                            if (prevWordPos < 0 && wList.length == 1) {
                                return this.makeArray(swapWord.replaceAll("~#", "#"));
                            }
                            throw new ArrayIndexOutOfBoundsException();
                        }
                    }
                }
                ++partIdx;
            }
        }
        String outStr = CogniTransLanguage.join(outParts, "");
        return this.makeArray(outStr.replaceAll("~#", "#"));
    }

    public class TranslateRule {
        public String regex;
        public String substitute;

        public TranslateRule(String regex_, String substitute_) {
            this.regex = regex_;
            this.substitute = substitute_;
        }
    }
}

