/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransEditDistance;
import com.cognirel.cognitrans.CogniTransEngine;
import com.cognirel.cognitrans.CogniTransLanguage;
import com.cognirel.cognitrans.CogniTransLanguageFactory;
import com.cognirel.cognitrans.CogniTransTranslator;
import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.engine.OldUserDictException;
import com.cognirel.cognitrans.exceptions.LanguageNotSupportedException;
import com.cognirel.cognitrans.exceptions.LengthMismatchException;
import com.cognirel.util.CogniLogger;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CogniTransTransliterationProvider
implements ITransliterationProvider {
    private static Hashtable<String, Language> languages = new Hashtable();
    private static Hashtable<String, CogniTransEngine> engines = new Hashtable();
    private static Hashtable<String, CogniTransLanguage> rtEngines = new Hashtable();
    private static HashMap<Language, CogniTransEngine> allEngines = new HashMap();
    static Hashtable<String, CogniTransTranslator> translators = new Hashtable();
    private static CogniTransLanguageFactory factory = new CogniTransLanguageFactory();
    private static CogniTransEditDistance editDistance = new CogniTransEditDistance();
    static String persistenceLocation;

    public static String getPersistenceLocation() {
        return persistenceLocation;
    }

    static void setPersistenceLocation(String persistenceLocation) {
        CogniTransTransliterationProvider.persistenceLocation = persistenceLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized CogniTransEngine checkAndAddLanguage(String language, TransliterationHints ... hints) {
        CogniTransEngine engine = engines.get(language);
        if (engine != null) {
            return engine;
        }
        boolean persistSync = CogniTransTransliterationProvider.shouldWePersist(hints);
        Class<CogniTransTransliterationProvider> clazz = CogniTransTransliterationProvider.class;
        synchronized (CogniTransTransliterationProvider.class) {
            if (engine == null) {
                CogniLogger.info("Adding: " + language);
                Language lang = languages.get(language);
                try {
                    CogniTransTransliterationProvider.addLanguage(lang, persistSync);
                }
                catch (NullPointerException e) {
                    String msg = "Input language code currently not supported: " + (Object)((Object)lang);
                    CogniLogger.error(msg, e);
                    throw new LanguageNotSupportedException(msg);
                }
                engine = engines.get(language);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return engine;
        }
    }

    private static void addLanguage(Language l, boolean persistSync) {
        String[] aliases;
        String langDir = Language.getLanguageName(l);
        File file = new File(persistenceLocation, langDir);
        if (file != null && !file.isDirectory()) {
            file.mkdir();
        }
        CogniTransEngine engine = new CogniTransEngine(l, persistSync);
        CogniTransLanguage lang = factory.create(l);
        CogniTransTranslator translator = new CogniTransTranslator(lang, engine);
        translator.load(String.valueOf(Language.getLanguageName(l)) + "/" + "xln.rules");
        String[] stringArray = aliases = Language.getAliases(l);
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            String al = alias.toLowerCase();
            rtEngines.put(al, lang);
            engines.put(al, engine);
            translators.put(al, translator);
            ++n2;
        }
        allEngines.put(l, engine);
    }

    private static synchronized void addLanguageAliases(Language l) {
        String[] aliases;
        String[] stringArray = aliases = Language.getAliases(l);
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            String al = alias.toLowerCase();
            languages.put(al, l);
            ++n2;
        }
    }

    public CogniTransTransliterationProvider() {
        CogniLogger.info("CogniTrans Version no: " + this.getVersion());
        CogniTransTransliterationProvider.addLanguageAliases(Language.ASSAMESE);
        CogniTransTransliterationProvider.addLanguageAliases(Language.BENGALI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.GUJARATI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.HINDI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.KANNADA);
        CogniTransTransliterationProvider.addLanguageAliases(Language.KONKANI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.MALAYALAM);
        CogniTransTransliterationProvider.addLanguageAliases(Language.MANIPURI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.MARATHI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.NEPALI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.ORIYA);
        CogniTransTransliterationProvider.addLanguageAliases(Language.PUNJABI);
        CogniTransTransliterationProvider.addLanguageAliases(Language.TAMIL);
        CogniTransTransliterationProvider.addLanguageAliases(Language.TELUGU);
        CogniTransTransliterationProvider.addLanguageAliases(Language.URDU);
        CogniTransTransliterationProvider.addLanguageAliases(Language.ENGLISH);
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getResourceAsStream("/cognirel-config.properties"));
            CogniTransTransliterationProvider.setPersistenceLocation(prop.getProperty("persistencedirectory"));
            File file = new File(CogniTransTransliterationProvider.getPersistenceLocation());
            if (!file.isDirectory()) {
                file.mkdir();
            }
        }
        catch (IOException e) {
            CogniLogger.error("Could not create cognirel auto-persistence location", e);
        }
    }

    public void importDB(byte[] data, boolean merge, TransliterationHints ... hints) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            ObjectInputStream reader = new ObjectInputStream(in);
            int count = reader.readInt();
            int i = 0;
            while (i < count) {
                Language lang = (Language)((Object)reader.readObject());
                if (languages.containsValue((Object)lang)) {
                    String language = Language.getAliases(lang)[0];
                    CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(language, hints);
                    engine.load(reader);
                    engine.commitUserDict();
                } else {
                    CogniLogger.error("engine for language not found: " + (Object)((Object)lang));
                }
                ++i;
            }
        }
        catch (OldUserDictException e) {
            CogniLogger.info("dictionary to be loaded is in old format", e);
            ByteArrayInputStream in1 = new ByteArrayInputStream(data);
            try {
                ObjectInputStream reader = new ObjectInputStream(in1);
                int count = reader.readInt();
                int i = 0;
                while (i < count) {
                    Language lang = (Language)((Object)reader.readObject());
                    if (languages.containsValue((Object)lang)) {
                        String language = Language.getAliases(lang)[0];
                        CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(language, hints);
                        engine.loadOld(reader);
                        engine.commitUserDict();
                    } else {
                        CogniLogger.error("engine for language not found: " + (Object)((Object)lang));
                    }
                    ++i;
                }
            }
            catch (IOException e1) {
                CogniLogger.info("User Dictionary not found in the InputStream", e);
            }
            catch (ClassNotFoundException e1) {
                CogniLogger.info("The Language object in the dictionary could not be read", e);
            }
        }
        catch (IOException e) {
            CogniLogger.info("User Dictionary Not found in the InputStream", e);
        }
        catch (ClassNotFoundException e) {
            CogniLogger.info("The Language object in the dictionary could not be read", e);
        }
    }

    public byte[] exportDB(String ... language) {
        Language lang;
        ArrayList<Language> exportLangs = new ArrayList<Language>();
        String[] stringArray = language;
        int n = language.length;
        int n2 = 0;
        while (n2 < n) {
            String languageAlias = stringArray[n2];
            lang = languages.get(languageAlias = languageAlias.trim().toLowerCase());
            if (allEngines.get((Object)lang) != null) {
                exportLangs.add(lang);
            }
            ++n2;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (language.length != 0 && exportLangs.size() != 0) {
            try {
                ObjectOutputStream writer = new ObjectOutputStream(out);
                if (allEngines.size() != 0) {
                    writer.writeInt(exportLangs.size());
                    for (Map.Entry entry : allEngines.entrySet()) {
                        lang = (Language)((Object)entry.getKey());
                        if (!exportLangs.contains((Object)lang)) continue;
                        CogniTransEngine engine = (CogniTransEngine)entry.getValue();
                        writer.writeObject((Object)lang);
                        engine.store(writer);
                    }
                }
                writer.close();
            }
            catch (IOException e) {
                CogniLogger.error("Could not stream data to Output Byte Stream", e);
            }
        } else {
            try {
                ObjectOutputStream writer = new ObjectOutputStream(out);
                writer.writeInt(allEngines.size());
                for (Map.Entry entry : allEngines.entrySet()) {
                    lang = (Language)((Object)entry.getKey());
                    CogniTransEngine engine = (CogniTransEngine)entry.getValue();
                    writer.writeObject((Object)lang);
                    engine.store(writer);
                }
                writer.close();
            }
            catch (IOException e) {
                CogniLogger.error("Could not stream data to Output Byte Stream", e);
            }
        }
        return out.toByteArray();
    }

    public Font getFontForLocale(String locale, int size) {
        return null;
    }

    public String getName() {
        return "CogniTrans";
    }

    public String getVersion() {
        return "2.5.3";
    }

    public String[] getSupportedLocales() {
        String[] ret = new String[languages.size()];
        int i = 0;
        Iterator<String> iterator = languages.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            ret[i] = key = iterator.next();
            ++i;
        }
        return ret;
    }

    public String[] getSupportedReverseLocales() {
        return this.getSupportedLocales();
    }

    public String[] rsuggest(String text, String locale, TransliterationHints ... hints) {
        locale = locale.trim().toLowerCase();
        CogniLogger.debug("reverse trans: " + text + " into: " + locale);
        String[] words = text.split("[ ]+");
        if (words.length > 1) {
            String[] x = new String[]{this.rtransliterate(text, locale, hints)};
            return x;
        }
        CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        CogniTransLanguage lang = rtEngines.get(locale);
        Object[] ret = lang.reverseTransliterate(text);
        CogniLogger.debug("reverse trans o/p: " + Arrays.toString(ret));
        return ret;
    }

    public String rtransliterate(String text, String locale, TransliterationHints ... hints) {
        locale = locale.trim().toLowerCase();
        CogniLogger.debug("reverse trans: " + text + " into: " + locale);
        CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        CogniTransLanguage lang = rtEngines.get(locale);
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("[\u0600-\u0d7f\u200d\u200c]+");
        Matcher result = p.matcher(text);
        while (result.find()) {
            String word = result.group();
            String[] xlitWords = lang.reverseTransliterate(word);
            if (xlitWords.length > 0) {
                result.appendReplacement(sb, xlitWords[0].toLowerCase());
                continue;
            }
            result.appendReplacement(sb, "");
        }
        result.appendTail(sb);
        String ret = sb.toString();
        CogniLogger.debug("reverse trans o/p: " + ret);
        return ret;
    }

    public String[] suggest(String text, String locale, TransliterationHints ... hints) {
        CogniTransTranslator translator;
        text = text.trim();
        locale = locale.trim().toLowerCase();
        CogniLogger.debug("transliterate: " + text + " into: " + locale);
        CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        for (String key : CogniTransEngine.splCharsReplacement.keySet()) {
            String value = CogniTransEngine.splCharsReplacement.get(key);
            text = text.replace(key, value);
        }
        if (this.shouldTranslate(hints) && (translator = translators.get(locale)) != null) {
            Object[] ret = translator.translate(text);
            CogniLogger.debug("transliteration options o/p: " + Arrays.toString(ret));
            return ret;
        }
        Object[] ret = engine.transliterate(text);
        CogniLogger.debug("transliteration options o/p: " + Arrays.toString(ret));
        return ret;
    }

    private boolean shouldTranslate(TransliterationHints ... hints) {
        TransliterationHints[] transliterationHintsArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            TransliterationHints hint = transliterationHintsArray[n2];
            if (hint.equals((Object)TransliterationHints.TRANSLATE)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String transliterate(String text, String locale, TransliterationHints ... hints) {
        CogniTransTranslator translator;
        text = text.trim();
        locale = locale.trim().toLowerCase();
        CogniLogger.debug("transliterate: " + text + " into: " + locale);
        CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        for (String key : CogniTransEngine.splCharsReplacement.keySet()) {
            String value = CogniTransEngine.splCharsReplacement.get(key);
            text = text.replaceAll(key, value);
        }
        if (this.shouldTranslate(hints) && (translator = translators.get(locale)) != null) {
            Object[] ret = translator.translate(text);
            CogniLogger.debug("transliteration options o/p: " + Arrays.toString(ret));
            return ret[0];
        }
        Object[] ret = engine.transliterate(text);
        CogniLogger.debug("transliteration options o/p: " + Arrays.toString(ret));
        return ret[0];
    }

    public void tuneEnglishToIndic(String eng, String indic, String locale, TransliterationHints ... hints) {
        CogniLogger.debug("Tuning: " + eng + " with " + indic);
        locale = locale.trim().toLowerCase();
        CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        CogniTransLanguage lang = rtEngines.get(locale);
        if (engine == null || lang == null) {
            return;
        }
        boolean isAddress = CogniTransTransliterationProvider.isAddress(hints);
        ArrayList<String> words = lang.getValidWords(indic);
        Pattern p = Pattern.compile("[a-zA-Z]+");
        Matcher m = p.matcher(eng);
        if (!isAddress) {
            int length = 0;
            while (m.find()) {
                ++length;
            }
            if (length != words.size()) {
                String errorMsg = "eng: " + eng + ", indic: " + indic + " " + words.toString();
                CogniLogger.error(errorMsg);
                throw new LengthMismatchException("The lengths of the names do not match: " + errorMsg);
            }
        }
        m = p.matcher(eng);
        while (m.find()) {
            int score;
            String bestWord;
            int maxScore;
            String engWord = m.group().toLowerCase();
            if (isAddress) {
                maxScore = 0;
                bestWord = null;
                for (String indicWord : words) {
                    score = editDistance.findSimilarity(engWord, "english", indicWord, locale, TransliterationHints.ADDRESS);
                    if (score <= maxScore) continue;
                    maxScore = score;
                    bestWord = indicWord;
                }
                if (maxScore < 50 || bestWord == null) continue;
                engine.addWord(engWord, bestWord);
                continue;
            }
            maxScore = 0;
            bestWord = null;
            for (String indicWord : words) {
                score = editDistance.findSimilarity(engWord, "english", indicWord, locale, TransliterationHints.NAME);
                if (score <= maxScore) continue;
                maxScore = score;
                bestWord = indicWord;
            }
            if (maxScore < 50 || bestWord == null) continue;
            engine.addWord(engWord, bestWord);
        }
        try {
            engine.commitUserDict();
        }
        catch (IOException e) {
            CogniLogger.info(String.valueOf(e.getMessage()) + "Name dictionary is corrupt");
        }
    }

    public void tuneIndicToEnglish(String indic, String eng, String locale, TransliterationHints ... hints) {
        CogniLogger.debug("Tuning: " + eng + " with " + indic);
        locale = locale.trim().toLowerCase();
        CogniTransEngine engine = CogniTransTransliterationProvider.checkAndAddLanguage(locale, hints);
        CogniTransLanguage lang = rtEngines.get(locale);
        if (engine == null || lang == null) {
            return;
        }
        boolean isAddress = CogniTransTransliterationProvider.isAddress(hints);
        ArrayList<String> words = lang.getValidWords(indic);
        Pattern p = Pattern.compile("[a-zA-Z]+");
        Matcher m = p.matcher(eng);
        if (!isAddress) {
            int length = 0;
            while (m.find()) {
                ++length;
            }
            if (length != words.size()) {
                String errorMsg = "eng: " + eng + ", indic: " + indic + " " + words.toString();
                CogniLogger.error(errorMsg);
                throw new LengthMismatchException("The lengths of the names do not match: " + errorMsg);
            }
        }
        m = p.matcher(eng);
        while (m.find()) {
            int score;
            String bestWord;
            int maxScore;
            String engWord = m.group().toLowerCase();
            if (isAddress) {
                maxScore = 0;
                bestWord = null;
                for (String indicWord : words) {
                    score = editDistance.findSimilarity(engWord, "english", indicWord, locale, TransliterationHints.ADDRESS);
                    if (score <= maxScore) continue;
                    maxScore = score;
                    bestWord = indicWord;
                }
                if (maxScore < 50 || bestWord == null) continue;
                engine.addWord(engWord, bestWord);
                continue;
            }
            maxScore = 0;
            bestWord = null;
            for (String indicWord : words) {
                score = editDistance.findSimilarity(engWord, "english", indicWord, locale, TransliterationHints.NAME);
                if (score <= maxScore) continue;
                maxScore = score;
                bestWord = indicWord;
            }
            if (maxScore < 50 || bestWord == null) continue;
            engine.addWord(engWord, bestWord);
        }
        try {
            engine.commitUserDict();
        }
        catch (IOException e) {
            CogniLogger.info(String.valueOf(e.getMessage()) + "Name dictionary is corrupt");
        }
    }

    private static boolean isAddress(TransliterationHints ... hints) {
        TransliterationHints[] transliterationHintsArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            TransliterationHints hint = transliterationHintsArray[n2];
            if (hint.equals((Object)TransliterationHints.ADDRESS)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean shouldWePersist(TransliterationHints ... hints) {
        TransliterationHints[] transliterationHintsArray = hints;
        int n = hints.length;
        int n2 = 0;
        while (n2 < n) {
            TransliterationHints x = transliterationHintsArray[n2];
            if (x.equals((Object)TransliterationHints.PERSIST)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        CogniLogger.info("attempting to close all open jdbm connections");
        for (Map.Entry<String, CogniTransEngine> engine : engines.entrySet()) {
            try {
                engine.getValue().closeUserDict();
            }
            catch (Exception e) {
                CogniLogger.debug(String.valueOf(e.getMessage()) + ": " + engine.getKey() + " Name dictionary may be corrupt");
            }
        }
        super.finalize();
    }
}

