/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransEditDistance;
import com.cognirel.cognitrans.exceptions.LanguageMismatchException;
import com.cognirel.util.CogniLogger;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.HashSet;

public class EditDistance {
    public static String[] getPhoneticRepresentations(String engText, String lang) {
        HashSet<String> out = new HashSet<String>();
        String[] eng2regTrans = CogniTransEditDistance.qp.suggest(engText, lang, TransliterationHints.TRANSLATE);
        String[] eng2regNoTrans = CogniTransEditDistance.qp.suggest(engText, lang, new TransliterationHints[0]);
        String[] stringArray = eng2regTrans;
        int n = eng2regTrans.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            try {
                String tmp = CogniTransEditDistance.qp.rtransliterate(x, lang, new TransliterationHints[0]);
                out.add(tmp);
            }
            catch (Exception e) {
                CogniLogger.error("Error in reverse transliteration of word" + x + " for language: " + lang, e);
                throw new LanguageMismatchException("Error in reverse transliteration of word" + x);
            }
            ++n2;
        }
        HashSet<String> cons = new HashSet<String>();
        String[] stringArray2 = eng2regNoTrans;
        int n3 = eng2regNoTrans.length;
        n = 0;
        while (n < n3) {
            block8: {
                String[] revList;
                String regWord = stringArray2[n];
                try {
                    revList = CogniTransEditDistance.qp.rsuggest(regWord, lang, new TransliterationHints[0]);
                }
                catch (Exception e) {
                    CogniLogger.error("Error in reverse transliteration of word" + regWord + " for language: " + lang, e);
                    break block8;
                }
                String[] stringArray3 = revList;
                int n4 = revList.length;
                int n5 = 0;
                while (n5 < n4) {
                    String ph = stringArray3[n5];
                    String x = ph.toLowerCase().replaceAll("[aeiou]+", "");
                    if (!cons.contains(x)) {
                        cons.add(x);
                        out.add(ph.toLowerCase());
                        if (out.size() > 5) break;
                    }
                    ++n5;
                }
                if (out.size() > 5) break;
            }
            ++n;
        }
        String[] ret = new String[]{};
        ret = out.toArray(ret);
        return ret;
    }

    public static double getBigramMatch(String[] words) {
        if (words[0] == "" || words[1] == "") {
            return 0.0;
        }
        String rexIsvowel = "[aeiouh]";
        HashSet[] a = new HashSet[words.length];
        int i = 0;
        while (i < words.length) {
            String s = words[i];
            String s0 = s.substring(0, 1);
            s = s.replaceAll(rexIsvowel, "");
            if (s0.matches(rexIsvowel)) {
                s = String.valueOf(s0) + s;
            }
            if (s.length() < 2) {
                if (words[0].equals(words[1])) {
                    return 1.0;
                }
                return 0.0;
            }
            a[i] = new HashSet();
            int j = 0;
            while (j < s.length() - 1) {
                if (s.charAt(j) != s.charAt(j + 1)) {
                    String strTmp = s.substring(j, j + 2);
                    a[i].add(strTmp);
                }
                ++j;
            }
            ++i;
        }
        HashSet c = new HashSet();
        c = (HashSet)a[0].clone();
        c.removeAll(a[1]);
        int len1 = c.size();
        c = (HashSet)a[1].clone();
        c.removeAll(a[0]);
        int len2 = c.size();
        double mismatch = Math.sqrt(((double)len1 * 1.0 / (double)a[0].size() + (double)len2 * 1.0 / (double)a[1].size()) / 2.0);
        return 1.0 - mismatch;
    }

    public static double editDistanceScore(String t1, String t2) {
        int dist = EditDistance.editDistance(t1, t2);
        return 1.0 * (double)dist / (double)Math.max(t1.length(), t2.length());
    }

    public static int editDistance(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int i = 0;
        while (i <= n) {
            p[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= m) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            i = 1;
            while (i <= n) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                ++i;
            }
            int[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return p[n];
    }
}

