/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

public enum Language {
    ASSAMESE,
    BENGALI,
    GUJARATI,
    HINDI,
    KANNADA,
    KONKANI,
    MALAYALAM,
    MANIPURI,
    MARATHI,
    NEPALI,
    ORIYA,
    PUNJABI,
    TAMIL,
    TELUGU,
    URDU,
    ENGLISH;


    public static String getLanguageName(Language l) {
        switch (l) {
            case ASSAMESE: {
                return "assamese";
            }
            case BENGALI: {
                return "bengali";
            }
            case GUJARATI: {
                return "gujarati";
            }
            case HINDI: {
                return "hindi";
            }
            case KANNADA: {
                return "kannada";
            }
            case KONKANI: {
                return "konkani";
            }
            case MALAYALAM: {
                return "malayalam";
            }
            case MANIPURI: {
                return "manipuri";
            }
            case MARATHI: {
                return "marathi";
            }
            case NEPALI: {
                return "nepali";
            }
            case ORIYA: {
                return "oriya";
            }
            case PUNJABI: {
                return "punjabi";
            }
            case TAMIL: {
                return "tamil";
            }
            case TELUGU: {
                return "telugu";
            }
            case URDU: {
                return "urdu";
            }
            case ENGLISH: {
                return "english";
            }
        }
        return null;
    }

    static String getLanguageFont(Language l) {
        switch (l) {
            case ASSAMESE: {
                return "lohit_bn_osk.ttf";
            }
            case BENGALI: {
                return "lohit_bn_osk.ttf";
            }
            case GUJARATI: {
                return "lohit_gu_osk.ttf";
            }
            case HINDI: {
                return "gargi.ttf";
            }
            case KANNADA: {
                return "lohit_kn_osk.ttf";
            }
            case KONKANI: {
                return "gargi.ttf";
            }
            case MALAYALAM: {
                return "Rachana_osk.ttf";
            }
            case MANIPURI: {
                return "lohit_bn_osk.ttf";
            }
            case MARATHI: {
                return "gargi.ttf";
            }
            case NEPALI: {
                return "gargi.ttf";
            }
            case ORIYA: {
                return "lohit_or_uid.ttf";
            }
            case PUNJABI: {
                return "lohit_pa_osk.ttf";
            }
            case TAMIL: {
                return "lohit_ta_uid.ttf";
            }
            case TELUGU: {
                return "lohit_te_osk.ttf";
            }
            case URDU: {
                return "NafeesWebOSK.ttf";
            }
            case ENGLISH: {
                return "arial.ttf";
            }
        }
        return null;
    }

    static int getDigitStart(Language l) {
        return 48;
    }

    public static String[] getAliases(Language l) {
        switch (l) {
            case ASSAMESE: {
                String[] ret = new String[]{"as_in", "Assamese", "Asm", "01"};
                return ret;
            }
            case BENGALI: {
                String[] ret = new String[]{"bn_in", "Bengali", "Ben", "02"};
                return ret;
            }
            case GUJARATI: {
                String[] ret = new String[]{"gu_in", "Gujarati", "Guj", "05"};
                return ret;
            }
            case HINDI: {
                String[] ret = new String[]{"hi_in", "Hindi", "Hin", "06"};
                return ret;
            }
            case KANNADA: {
                String[] ret = new String[]{"kn_in", "Kannada", "Kan", "07"};
                return ret;
            }
            case KONKANI: {
                String[] ret = new String[]{"kok_in", "Konkani", "Kok", "09"};
                return ret;
            }
            case MALAYALAM: {
                String[] ret = new String[]{"ml_in", "Malayalam", "Mal", "11"};
                return ret;
            }
            case MANIPURI: {
                String[] ret = new String[]{"mni_in", "Manipuri", "Man", "12"};
                return ret;
            }
            case MARATHI: {
                String[] ret = new String[]{"mr_in", "Marathi", "Mar", "13"};
                return ret;
            }
            case NEPALI: {
                String[] ret = new String[]{"ne_in", "Nepali", "Nep", "14"};
                return ret;
            }
            case ORIYA: {
                String[] ret = new String[]{"or_in", "Oriya", "Ori", "15"};
                return ret;
            }
            case PUNJABI: {
                String[] ret = new String[]{"pa_in", "Punjabi", "Pan", "16"};
                return ret;
            }
            case TAMIL: {
                String[] ret = new String[]{"ta_in", "Tamil", "Tnd", "20"};
                return ret;
            }
            case TELUGU: {
                String[] ret = new String[]{"te_in", "Telugu", "Tel", "21"};
                return ret;
            }
            case URDU: {
                String[] ret = new String[]{"ur_in", "Urdu", "Urd", "22"};
                return ret;
            }
            case ENGLISH: {
                String[] ret = new String[]{"en_in", "en_gb", "English", "Eng", "23"};
                return ret;
            }
        }
        return null;
    }

    static String getLanguageXML(Language l) {
        switch (l) {
            case ASSAMESE: {
                return "Assamese_Vrinda.xml";
            }
            case BENGALI: {
                return "Bengali_Vrinda.xml";
            }
            case GUJARATI: {
                return "Gujarati_Shruti.xml";
            }
            case HINDI: {
                return "Hindi_Mangal.xml";
            }
            case KANNADA: {
                return "Kannada_Tunga.xml";
            }
            case KONKANI: {
                return "Konkani_Mangal.xml";
            }
            case MALAYALAM: {
                return "Malayalam_Kartika.xml";
            }
            case MANIPURI: {
                return "Manipuri_Vrinda.xml";
            }
            case MARATHI: {
                return "Marathi_Mangal.xml";
            }
            case NEPALI: {
                return "Nepali_Mangal.xml";
            }
            case ORIYA: {
                return "Oriya_Kalinga.xml";
            }
            case PUNJABI: {
                return "Punjabi_Raavi.xml";
            }
            case TAMIL: {
                return "Tamil_Latha.xml";
            }
            case TELUGU: {
                return "Telugu_Raavi.xml";
            }
            case URDU: {
                return "Urdu_Naskh.xml";
            }
        }
        return null;
    }

    public static String[] getLanguagesOnUnicode(String option) {
        option = option.trim();
        int a = option.codePointAt(0);
        if (option.length() > 1 && option.charAt(1) != ' ') {
            a = option.codePointAt(1);
        }
        if (a >= 48 && a <= 57) {
            String[] ret = new String[]{"en_in", "as_in", "bn_in", "gu_in", "hi_in", "kn_in", "kok_in", "ml_in", "mni_in", "mr_in", "ne_in", "or_in", "pa_in", "ta_in", "te_in", "ur_in"};
            return ret;
        }
        if (a >= 0 && a <= 127) {
            String[] ret = new String[]{"en_in"};
            return ret;
        }
        if (a >= 1536 && a <= 1791) {
            String[] ret = new String[]{"ur_in"};
            return ret;
        }
        if (a >= 2304 && a <= 2431) {
            String[] ret = new String[]{"hi_in", "mr_in", "ne_in", "kok_in"};
            return ret;
        }
        if (a >= 2432 && a <= 2559) {
            String[] ret = new String[]{"as_in", "bn_in", "mni_in"};
            return ret;
        }
        if (a >= 2560 && a <= 2687) {
            String[] ret = new String[]{"pa_in"};
            return ret;
        }
        if (a >= 2688 && a <= 2815) {
            String[] ret = new String[]{"gu_in"};
            return ret;
        }
        if (a >= 2816 && a <= 2943) {
            String[] ret = new String[]{"or_in"};
            return ret;
        }
        if (a >= 2944 && a <= 3071) {
            String[] ret = new String[]{"ta_in"};
            return ret;
        }
        if (a >= 3072 && a <= 3199) {
            String[] ret = new String[]{"te_in"};
            return ret;
        }
        if (a >= 3200 && a <= 3327) {
            String[] ret = new String[]{"kn_in"};
            return ret;
        }
        if (a >= 3328 && a <= 3455) {
            String[] ret = new String[]{"ml_in"};
            return ret;
        }
        return null;
    }

    public static String getPersistedFileName(Language l) {
        switch (l) {
            case ASSAMESE: {
                return "assamese_in.dat";
            }
            case BENGALI: {
                return "bengali_in.dat";
            }
            case GUJARATI: {
                return "gujarati_in.dat";
            }
            case HINDI: {
                return "hindi_in.dat";
            }
            case KANNADA: {
                return "kannada_in.dat";
            }
            case KONKANI: {
                return "konkani_in.dat";
            }
            case MALAYALAM: {
                return "malayalam_in.dat";
            }
            case MANIPURI: {
                return "manipuri_in.dat";
            }
            case MARATHI: {
                return "marathi_in.dat";
            }
            case NEPALI: {
                return "nepali_in.dat";
            }
            case ORIYA: {
                return "oriya_in.dat";
            }
            case PUNJABI: {
                return "punjabi_in.dat";
            }
            case TAMIL: {
                return "tamil_in.dat";
            }
            case TELUGU: {
                return "telugu_in.dat";
            }
            case URDU: {
                return "urdu_in.dat";
            }
        }
        return null;
    }
}

