/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.CogniTransEditDistance;
import com.cognirel.cognitrans.EditDistance;
import com.cognirel.cognitrans.Language;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class NameMatcher {
    private boolean syncDict;

    public NameMatcher(boolean syncPersist) {
        this.syncDict = syncPersist;
    }

    private List<String> Sort(String[] input) {
        List<String> wordList = Arrays.asList(input);
        Collections.sort(wordList);
        return wordList;
    }

    private boolean[] genInitials(List<String> strSorted) {
        boolean[] InitialStr = new boolean[strSorted.size()];
        int i = 0;
        while (i < strSorted.size()) {
            InitialStr[i] = strSorted.get(i).length() == 1;
            ++i;
        }
        return InitialStr;
    }

    private String getPermutation(String[] words, List<String> strSorted) {
        String ret = "";
        int i = 0;
        while (i < words.length) {
            ret = String.valueOf(ret) + String.valueOf(strSorted.indexOf(words[i]));
            ++i;
        }
        return ret;
    }

    private double doMatch(List<String> listSortedStr1, String strPerm1, List<String> listSortedStr2, String strPerm2) {
        double dist = this.editDistanceScore(strPerm1, strPerm2) / 3.0;
        double score = 0.0;
        int min = Math.min(listSortedStr2.size(), listSortedStr1.size());
        int max = Math.max(listSortedStr2.size(), listSortedStr1.size());
        List<String> strMin = listSortedStr2.size() > listSortedStr1.size() ? listSortedStr1 : listSortedStr2;
        List<String> strMax = listSortedStr2.size() <= listSortedStr1.size() ? listSortedStr1 : listSortedStr2;
        boolean[] strInitialsMin = this.genInitials(strMin);
        boolean[] strInitialsMax = this.genInitials(strMax);
        int i = 0;
        while (i < min) {
            String a = strMin.get(i);
            String b = "";
            double minScore = 100.0;
            int bestIndex = -1;
            int j = 0;
            while (j < max) {
                b = strMax.get(j);
                double edScore = this.editDistanceScore(a, b);
                if (edScore < minScore) {
                    minScore = edScore;
                    bestIndex = j;
                    if (minScore == 0.0) break;
                }
                ++j;
            }
            b = strMax.get(bestIndex);
            if (strInitialsMin[i] && strInitialsMax[bestIndex]) {
                if (a.equals(b)) {
                    score += 1.0;
                }
            } else if (strInitialsMin[i] || strInitialsMax[bestIndex]) {
                if (!a.equals("") && !b.equals("") && a.charAt(0) == b.charAt(0)) {
                    score += 0.75;
                }
            } else {
                score += 1.0 - minScore;
            }
            strMax.set(bestIndex, "");
            ++i;
        }
        double fLenFactor = 1.0 * (double)min / (double)max;
        return (1.0 - dist / 2.0) * (score / (double)min) * fLenFactor;
    }

    private double editDistanceScore(String t1, String t2) {
        int dist = EditDistance.editDistance(t1, t2);
        return 1.0 * (double)dist / (double)Math.max(t1.length(), t2.length());
    }

    public double match(String name1, Language lang1, String name2, Language lang2) {
        double matchScore = 0.0;
        if (lang1 == Language.ENGLISH && lang2 == Language.ENGLISH) {
            matchScore = this.phraseMatch(name1, name2);
            if (matchScore > 0.7) {
                return matchScore;
            }
            String[] aWords = name1.toLowerCase().split("[ ]+");
            String[] aWordsClone = (String[])aWords.clone();
            List<String> str1Sorted = this.Sort(aWordsClone);
            String[] bWords = name2.toLowerCase().split("[ ]+");
            String[] bWordsClone = (String[])bWords.clone();
            List<String> str2Sorted = this.Sort(bWordsClone);
            String dispStr1 = this.getPermutation(aWords, str1Sorted);
            String dispStr2 = this.getPermutation(bWords, str2Sorted);
            matchScore = this.doMatch(str1Sorted, dispStr1, str2Sorted, dispStr2);
        } else if (lang1 == Language.ENGLISH && lang2 != Language.ENGLISH) {
            String word;
            String[] sWords;
            String regLang = Language.getLanguageName(lang2);
            String tmp1 = CogniTransEditDistance.qp.transliterate(name1.toLowerCase(), regLang, this.syncDict ? TransliterationHints.PERSIST : TransliterationHints.NAME);
            String engWords1 = "";
            String engWords2 = "";
            String[] stringArray = sWords = tmp1.split("[ ]+");
            int n = sWords.length;
            int dispStr1 = 0;
            while (dispStr1 < n) {
                word = stringArray[dispStr1];
                engWords1 = String.valueOf(engWords1) + CogniTransEditDistance.qp.rtransliterate(word, regLang, new TransliterationHints[0]) + " ";
                ++dispStr1;
            }
            stringArray = sWords = name2.split("[ ]+");
            n = sWords.length;
            dispStr1 = 0;
            while (dispStr1 < n) {
                word = stringArray[dispStr1];
                engWords2 = String.valueOf(engWords2) + CogniTransEditDistance.qp.rtransliterate(word, regLang, new TransliterationHints[0]) + " ";
                ++dispStr1;
            }
            matchScore = this.phraseMatch(engWords1 = engWords1.trim(), engWords2 = engWords2.trim());
            if (matchScore > 0.7) {
                return matchScore;
            }
            matchScore = this.match2Names(engWords1, engWords2);
        } else if (lang1 != Language.ENGLISH && lang2 == Language.ENGLISH) {
            String word;
            String[] sWords;
            String regLang = Language.getLanguageName(lang1);
            String tmp1 = CogniTransEditDistance.qp.transliterate(name2.toLowerCase(), regLang, this.syncDict ? TransliterationHints.PERSIST : TransliterationHints.NAME);
            String engWords1 = "";
            String engWords2 = "";
            String[] stringArray = sWords = tmp1.split("[ ]+");
            int n = sWords.length;
            int dispStr1 = 0;
            while (dispStr1 < n) {
                word = stringArray[dispStr1];
                engWords1 = String.valueOf(engWords1) + CogniTransEditDistance.qp.rtransliterate(word, regLang, new TransliterationHints[0]) + " ";
                ++dispStr1;
            }
            stringArray = sWords = name1.split("[ ]+");
            n = sWords.length;
            dispStr1 = 0;
            while (dispStr1 < n) {
                word = stringArray[dispStr1];
                engWords2 = String.valueOf(engWords2) + CogniTransEditDistance.qp.rtransliterate(word, regLang, new TransliterationHints[0]) + " ";
                ++dispStr1;
            }
            matchScore = this.phraseMatch(engWords1 = engWords1.trim(), engWords2 = engWords2.trim());
            if (matchScore > 0.7) {
                return matchScore;
            }
            matchScore = this.match2Names(engWords1, engWords2);
        } else {
            String word;
            String regLang1 = Language.getLanguageName(lang1);
            String regLang2 = Language.getLanguageName(lang2);
            String engWords1 = "";
            String engWords2 = "";
            String[] sWords1 = name1.split("[ ]+");
            String[] sWords2 = name2.split("[ ]+");
            String[] stringArray = sWords1;
            int n = sWords1.length;
            int n2 = 0;
            while (n2 < n) {
                word = stringArray[n2];
                engWords1 = String.valueOf(engWords1) + CogniTransEditDistance.qp.rtransliterate(word, regLang1, this.syncDict ? TransliterationHints.PERSIST : TransliterationHints.NAME) + " ";
                ++n2;
            }
            stringArray = sWords2;
            n = sWords2.length;
            n2 = 0;
            while (n2 < n) {
                word = stringArray[n2];
                engWords2 = String.valueOf(engWords2) + CogniTransEditDistance.qp.rtransliterate(word, regLang2, this.syncDict ? TransliterationHints.PERSIST : TransliterationHints.NAME) + " ";
                ++n2;
            }
            matchScore = this.phraseMatch(engWords1 = engWords1.trim(), engWords2 = engWords2.trim());
            if (matchScore > 0.7) {
                return matchScore;
            }
            matchScore = this.match2Names(engWords1, engWords2);
        }
        return matchScore;
    }

    private double match2Names(String name1, String name2) {
        String[] aWords = name1.split("[ ]+");
        String[] aWordsClone = (String[])aWords.clone();
        List<String> str1Sorted = this.Sort(aWordsClone);
        String[] bWords = name2.split("[ ]+");
        String[] bWordsClone = (String[])bWords.clone();
        List<String> str2Sorted = this.Sort(bWordsClone);
        String dispStr1 = this.getPermutation(aWords, str1Sorted);
        String dispStr2 = this.getPermutation(bWords, str2Sorted);
        return this.doMatch(str1Sorted, dispStr1, str2Sorted, dispStr2);
    }

    private double phraseMatch(String enWord1, String enWord2) {
        enWord1 = enWord1.replace("[ \t\n\r]+", "");
        enWord2 = enWord2.replace("[ \t\n\r]+", "");
        double edScore = this.editDistanceScore(enWord1, enWord2);
        double score = 1.0 - edScore;
        return score;
    }
}

