/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans;

import com.cognirel.cognitrans.Language;

public class NumberProcessor {
    public static String[] numProc(Language lang, String number, String engSuffix) {
        switch (lang) {
            case ASSAMESE: {
                return NumberProcessor.assameseNumProc(lang, number, engSuffix);
            }
            case BENGALI: {
                return NumberProcessor.bengaliNumProc(lang, number, engSuffix);
            }
            case GUJARATI: {
                return NumberProcessor.gujaratiNumProc(lang, number, engSuffix);
            }
            case HINDI: {
                return NumberProcessor.hindiNumProc(lang, number, engSuffix);
            }
            case KANNADA: {
                return NumberProcessor.kannadaNumProc(lang, number, engSuffix);
            }
            case KONKANI: {
                return NumberProcessor.konkaniNumProc(lang, number, engSuffix);
            }
            case MALAYALAM: {
                return NumberProcessor.malayalamNumProc(lang, number, engSuffix);
            }
            case MANIPURI: {
                return NumberProcessor.manipuriNumProc(lang, number, engSuffix);
            }
            case MARATHI: {
                return NumberProcessor.marathiNumProc(lang, number, engSuffix);
            }
            case NEPALI: {
                return NumberProcessor.nepaliNumProc(lang, number, engSuffix);
            }
            case ORIYA: {
                return NumberProcessor.oriyaNumProc(lang, number, engSuffix);
            }
            case PUNJABI: {
                return NumberProcessor.punjabiNumProc(lang, number, engSuffix);
            }
            case TAMIL: {
                return NumberProcessor.tamilNumProc(lang, number, engSuffix);
            }
            case TELUGU: {
                return NumberProcessor.teluguNumProc(lang, number, engSuffix);
            }
            case URDU: {
                return NumberProcessor.urduNumProc(lang, number, engSuffix);
            }
        }
        return null;
    }

    private static String[] assameseNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] bengaliNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        switch (n) {
            case 1: {
                return NumberProcessor.twoStrings("\u09aa\u09cd\u09b0\u09a5\u09ae", "");
            }
            case 2: {
                return NumberProcessor.twoStrings("\u09a6\u09cd\u09ac\u09bf\u09a4\u09c0\u09af\u09bc", "");
            }
            case 3: {
                return NumberProcessor.twoStrings("\u09a4\u09c3\u09a4\u09c0\u09af\u09bc", "");
            }
            case 4: {
                return NumberProcessor.twoStrings("\u099a\u09a4\u09c1\u09b0\u09cd\u09a5", "");
            }
        }
        String suffix1 = "";
        String suffix2 = "";
        String digits = NumberProcessor.processDigits(lang, number);
        return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
    }

    private static String[] gujaratiNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        String digits = NumberProcessor.processDigits(lang, number);
        String suffix1 = "\u0aae\u0ac1";
        String suffix2 = "\u0aae\u0ac1";
        switch (n) {
            case 1: {
                suffix1 = "\u0ab2\u0ac1";
                suffix2 = "\u0ab2\u0ac1";
                return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
            }
            case 2: 
            case 3: {
                suffix1 = "\u0a9c\u0ac1";
                suffix2 = "\u0a9c\u0ac1";
                return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
            }
            case 4: 
            case 6: {
                suffix1 = "\u0aa5\u0ac1";
                suffix2 = "\u0aa5\u0ac1";
                return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
            }
        }
        return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
    }

    private static String[] hindiNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        switch (n) {
            case 1: {
                return NumberProcessor.twoStrings("\u092a\u0939\u0932\u093e", "\u092a\u0939\u0932\u0940");
            }
            case 2: {
                return NumberProcessor.twoStrings("\u0926\u0942\u0938\u0930\u093e", "\u0926\u0942\u0938\u0930\u0940");
            }
            case 3: {
                return NumberProcessor.twoStrings("\u0924\u0940\u0938\u0930\u093e", "\u0924\u0940\u0938\u0930\u0940");
            }
            case 4: {
                return NumberProcessor.twoStrings("\u091a\u094c\u0925\u093e", "\u091a\u094c\u0925\u0940");
            }
        }
        String suffix1 = "\u0935\u093e\u0901";
        String suffix2 = "\u0935\u0940\u0902";
        String digits = NumberProcessor.processDigits(lang, number);
        return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
    }

    private static String[] kannadaNumProc(Language lang, String number, String engSuffix) {
        String suffix = "\u0ca8\u0cc7";
        return NumberProcessor.simpleSuffix(lang, number, suffix);
    }

    private static String[] konkaniNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] malayalamNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{number};
        return ret;
    }

    private static String[] manipuriNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        switch (n) {
            case 1: {
                return NumberProcessor.twoStrings("\u092a\u0939\u093f\u0932\u094b", "");
            }
            case 2: {
                return NumberProcessor.twoStrings("\u0926\u094b\u0938\u094d\u0930\u094b", "");
            }
            case 3: {
                return NumberProcessor.twoStrings("\u0924\u0947\u0938\u094d\u0930\u094b", "");
            }
        }
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] marathiNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] nepaliNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] oriyaNumProc(Language lang, String number, String engSuffix) {
        String[] ret = new String[]{NumberProcessor.processDigits(lang, number)};
        return ret;
    }

    private static String[] punjabiNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        switch (n) {
            case 1: {
                return NumberProcessor.twoStrings("\u0a2a\u0a39\u0a3f\u0a32\u0a3e", "");
            }
            case 2: {
                return NumberProcessor.twoStrings("\u0a26\u0a42\u0a1c\u0a3e", "");
            }
            case 3: {
                return NumberProcessor.twoStrings("\u0a24\u0a40\u0a1c\u0a3e", "");
            }
            case 4: {
                return NumberProcessor.twoStrings("\u0a1a\u0a4c\u0a25\u0a3e", "");
            }
        }
        String suffix = "\u0a35\u0a3e\u0a02";
        return NumberProcessor.simpleSuffix(lang, number, suffix);
    }

    private static String[] tamilNumProc(Language lang, String number, String engSuffix) {
        String suffix = "\u0bb5\u0ba4\u0bc1";
        return NumberProcessor.simpleSuffix(lang, number, suffix);
    }

    private static String[] teluguNumProc(Language lang, String number, String engSuffix) {
        String suffix = "\u0c35";
        return NumberProcessor.simpleSuffix(lang, number, suffix);
    }

    private static String[] urduNumProc(Language lang, String number, String engSuffix) {
        int n = Integer.parseInt(number);
        switch (n) {
            case 1: {
                return NumberProcessor.twoStrings("\u067e\u06c1\u0644\u0627", "");
            }
            case 2: {
                return NumberProcessor.twoStrings("\u062f\u0648\u0633\u0631\u0627", "");
            }
            case 3: {
                return NumberProcessor.twoStrings("\u062a\u06cc\u0633\u0631\u0627", "");
            }
            case 4: {
                return NumberProcessor.twoStrings("\u0686\u0648\u062a\u06be\u0627", "");
            }
            case 5: {
                return NumberProcessor.twoStrings("\u067e\u0627\u0646\u0686\u0648\u0627\u06ba", "");
            }
            case 6: {
                return NumberProcessor.twoStrings("\u0686\u06be\u0679\u0627", "");
            }
        }
        String suffix1 = "\u0648\u0627\u06ba";
        String suffix2 = "\u0648\u06d2\u06ba";
        String digits = NumberProcessor.processDigits(lang, number);
        return NumberProcessor.twoStrings(String.valueOf(digits) + suffix1, String.valueOf(digits) + suffix2);
    }

    private static String[] simpleSuffix(Language lang, String number, String suffix) {
        String[] ret = new String[]{String.valueOf(NumberProcessor.processDigits(lang, number)) + suffix};
        return ret;
    }

    public static String processDigits(Language lang, String input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            int code = input.codePointAt(i) - 48 + Language.getDigitStart(lang);
            sb.append((char)code);
            ++i;
        }
        return sb.toString();
    }

    private static String[] twoStrings(String s1, String s2) {
        String[] ret = new String[]{s1, s2};
        return ret;
    }
}

