/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.cognitrans.engine.Charmap;
import com.cognirel.cognitrans.engine.Classes;
import com.cognirel.cognitrans.engine.Nodes;
import com.cognirel.cognitrans.engine.PredictiveFeatures;
import com.cognirel.util.Util;

public class CART {
    String treeFilename;
    byte[] treeData;
    Nodes nodes;
    Classes classes;
    PredictiveFeatures predFeatures;
    int FEATURE_BITS;
    int FEATURE_MASK;
    int RELIDX_MASK;
    int CLASS_MASK;
    int BI_CLASS_MASK;
    int TOTAL_BITS;

    public CART(String path, int charcode, PredictiveFeatures pf, Charmap cmap, int fbits, int cbits) {
        this.treeFilename = String.valueOf(path) + "predictive-" + charcode + ".dat";
        this.nodes = new Nodes();
        this.classes = new Classes(cmap);
        this.predFeatures = pf;
        this.nodes.TERM_BITS = cbits;
        this.nodes.NONTERM_BITS = 9 + fbits;
        this.TOTAL_BITS = fbits + 9;
        this.FEATURE_BITS = fbits;
        this.FEATURE_MASK = (1 << fbits) - 1;
        this.CLASS_MASK = (1 << cbits) - 1;
        this.BI_CLASS_MASK = (1 << cbits * 2) - 1;
        this.RELIDX_MASK = (1 << fbits + 9) - 1 - this.FEATURE_MASK;
    }

    public void load() {
        this.treeData = Util.loadBinFile(this.treeFilename);
        this.nodes.load(String.valueOf(this.treeFilename) + ".nodes");
        this.classes.load(String.valueOf(this.treeFilename) + "-classes");
    }

    private int readBits(int bits) {
        int bytes_to_read;
        int idx = this.nodes.getBitPosition() / 8;
        int pos = this.nodes.getBitPosition() % 8;
        int x = 0;
        int rshift = bits - (8 - pos);
        if (rshift <= 0) {
            rshift = rshift < 0 ? -rshift : 0;
            bytes_to_read = 1;
        } else {
            bytes_to_read = 1 + rshift / 8;
            if (rshift % 8 != 0) {
                rshift = 8 - rshift % 8;
                ++bytes_to_read;
            } else {
                rshift = 0;
            }
        }
        int lshift = 32 - bits - rshift;
        int i = 0;
        while (i < bytes_to_read) {
            x <<= 8;
            x |= this.treeData[idx + i] & 0xFF;
            ++i;
        }
        x <<= lshift;
        return x >>= rshift + lshift;
    }

    private int[] getRelativeIndex(int bits) {
        int[] ret = new int[2];
        int val = (bits & this.RELIDX_MASK) >> this.FEATURE_BITS;
        ret[0] = (val & 0xE0) >> 5;
        if ((val & 0x100) != 0) {
            ret[0] = -ret[0];
        }
        ret[1] = val & 0xF;
        if ((val & 0x10) != 0) {
            ret[1] = -ret[1];
        }
        return ret;
    }

    public String[] lookup(String input, int focusIdx) {
        this.nodes.reset();
        while (!this.nodes.isTerminal()) {
            int bits = this.readBits(this.TOTAL_BITS);
            int featureId = bits & this.FEATURE_MASK;
            int[] relIdx = this.getRelativeIndex(bits);
            if (featureId == this.FEATURE_MASK) {
                this.nodes.moveLeft();
                int classId = this.readBits(this.nodes.TERM_BITS * 2) & this.BI_CLASS_MASK;
                return this.classes.getClasses(classId);
            }
            if (featureId > this.predFeatures.numFeatures() - 1 && featureId < this.FEATURE_MASK) {
                if (this.predFeatures.match(featureId, input, focusIdx, relIdx)) {
                    this.nodes.moveRight();
                    continue;
                }
                this.nodes.moveLeft();
                continue;
            }
            if (this.predFeatures.match(featureId, input, focusIdx, relIdx)) {
                this.nodes.moveLeft();
                continue;
            }
            this.nodes.moveRight();
        }
        int classId = this.readBits(this.nodes.TERM_BITS) & this.CLASS_MASK;
        return this.classes.getClasses(classId);
    }
}

