/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.util.CogniLogger;
import com.cognirel.util.LineReader;
import java.io.IOException;

public class Charmap {
    private String halanth;
    private String[] cmap;

    public Charmap(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        try {
            this.halanth = r.readLineUnicode();
            int lineCount = Integer.parseInt(r.readLine());
            this.cmap = new String[lineCount];
            int i = 0;
            while (i < lineCount) {
                this.cmap[i] = r.readLineUnicode();
                ++i;
            }
        }
        catch (IOException e) {
            CogniLogger.error("Error reading the character map file: " + filename, e);
        }
    }

    public String decode(int b) {
        String ret = this.cmap[b & 0x7F];
        if ((b & 0x80) != 0) {
            ret = String.valueOf(ret) + this.halanth;
        }
        return ret;
    }
}

