/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.LanguageConfig;
import com.cognirel.cognitrans.engine.CART;
import com.cognirel.cognitrans.engine.Charmap;
import com.cognirel.cognitrans.engine.Dictionary;
import com.cognirel.cognitrans.engine.Option;
import com.cognirel.cognitrans.engine.PredictiveFeatures;
import com.cognirel.cognitrans.engine.Preproc;
import com.cognirel.util.CogniLogger;
import java.util.Hashtable;

public class CogniTransLanguage {
    private Hashtable<Integer, CART> carts;
    private Dictionary dict;
    private Language lang;
    private Preproc preProcessor;

    public CogniTransLanguage(Language lang, String path, PredictiveFeatures pf, Charmap cmap, Dictionary dict) {
        this.lang = lang;
        this.dict = dict;
        this.carts = new Hashtable();
        int[] cartNumbers = LanguageConfig.getConfig(lang).getCarts();
        int i = 0;
        while (i < cartNumbers.length) {
            this.carts.put(new Integer(cartNumbers[i]), new CART(path, cartNumbers[i], pf, cmap, LanguageConfig.getConfig(lang).getFeatureBits(), LanguageConfig.getConfig(lang).getClassBits()));
            ++i;
        }
        this.preProcessor = new Preproc();
    }

    public void load() {
        int[] cartNumbers = LanguageConfig.getConfig(this.lang).getCarts();
        int i = 0;
        while (i < cartNumbers.length) {
            this.carts.get(new Integer(cartNumbers[i])).load();
            ++i;
        }
    }

    public Option convert(String input_) {
        String input = this.preProcessor.process(input_, this.lang);
        String cartInput = "#" + input + "_";
        Option ret = new Option(this.dict, input.length());
        int i = 0;
        while (i < input.length()) {
            String[] res;
            try {
                res = this.carts.get(new Integer(input.charAt(i))).lookup(cartInput, i + 1);
                ret.add(res);
            }
            catch (Exception e) {
                int ch = input.charAt(i) == 'z' ? 106 : (input.charAt(i) == 'q' ? 107 : (int)input.toLowerCase().charAt(i));
                try {
                    res = this.carts.get(new Integer(ch)).lookup(cartInput, i + 1);
                    ret.add(res);
                }
                catch (Exception ex) {
                    CogniLogger.info("CART failure, we don't have the cart for: " + input.charAt(i), e);
                    res = new String[]{input.substring(i, i + 1)};
                    ret.add(res);
                }
            }
            ++i;
        }
        ret.done();
        return ret;
    }
}

