/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.util.CogniLogger;
import com.cognirel.util.LineReader;
import com.cognirel.util.Util;
import java.io.IOException;
import java.util.Hashtable;

public class Dictionary {
    public static final int BLOCK_SIZE = 25;
    public static final int BLOCK_ELEMENTS = 8;
    private Hashtable<String, Integer> vowels = new Hashtable();
    private Hashtable<String, Integer> mathras = new Hashtable();
    private byte[] dictData;
    private int numBlocks;

    public long getBlockElem(int blockNum, int which) {
        int idx = blockNum * 25 + 4 + which * 3;
        return (long)((this.dictData[idx] & 0xFF) << 16 | (this.dictData[idx + 1] & 0xFF) << 8 | this.dictData[idx + 2] & 0xFF) & 0xFFFFFFFFL;
    }

    public long getBlockHeader(int blockNum) {
        int idx = blockNum * 25;
        return (long)((this.dictData[idx] & 0xFF) << 24 | (this.dictData[idx + 1] & 0xFF) << 16 | (this.dictData[idx + 2] & 0xFF) << 8 | this.dictData[idx + 3] & 0xFF) & 0xFFFFFFFFL;
    }

    public int findBlock(long hash) {
        int low = 0;
        int high = this.numBlocks - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            long val = this.getBlockHeader((low + high) / 2);
            if (val == hash) {
                return mid;
            }
            if (val < hash) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return (low + high) / 2;
    }

    public void load(String filename, String vowelsFile, String mathrasFile) {
        this.dictData = Util.loadBinFile(filename);
        this.numBlocks = this.dictData.length / 25;
        if (this.dictData.length % 25 != 0) {
            ++this.numBlocks;
        }
        LineReader r1 = new LineReader();
        LineReader r2 = new LineReader();
        r1.load(vowelsFile);
        r2.load(mathrasFile);
        String temp = null;
        try {
            r1.readLineUnicode();
            while (!(temp = r1.readLineUnicode()).equals("")) {
                this.vowels.put(temp, new Integer(1));
            }
        }
        catch (IOException e) {
            CogniLogger.error("Error reading the vowels data file: " + vowelsFile);
        }
        catch (NullPointerException e) {
            CogniLogger.error("NULL Pointer observed while reading vowels data file: " + vowelsFile);
        }
        try {
            r2.readLineUnicode();
            while (!(temp = r2.readLineUnicode()).equals("")) {
                this.mathras.put(temp, new Integer(1));
            }
        }
        catch (IOException e) {
            CogniLogger.error("Error reading the mathras data file:" + mathrasFile);
        }
        catch (NullPointerException e) {
            CogniLogger.error("NULL Pointer observed while reading mathras data file: " + mathrasFile);
        }
    }

    private boolean hashExists(long hash) {
        int remaining;
        int blockNum = this.findBlock(hash);
        long total = this.getBlockHeader(blockNum);
        if (total == hash) {
            return true;
        }
        int elemCount = 7;
        if (blockNum == this.numBlocks - 1 && (remaining = this.dictData.length % 25) != 0) {
            elemCount = (remaining - 4) / 3;
        }
        int i = 0;
        while (i < elemCount) {
            if ((total += this.getBlockElem(blockNum, i)) == hash) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDictWord(String word) {
        long hashValue = this.wordHash(Util.encodeUTF8(word));
        return this.hashExists(hashValue);
    }

    public boolean isValidWord(String[][] tokens, int[] pos) {
        boolean prevIsMathra = false;
        boolean prevIsVowel = false;
        int i = 0;
        while (i < tokens.length) {
            boolean curIsVowel = this.vowels.containsKey(tokens[i][pos[i]]);
            boolean curIsMathra = this.mathras.containsKey(tokens[i][pos[i]]);
            if (prevIsMathra && curIsMathra || prevIsVowel && curIsMathra) {
                return false;
            }
            prevIsMathra = curIsMathra;
            prevIsVowel = curIsVowel;
            ++i;
        }
        return true;
    }

    private long wordHash(byte[] key) {
        long hash = 0L;
        int i = 0;
        while (i < key.length) {
            hash += (long)key[i];
            hash &= 0xFFFFFFFFL;
            hash += hash << 10;
            hash &= 0xFFFFFFFFL;
            hash ^= hash >> 6;
            hash &= 0xFFFFFFFFL;
            ++i;
        }
        hash += hash << 3;
        hash &= 0xFFFFFFFFL;
        hash ^= hash >> 11;
        hash &= 0xFFFFFFFFL;
        hash += hash << 15;
        return hash & 0xFFFFFFFFL;
    }
}

