/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.util.CogniLogger;
import com.cognirel.util.LineReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

public class ExtraDictionary {
    private Hashtable<String, String> dict = new Hashtable();
    private HashSet<String> clashWords = new HashSet();

    public void loadDict(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        if (!r.isOK()) {
            CogniLogger.info("failed to load '" + filename + "' in Dictionary");
            return;
        }
        try {
            while (true) {
                String line;
                String[] words;
                if ((words = (line = r.readLineUnicode()).split("\\s+")).length < 2) {
                    continue;
                }
                this.dict.put(words[0], words[1]);
            }
        }
        catch (IOException e) {
            if (!e.getMessage().equals("EOF")) {
                CogniLogger.info("Couldn't load extra Dictionary file  (ignoring)");
            }
        }
        catch (NullPointerException e) {
            CogniLogger.info("Couldn't load extra Dictionary file (ignoring)");
        }
    }

    public void loadRevDict(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        if (!r.isOK()) {
            CogniLogger.info("failed to load '" + filename + "' in Dictionary");
            return;
        }
        try {
            while (true) {
                String line;
                String[] words;
                if ((words = (line = r.readLineUnicode()).split("\\s+")).length < 2) {
                    continue;
                }
                this.dict.put(words[1], words[0]);
            }
        }
        catch (IOException e) {
            if (!e.getMessage().equals("EOF")) {
                CogniLogger.info("Couldn't load Reverse Dictionary file");
            }
            return;
        }
    }

    public void loadClash(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        if (!r.isOK()) {
            CogniLogger.debug("failed to load '" + filename + "' in ExtraDictionary");
            return;
        }
        try {
            while (true) {
                String line = r.readLineUnicode();
                this.clashWords.add(line);
            }
        }
        catch (IOException e) {
            e.getMessage().equals("EOF");
            return;
        }
    }

    public boolean isClashing(String word) {
        return this.clashWords.contains(word);
    }

    public String get(String word) {
        return this.dict.get(word);
    }

    public void addWord(String key, String value) {
        this.dict.put(key, value);
    }

    public void load(ObjectInputStream in) throws IOException {
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.dict.put(key, value);
            ++i;
        }
    }

    public void store(ObjectOutputStream out) throws IOException {
        out.writeInt(this.dict.size());
        for (Map.Entry<String, String> set : this.dict.entrySet()) {
            out.writeUTF(set.getKey());
            out.writeUTF(set.getValue());
        }
    }
}

