/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.cognitrans.engine.InvarIndex;
import com.cognirel.util.CogniLogger;
import com.cognirel.util.LineReader;
import java.io.IOException;

public class PredictiveFeatures {
    private String[][] featureArray;
    private int numFeatures;

    private void readFeature(LineReader r, int index) throws IOException {
        int count = Integer.parseInt(r.readLine());
        String[] tmp = new String[count];
        int i = 0;
        while (i < count) {
            tmp[i] = r.readLine();
            ++i;
        }
        this.featureArray[index] = tmp;
    }

    public PredictiveFeatures(String filename) {
        LineReader r = new LineReader();
        r.load(filename);
        try {
            this.numFeatures = Integer.parseInt(r.readLine());
            this.featureArray = new String[this.numFeatures][];
            int i = 0;
            while (i < this.numFeatures) {
                this.readFeature(r, i);
                ++i;
            }
        }
        catch (IOException e) {
            CogniLogger.error("Error in loading features: " + filename, e);
        }
        CogniLogger.info(String.valueOf(this.numFeatures) + " features loaded");
    }

    public int numFeatures() {
        return this.featureArray.length;
    }

    public boolean match_(int featureId, String input, int pos) {
        if (pos < 0 || pos >= input.length()) {
            return false;
        }
        String[] features = this.featureArray[featureId];
        int i = 0;
        while (i < features.length) {
            if (features[i].length() != 0 && input.regionMatches(false, pos, features[i], 0, features[i].length())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(int featureId, String word, int focus, int[] relativeIndex) {
        int[][] keyIndices = InvarIndex.getIndList(word);
        boolean posPresent = false;
        int realIndex = 0;
        int[] focusIJ = keyIndices[focus];
        int[][] nArray = keyIndices;
        int n = keyIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int[] index = nArray[n2];
            if (index[0] - focusIJ[0] == relativeIndex[0] && index[1] - focusIJ[1] == relativeIndex[1]) {
                posPresent = true;
                break;
            }
            ++realIndex;
            ++n2;
        }
        if (!posPresent) {
            return false;
        }
        return this.match_(featureId, word, realIndex);
    }
}

