/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.cognitrans.Language;

public class Preproc {
    private String input;
    private int idx;
    private int len;

    private void load(String input_) {
        this.input = input_;
        this.idx = 0;
        this.len = this.input.length();
    }

    private char getchar() {
        if (this.idx < this.len) {
            char c = this.input.charAt(this.idx);
            ++this.idx;
            return c;
        }
        ++this.idx;
        return '\u0000';
    }

    private void ungetchar() {
        if (this.idx > 0) {
            --this.idx;
        }
    }

    public String process(String input_, Language lang) {
        switch (lang) {
            case ASSAMESE: {
                return this.assamesePreproc(input_);
            }
            case BENGALI: {
                return this.bengaliPreproc(input_);
            }
            case GUJARATI: {
                return this.gujaratiPreproc(input_);
            }
            case HINDI: {
                return this.hindiPreproc(input_);
            }
            case KANNADA: {
                return this.kannadaPreproc(input_);
            }
            case KONKANI: {
                return this.konkaniPreproc(input_);
            }
            case MALAYALAM: {
                return this.malayalamPreproc(input_);
            }
            case MANIPURI: {
                return this.manipuriPreproc(input_);
            }
            case MARATHI: {
                return this.marathiPreproc(input_);
            }
            case NEPALI: {
                return this.nepaliPreproc(input_);
            }
            case ORIYA: {
                return this.oriyaPreproc(input_);
            }
            case PUNJABI: {
                return this.punjabiPreproc(input_);
            }
            case TAMIL: {
                return this.tamilPreproc(input_);
            }
            case TELUGU: {
                return this.teluguPreproc(input_);
            }
            case URDU: {
                return this.urduPreproc(input_);
            }
        }
        return null;
    }

    private String assamesePreproc(String input) {
        return this.bengaliPreproc(input);
    }

    private String bengaliPreproc(String input) {
        char c;
        if (input.equals("hum")) {
            input = "ham";
        }
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block11: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        continue block11;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block11;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block11;
                    }
                    buf.append("i");
                    this.ungetchar();
                    continue block11;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block11;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block11;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block11;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block11;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block11;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block11;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block11;
                }
                case 'q': {
                    buf.append("k");
                    continue block11;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block11;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block11;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block11;
                }
                case 'w': {
                    buf.append("v");
                    continue block11;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String gujaratiPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block10: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block10;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        continue block10;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block10;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block10;
                    }
                    buf.append("i");
                    this.ungetchar();
                    continue block10;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block10;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block10;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block10;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block10;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block10;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block10;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block10;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block10;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block10;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block10;
                }
                case 'w': {
                    buf.append("v");
                    continue block10;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String hindiPreproc(String input) {
        char c;
        if (input.equals("hum")) {
            return "ham";
        }
        if (input.equals("hoon")) {
            return "hUm";
        }
        if (input.startsWith("sri")) {
            input = input.replaceFirst("sri", "shri");
        } else if (input.startsWith("srI")) {
            input = input.replaceFirst("srI", "shrI");
        } else if (input.startsWith("vru")) {
            input = input.replaceFirst("vru", "ru");
        }
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block11: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 == 'c' && c3 == 'h') {
                        buf.append("chch");
                        continue block11;
                    }
                    buf.append('c');
                    this.ungetchar();
                    this.ungetchar();
                    continue block11;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block11;
                    }
                    buf.append("i");
                    this.ungetchar();
                    continue block11;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block11;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block11;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block11;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block11;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block11;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block11;
                    }
                    if (c2 == 'a') {
                        buf.append('o');
                        continue block11;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block11;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block11;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block11;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block11;
                }
                case 'w': {
                    buf.append("v");
                    continue block11;
                }
                case 'g': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    char c4 = this.getchar();
                    if (c2 == 'y' && c3 == 'a' && c4 == 'n') {
                        buf.append("gnyan");
                        continue block11;
                    }
                    if (c2 == 'a' && c3 == 'r' && c4 == 'h') {
                        buf.append("gadh");
                        continue block11;
                    }
                    if (c2 == 'a' && c3 == 'o' && c4 == 'n') {
                        buf.append("ganv");
                        continue block11;
                    }
                    buf.append('g');
                    this.ungetchar();
                    this.ungetchar();
                    this.ungetchar();
                    continue block11;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String kannadaPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block13: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 == 'c' && c3 == 'h') {
                        buf.append("chch");
                        continue block13;
                    }
                    buf.append('c');
                    this.ungetchar();
                    this.ungetchar();
                    continue block13;
                }
                case 'i': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'a' && c3 == 'h') {
                        char c4 = this.getchar();
                        if (c4 != 'a' && c4 != 'e' && c4 != 'i' && c4 != 'o' && c4 != 'u' && c4 != 'y' || c4 == '\u0000') {
                            buf.append("yya");
                            this.ungetchar();
                            continue block13;
                        }
                        buf.append("i");
                        this.ungetchar();
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 == 'a') {
                        buf.append("iya");
                        this.ungetchar();
                        continue block13;
                    }
                    buf.append("i");
                    this.ungetchar();
                    this.ungetchar();
                    continue block13;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block13;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block13;
                    }
                    if (c2 == 'o') {
                        buf.append("av");
                        continue block13;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block13;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block13;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block13;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block13;
                    }
                    if (c2 == 'w') {
                        buf.append("ou");
                        continue block13;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block13;
                }
                case 'w': {
                    buf.append("v");
                    continue block13;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block13;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block13;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block13;
                }
                case 'y': {
                    char c2 = this.getchar();
                    if (c2 == '\u0000') {
                        buf.append('i');
                        this.ungetchar();
                        continue block13;
                    }
                    buf.append('y');
                    this.ungetchar();
                    continue block13;
                }
                case 'q': {
                    buf.append('k');
                    continue block13;
                }
                case 'f': {
                    char c2 = this.getchar();
                    if (c2 == 'f') {
                        buf.append('f');
                        continue block13;
                    }
                    buf.append('f');
                    this.ungetchar();
                    continue block13;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String konkaniPreproc(String input) {
        return this.marathiPreproc(input);
    }

    private String malayalamPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block11: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        continue block11;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block11;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block11;
                    }
                    buf.append('i');
                    this.ungetchar();
                    continue block11;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block11;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block11;
                    }
                    buf.append('a');
                    this.ungetchar();
                    continue block11;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block11;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block11;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block11;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block11;
                }
                case 'q': {
                    buf.append("k");
                    continue block11;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block11;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block11;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block11;
                }
                case 'w': {
                    buf.append("v");
                    continue block11;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String manipuriPreproc(String input) {
        return this.bengaliPreproc(input);
    }

    private String marathiPreproc(String input) {
        char c;
        if (input.equals("hum")) {
            return "ham";
        }
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block10: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block10;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        continue block10;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block10;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block10;
                    }
                    buf.append('i');
                    this.ungetchar();
                    continue block10;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block10;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block10;
                    }
                    buf.append('a');
                    this.ungetchar();
                    continue block10;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block10;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block10;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block10;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block10;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block10;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block10;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block10;
                }
                case 'w': {
                    buf.append("v");
                    continue block10;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String nepaliPreproc(String input) {
        return this.hindiPreproc(input);
    }

    private String oriyaPreproc(String input) {
        char c;
        if (input.equals("hum")) {
            return "ham";
        }
        if (input.equals("hoon")) {
            return "hoom";
        }
        if (input.startsWith("sri")) {
            input = input.replaceFirst("sri", "shri");
        } else if (input.startsWith("srI")) {
            input = input.replaceFirst("srI", "shrI");
        }
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block11: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        this.ungetchar();
                        continue block11;
                    }
                    if (c2 == 'c' && c3 == 'h') {
                        buf.append("chch");
                        continue block11;
                    }
                    buf.append('c');
                    this.ungetchar();
                    this.ungetchar();
                    continue block11;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append('A');
                        continue block11;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block11;
                    }
                    buf.append('a');
                    this.ungetchar();
                    continue block11;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block11;
                    }
                    buf.append('i');
                    this.ungetchar();
                    continue block11;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append('I');
                        continue block11;
                    }
                    buf.append('e');
                    this.ungetchar();
                    continue block11;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append('U');
                        continue block11;
                    }
                    if (c2 == 'a') {
                        buf.append('o');
                        continue block11;
                    }
                    buf.append('o');
                    this.ungetchar();
                    continue block11;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block11;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append('f');
                        continue block11;
                    }
                    buf.append('p');
                    this.ungetchar();
                    continue block11;
                }
                case 'w': {
                    buf.append('v');
                    continue block11;
                }
                case 'g': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    char c4 = this.getchar();
                    if (c2 == 'y' && c3 == 'a' && c4 == 'n') {
                        buf.append("gnyan");
                        continue block11;
                    }
                    if (c2 == 'a' && c3 == 'r' && c4 == 'h') {
                        buf.append("gadh");
                        continue block11;
                    }
                    buf.append('g');
                    this.ungetchar();
                    this.ungetchar();
                    this.ungetchar();
                    continue block11;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String punjabiPreproc(String input) {
        char c;
        if (input.startsWith("punjab")) {
            input = input.replaceAll("punjab", "panjab");
        }
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block9: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block9;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        continue block9;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block9;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block9;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block9;
                    }
                    buf.append('a');
                    this.ungetchar();
                    continue block9;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block9;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block9;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block9;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block9;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block9;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block9;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block9;
                }
                case 'w': {
                    buf.append("v");
                    continue block9;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String tamilPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block21: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        continue block21;
                    }
                    if (c2 != 'h' || c2 == '\u0000') {
                        buf.append('k');
                        this.ungetchar();
                        continue block21;
                    }
                    buf.append('c');
                    this.ungetchar();
                    continue block21;
                }
                case 'i': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("iya");
                        continue block21;
                    }
                    buf.append('i');
                    this.ungetchar();
                    continue block21;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block21;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block21;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block21;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block21;
                    }
                    buf.append('o');
                    this.ungetchar();
                    continue block21;
                }
                case 'w': {
                    buf.append("v");
                    continue block21;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block21;
                }
                case 'k': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append('k');
                        continue block21;
                    }
                    buf.append('k');
                    this.ungetchar();
                    continue block21;
                }
                case 'K': {
                    buf.append('k');
                    continue block21;
                }
                case 'g': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append('g');
                        continue block21;
                    }
                    buf.append('g');
                    this.ungetchar();
                    continue block21;
                }
                case 'G': {
                    buf.append('g');
                    continue block21;
                }
                case 'C': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("ch");
                        continue block21;
                    }
                    buf.append('C');
                    this.ungetchar();
                    continue block21;
                }
                case 'j': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("j");
                        continue block21;
                    }
                    buf.append('j');
                    this.ungetchar();
                    continue block21;
                }
                case 'J': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("j");
                        continue block21;
                    }
                    buf.append('j');
                    this.ungetchar();
                    continue block21;
                }
                case 'z': {
                    char c2 = this.getchar();
                    if (c2 != 'h') {
                        buf.append('j');
                        this.ungetchar();
                        continue block21;
                    }
                    buf.append('z');
                    this.ungetchar();
                    continue block21;
                }
                case 'd': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append('d');
                        continue block21;
                    }
                    buf.append('d');
                    this.ungetchar();
                    continue block21;
                }
                case 'D': {
                    buf.append('d');
                    continue block21;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block21;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block21;
                }
                case 'b': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("b");
                        continue block21;
                    }
                    buf.append("b");
                    this.ungetchar();
                    continue block21;
                }
                case 'B': {
                    buf.append('b');
                    continue block21;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String teluguPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block13: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'c': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'e' || c2 == 'i' || c2 == 'y') {
                        buf.append('s');
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 != 'h') {
                        buf.append('k');
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 == 'c' && c3 == 'h') {
                        buf.append("chch");
                        continue block13;
                    }
                    buf.append('c');
                    this.ungetchar();
                    this.ungetchar();
                    continue block13;
                }
                case 'i': {
                    char c2 = this.getchar();
                    char c3 = this.getchar();
                    if (c2 == 'a' && c3 == 'h') {
                        char c4 = this.getchar();
                        if (c4 != 'a' && c4 != 'e' && c4 != 'i' && c4 != 'o' && c4 != 'u' && c4 != 'y' || c4 == '\u0000') {
                            buf.append("yya");
                            this.ungetchar();
                            continue block13;
                        }
                        buf.append("i");
                        this.ungetchar();
                        this.ungetchar();
                        this.ungetchar();
                        continue block13;
                    }
                    if (c2 == 'a') {
                        buf.append("iya");
                        this.ungetchar();
                        continue block13;
                    }
                    buf.append("i");
                    this.ungetchar();
                    this.ungetchar();
                    continue block13;
                }
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block13;
                    }
                    if (c2 == 'u') {
                        buf.append("ou");
                        continue block13;
                    }
                    if (c2 == 'o') {
                        buf.append("av");
                        continue block13;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block13;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'w') {
                        buf.append("ou");
                        continue block13;
                    }
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block13;
                    }
                    buf.append('o');
                    this.ungetchar();
                    continue block13;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block13;
                    }
                    buf.append('e');
                    this.ungetchar();
                    continue block13;
                }
                case 'p': {
                    char c2 = this.getchar();
                    if (c2 == 'h') {
                        buf.append("f");
                        continue block13;
                    }
                    buf.append("p");
                    this.ungetchar();
                    continue block13;
                }
                case 'x': {
                    buf.append("ksh");
                    continue block13;
                }
                case 'w': {
                    buf.append("v");
                    continue block13;
                }
                case 'y': {
                    char c2 = this.getchar();
                    if (c2 == '\u0000') {
                        buf.append("i");
                        this.ungetchar();
                        continue block13;
                    }
                    buf.append('y');
                    this.ungetchar();
                    continue block13;
                }
                case 'q': {
                    buf.append("k");
                    continue block13;
                }
                case 'f': {
                    char c2 = this.getchar();
                    if (c2 == 'f') {
                        buf.append('f');
                        continue block13;
                    }
                    buf.append('f');
                    this.ungetchar();
                    continue block13;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String urduPreproc(String input) {
        char c;
        this.load(input);
        StringBuffer buf = new StringBuffer();
        block6: while ((c = this.getchar()) != '\u0000') {
            switch (c) {
                case 'a': {
                    char c2 = this.getchar();
                    if (c2 == 'a') {
                        buf.append("A");
                        continue block6;
                    }
                    buf.append("a");
                    this.ungetchar();
                    continue block6;
                }
                case 'o': {
                    char c2 = this.getchar();
                    if (c2 == 'o') {
                        buf.append("U");
                        continue block6;
                    }
                    buf.append("o");
                    this.ungetchar();
                    continue block6;
                }
                case 'e': {
                    char c2 = this.getchar();
                    if (c2 == 'e') {
                        buf.append("I");
                        continue block6;
                    }
                    buf.append("e");
                    this.ungetchar();
                    continue block6;
                }
                case 'w': {
                    buf.append("v");
                    continue block6;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

