/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.cognitrans.engine;

import com.cognirel.cognitrans.CogniTransTransliterationProvider;
import com.cognirel.cognitrans.Language;
import com.cognirel.cognitrans.engine.CustomComparator;
import com.cognirel.cognitrans.engine.OldUserDictException;
import com.cognirel.cognitrans.engine.WordInfo;
import com.cognirel.util.CogniLogger;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import jdbm.PrimaryHashMap;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;

public class UserDictionary {
    private Hashtable<String, ArrayList<WordInfo>> dict = new Hashtable();
    private RecordManager recMan;
    private final String recordName = "userWordDict";
    private final String dictClassVersion = "2.0";
    private PrimaryHashMap<String, ArrayList<WordInfo>> diskHashMap;
    private boolean persistSync;
    private Language lang;

    public UserDictionary(Language l, boolean _persistSync) {
        this.lang = l;
        this.persistSync = _persistSync;
        if (this.persistSync) {
            File wordDictDirname = new File(CogniTransTransliterationProvider.getPersistenceLocation(), Language.getLanguageName(l));
            String wordDictFilename = new File(wordDictDirname, Language.getPersistedFileName(l)).getPath();
            if (!this.initializeRecMan(wordDictFilename)) {
                return;
            }
            Set loadedWordList = this.diskHashMap.entrySet();
            for (Map.Entry x : loadedWordList) {
                this.dict.put((String)x.getKey(), (ArrayList)x.getValue());
            }
        }
    }

    public ArrayList<String> get(String word) {
        ArrayList<WordInfo> x = this.dict.get(word);
        ArrayList<String> ret = new ArrayList<String>();
        if (x != null) {
            Collections.sort(x, new CustomComparator());
            for (WordInfo tmp : x) {
                ret.add(tmp.localWord);
            }
        }
        return ret;
    }

    public synchronized void addUserWord(String key, String value) {
        ArrayList<WordInfo> wordCountList = this.dict.get(key);
        if (wordCountList != null) {
            WordInfo wInfo2;
            for (WordInfo wInfo2 : wordCountList) {
                if (!value.equals(wInfo2.localWord)) continue;
                ++wInfo2.count;
                this.persist(key, wordCountList);
                return;
            }
            wInfo2 = new WordInfo();
            wInfo2.count = 1;
            wInfo2.localWord = value;
            wordCountList.add(wInfo2);
        } else {
            WordInfo wInfo = new WordInfo();
            wInfo.count = 1;
            wInfo.localWord = value;
            wordCountList = new ArrayList();
            wordCountList.add(wInfo);
            this.dict.put(key, wordCountList);
        }
        this.persist(key, wordCountList);
    }

    public synchronized void addUserWord(String key, String value, int count) {
        ArrayList<WordInfo> wordCountList = this.dict.get(key);
        if (wordCountList != null) {
            WordInfo wInfo2;
            for (WordInfo wInfo2 : wordCountList) {
                if (!value.equals(wInfo2.localWord)) continue;
                wInfo2.count += count;
                this.persist(key, wordCountList);
                return;
            }
            wInfo2 = new WordInfo();
            wInfo2.count = count;
            wInfo2.localWord = value;
            wordCountList.add(wInfo2);
        } else {
            WordInfo wInfo = new WordInfo();
            wInfo.count = count;
            wInfo.localWord = value;
            wordCountList = new ArrayList();
            wordCountList.add(wInfo);
            this.dict.put(key, wordCountList);
        }
        this.persist(key, wordCountList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(String engKey, ArrayList<WordInfo> wordCountList) {
        if (!(this.persistSync || this.diskHashMap != null && this.recMan != null)) {
            return;
        }
        PrimaryHashMap<String, ArrayList<WordInfo>> primaryHashMap = this.diskHashMap;
        synchronized (primaryHashMap) {
            this.diskHashMap.put((Object)engKey, wordCountList);
        }
    }

    public void commit() throws IOException {
        if (!(this.persistSync || this.diskHashMap != null && this.recMan != null)) {
            return;
        }
        this.recMan.commit();
    }

    public void close() throws Exception {
        if (!(this.persistSync || this.diskHashMap != null && this.recMan != null)) {
            return;
        }
        this.recMan.commit();
        this.recMan.defrag();
        this.recMan.close();
        this.diskHashMap = null;
        this.recMan = null;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean initializeRecMan(String wordDictFilename) {
        block6: {
            try {
                this.recMan = RecordManagerFactory.createRecordManager((String)wordDictFilename);
                this.diskHashMap = this.recMan.hashMap("userWordDict");
                break block6;
            }
            catch (Exception e) {
                CogniLogger.warn("Error opening the persisted dictionary file: " + wordDictFilename, e);
                return false;
            }
            catch (Error e) {
                outputFolder = new File(CogniTransTransliterationProvider.getPersistenceLocation(), Language.getLanguageName(this.lang));
                var8_6 = files = outputFolder.listFiles();
                var7_7 = files.length;
                var6_8 = 0;
                ** while (var6_8 < var7_7)
            }
lbl-1000:
            // 1 sources

            {
                f = var8_6[var6_8];
                f.delete();
                ++var6_8;
                continue;
            }
lbl19:
            // 1 sources

            try {
                this.recMan = RecordManagerFactory.createRecordManager((String)wordDictFilename);
                this.diskHashMap = this.recMan.hashMap("userWordDict");
            }
            catch (Exception e1) {
                this.recMan = null;
                this.diskHashMap = null;
                return false;
            }
        }
        return true;
    }

    public void load(ObjectInputStream in) throws IOException, OldUserDictException {
        String flag = in.readUTF();
        if (!flag.equals("2.0")) {
            throw new OldUserDictException();
        }
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            String key = in.readUTF();
            int wcInfoListSize = in.readInt();
            int wordIndex = 0;
            while (wordIndex < wcInfoListSize) {
                String localWord = in.readUTF();
                int wordCount = in.readInt();
                this.addUserWord(key, localWord, wordCount);
                ++wordIndex;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ObjectOutputStream out) throws IOException {
        Hashtable<String, ArrayList<WordInfo>> hashtable = this.dict;
        synchronized (hashtable) {
            out.writeUTF("2.0");
            out.writeInt(this.dict.size());
            for (Map.Entry<String, ArrayList<WordInfo>> set : this.dict.entrySet()) {
                out.writeUTF(set.getKey());
                ArrayList<WordInfo> wCInfoList = set.getValue();
                out.writeInt(wCInfoList.size());
                for (WordInfo wcInfo : wCInfoList) {
                    out.writeUTF(wcInfo.localWord);
                    out.writeInt(wcInfo.count);
                }
            }
        }
    }

    public void loadOld(ObjectInputStream in) throws IOException {
        int count = in.readInt();
        int i = 0;
        while (i < count) {
            String key = in.readUTF();
            int wcInfoListSize = 1;
            int wordIndex = 0;
            while (wordIndex < wcInfoListSize) {
                String localWord = in.readUTF();
                CogniLogger.info(String.valueOf(key) + "\t\t\t\t" + localWord + "\t\t\t\t" + 1);
                this.addUserWord(key, localWord);
                ++wordIndex;
            }
            ++i;
        }
    }
}

