/*
 * Decompiled with CFR 0.152.
 */
package com.cognirel.util;

import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CogniLogger {
    private static boolean loggingEnabled = true;
    private static long time = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.cognirel.util.CogniLogger");

    public static long getTime() {
        return time;
    }

    public static void addTime(long t) {
        time += t;
    }

    public static String URLencode(String s) {
        if (s != null) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception e) {
                CogniLogger.error("Encoding error found", e);
            }
        }
        return null;
    }

    public static void disable() {
        loggingEnabled = false;
    }

    public static void enable() {
        loggingEnabled = true;
    }

    public static void info(String msg) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.info(msg);
    }

    public static void info(String msg, Exception e) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.info(msg, (Throwable)e);
    }

    public static void error(String msg) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.error(msg);
    }

    public static void error(String msg, Exception e) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.error(msg, (Throwable)e);
    }

    public static void debug(String msg) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.debug(msg);
    }

    public static void debug(String msg, Exception e) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.debug(msg, (Throwable)e);
    }

    public static void warn(String msg) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.debug(msg);
    }

    public static void warn(String msg, Exception e) {
        if (!loggingEnabled) {
            return;
        }
        LOGGER.debug(msg, (Throwable)e);
    }
}

