/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv;

import in.gov.uidai.qssitv.model.BiometricError;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.LandMark;
import in.gov.uidai.qssitv.spi.IITVEngine;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Qssitv {
    private static final Logger LOGGER = LoggerFactory.getLogger(Qssitv.class);
    private static final Qssitv QSSITV = new Qssitv();
    private IQSSEngine faceQss;
    private IQSSEngine fingerQss;
    private IQSSEngine irisQss;
    private IITVEngine faceItv;
    private IITVEngine fingerItv;
    private IITVEngine irisItv;

    public static Qssitv getInst() {
        return QSSITV;
    }

    private Qssitv() {
    }

    public synchronized void register(IQSSEngine engine) {
        LOGGER.debug("registering " + engine.getClass().getName() + " as QSS engine");
        if (this.faceQss == null && engine.supportsFace()) {
            LOGGER.debug(engine.getClass().getName() + " supports face");
            this.faceQss = engine;
        }
        if (this.fingerQss == null && engine.supportsFinger()) {
            LOGGER.debug(engine.getClass().getName() + " supports finger");
            this.fingerQss = engine;
        }
        if (this.irisQss == null && engine.supportsIris()) {
            LOGGER.debug(engine.getClass().getName() + " supports iris");
            this.irisQss = engine;
        }
    }

    public synchronized void register(IITVEngine engine) {
        LOGGER.debug("registering " + engine.getClass().getName() + " as ITV engine");
        if (this.faceItv == null && engine.supportsFace()) {
            LOGGER.debug(engine.getClass().getName() + " supports face");
            this.faceItv = engine;
        }
        if (this.fingerItv == null && engine.supportsFinger()) {
            LOGGER.debug(engine.getClass().getName() + " supports finger");
            this.fingerItv = engine;
        }
        if (this.irisItv == null && engine.supportsIris()) {
            LOGGER.debug(engine.getClass().getName() + " supports iris");
            this.irisItv = engine;
        }
    }

    public FaceQSS getQSSDataForFace(byte[] input, List<LandMark> landmarks) {
        if (this.faceQss != null) {
            return this.faceQss.getQSSDataForFace(input, landmarks);
        }
        LOGGER.debug("no QSS support for face");
        return null;
    }

    public FingerprintQSS getQSSDataForFingerprint(byte[] input, List<BiometricPosition> missingFingers) {
        if (this.fingerQss != null) {
            return this.fingerQss.getQSSDataForFingerprint(input, missingFingers);
        }
        LOGGER.debug("no QSS support for finger");
        return null;
    }

    public List<IrisQSS> getQSSDataForIris(byte[] input) {
        if (this.irisQss != null) {
            return this.irisQss.getQSSDataForIris(input);
        }
        LOGGER.debug("no QSS support for iris");
        return null;
    }

    public byte[] convertISO(byte[] input, FormatType type) {
        byte[] result;
        if (this.fingerQss != null && (result = this.fingerQss.convertISO(input, type)) != null && result.length > 0) {
            return result;
        }
        if (this.irisQss != null && this.irisQss != this.fingerQss && (result = this.irisQss.convertISO(input, type)) != null && result.length > 0) {
            return result;
        }
        return null;
    }

    public List<BiometricTemplate> getFingerTemplate(byte[] input, List<BiometricPosition> missingfingers, int age, boolean iso) {
        if (this.fingerItv != null) {
            return this.fingerItv.getFingerTemplate(input, missingfingers, age, iso);
        }
        LOGGER.debug("no ITV support for finger");
        return null;
    }

    public List<BiometricTemplate> getFaceTemplate(byte[] input, boolean iso) {
        if (this.faceItv != null) {
            return this.faceItv.getFaceTemplate(input, iso);
        }
        LOGGER.debug("no ITV support for face");
        return null;
    }

    public List<BiometricTemplate> getIrisTemplate(byte[] input, boolean iso) {
        if (this.irisItv != null) {
            return this.irisItv.getIrisTemplate(input, iso);
        }
        LOGGER.debug("no ITV support for iris");
        return null;
    }

    public BiometricError insertFingerRecord(String encounterId, List<BiometricTemplate> fingerRecords) {
        if (this.fingerItv != null) {
            return this.fingerItv.insertFingerRecord(encounterId, fingerRecords);
        }
        LOGGER.debug("no ITV support for finger");
        return null;
    }

    public BiometricError insertIrisRecord(String encounterId, List<BiometricTemplate> irisRecords) {
        if (this.irisItv != null) {
            return this.irisItv.insertIrisRecord(encounterId, irisRecords);
        }
        LOGGER.debug("no ITV support for iris");
        return null;
    }

    public BiometricError insertFaceRecord(String encounterId, List<BiometricTemplate> faceRecords) {
        if (this.faceItv != null) {
            return this.faceItv.insertFaceRecord(encounterId, faceRecords);
        }
        LOGGER.debug("no ITV support for face");
        return null;
    }

    public Map<String, Double> identifyIris(List<BiometricTemplate> irisRecords, double threshold) {
        if (this.irisItv != null) {
            return this.irisItv.identifyIris(irisRecords, threshold);
        }
        LOGGER.debug("no ITV support for iris");
        return null;
    }

    public Map<String, Double> identifyFace(List<BiometricTemplate> faceRecords, double threshold) {
        if (this.faceItv != null) {
            return this.faceItv.identifyFace(faceRecords, threshold);
        }
        LOGGER.debug("no ITV support for face");
        return null;
    }

    public Map<String, Double> identifyFinger(List<BiometricTemplate> fingerRecords, int age, double threshold) {
        if (this.fingerItv != null) {
            return this.fingerItv.identifyFinger(fingerRecords, age, threshold);
        }
        LOGGER.debug("no ITV support for finger");
        return null;
    }

    public Double verifyFinger(List<BiometricTemplate> probeFingerRecord, List<BiometricTemplate> galleryFingerRecord) {
        if (this.fingerItv != null) {
            return this.fingerItv.verifyFinger(probeFingerRecord, galleryFingerRecord);
        }
        LOGGER.debug("no ITV support for finger");
        return 0.0;
    }

    public Double verifyIris(List<BiometricTemplate> probeIrisRecord, List<BiometricTemplate> galleryIrisRecord) {
        if (this.irisItv != null) {
            return this.irisItv.verifyIris(probeIrisRecord, galleryIrisRecord);
        }
        LOGGER.debug("no ITV support for iris");
        return 0.0;
    }

    public Double verifyFace(List<BiometricTemplate> probeFaceRecord, List<BiometricTemplate> galleryFaceRecord) {
        if (this.faceItv != null) {
            return this.faceItv.verifyFace(probeFaceRecord, galleryFaceRecord);
        }
        LOGGER.debug("no ITV support for face");
        return 0.0;
    }

    public void clearRecords() {
        if (this.faceItv != null) {
            this.faceItv.clearRecords();
        }
        if (this.fingerItv != null && !this.fingerItv.equals(this.faceItv)) {
            this.fingerItv.clearRecords();
        }
        if (this.irisItv != null && !this.irisItv.equals(this.faceItv) && !this.irisItv.equals(this.fingerItv)) {
            this.irisItv.clearRecords();
        }
    }
}

