/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.qssitv.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public enum BiometricPosition {
    FACE,
    LEFT_IRIS,
    RIGHT_IRIS,
    BOTH_IRIS,
    LEFT_THUMB,
    LEFT_INDEX,
    LEFT_MIDDLE,
    LEFT_RING,
    LEFT_LITTLE,
    RIGHT_THUMB,
    RIGHT_INDEX,
    RIGHT_MIDDLE,
    RIGHT_RING,
    RIGHT_LITTLE,
    UNKNOWN,
    ANY_FINGER,
    BOTH_THUMBS,
    RIGHT_SLAP,
    LEFT_SLAP,
    PLACE_ANY_FINGER,
    CAPTURE_ANY_IRIS;

    private static final String pattern = "[A-Z]{1}[a-z]+";
    private static final Pattern stringPattern;

    public String toString() {
        String result = WordUtils.capitalizeFully((String)this.name(), (char[])new char[]{'_'});
        return StringUtils.remove((String)result, (char)'_');
    }

    public static String getBiometricsPositionString(String biometricPosition) {
        String bioPosString = "Unknown";
        if (StringUtils.isNotBlank((String)biometricPosition)) {
            Matcher stringMatcher = stringPattern.matcher(biometricPosition);
            int i = 0;
            while (stringMatcher.find()) {
                if (++i == 1) {
                    bioPosString = stringMatcher.group().toUpperCase();
                    continue;
                }
                if (i < 2) continue;
                bioPosString = bioPosString + "_" + stringMatcher.group().toUpperCase();
            }
        }
        return bioPosString;
    }

    static {
        stringPattern = Pattern.compile(pattern);
    }
}

