/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.FileNameMap;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.swing.JFileChooser;

public class UtilIO {
    public static URL pathExampleURL(String path) {
        try {
            File pathExample;
            File fpath = new File(path);
            if (fpath.isAbsolute()) {
                return fpath.toURI().toURL();
            }
            String pathToBase = UtilIO.getPathToBase();
            if (pathToBase != null && (pathExample = new File(pathToBase, "data/example/")).exists()) {
                return new File(pathExample.getPath(), path).getAbsoluteFile().toURL();
            }
            URL url = UtilIO.class.getClassLoader().getResource(path);
            if (url == null) {
                System.err.println();
                System.err.println("Can't find data/example directory!  There are three likely causes for this problem.");
                System.err.println();
                System.err.println("1) You checked out the source code from git and did not pull the data submodule too.");
                System.err.println("2) You are trying to run an example from outside the BoofCV directory tree.");
                System.err.println("3) You are trying to pass in your own image.");
                System.err.println();
                System.err.println("Solutions:");
                System.err.println("1) Follow instructions in the boofcv/readme.md file to grab the data directory.");
                System.err.println("2) Launch the example from inside BoofCV's directory tree!");
                System.err.println("3) Don't use this function and just pass in the path directly");
                System.exit(1);
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedReader openBufferedReader(String fileName) throws FileNotFoundException {
        InputStream stream = UtilIO.openStream(fileName);
        if (stream == null) {
            throw new FileNotFoundException("Can't open " + fileName);
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static URL ensureURL(String path) {
        URL url;
        path = UtilIO.systemToUnix(path);
        try {
            url = new URL(path);
            if (url.getProtocol().equals("jar")) {
                return UtilIO.simplifyJarPath(url);
            }
        }
        catch (MalformedURLException e) {
            try {
                url = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
        return url;
    }

    public static URL simplifyJarPath(URL url) {
        try {
            String[] segments = url.toString().split(".jar!/");
            String path = UtilIO.simplifyJarPath(segments[1]);
            return new URL(segments[0] + ".jar!/" + path);
        }
        catch (IOException e) {
            return url;
        }
    }

    public static String systemToUnix(String path) {
        if (path == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return path.replace('\\', '/');
        }
        return path;
    }

    public static String simplifyJarPath(String path) {
        ArrayList<String> elements = new ArrayList<String>();
        File f = new File(path);
        boolean skip = false;
        do {
            if (!skip) {
                if (f.getName().equals("..")) {
                    skip = true;
                    continue;
                }
                elements.add(f.getName());
                continue;
            }
            skip = false;
        } while ((f = f.getParentFile()) != null);
        path = "";
        for (int i = elements.size() - 1; i >= 0; --i) {
            path = path + (String)elements.get(i);
            if (i <= 0) continue;
            path = path + '/';
        }
        return path;
    }

    public static InputStream openStream(String path) {
        try {
            URL url = UtilIO.ensureURL(path);
            if (url != null) {
                return url.openStream();
            }
            System.err.println("Unable to open " + path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String pathExample(String path) {
        File pathExample;
        File fpath = new File(path);
        if (fpath.isAbsolute()) {
            return path;
        }
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase != null && (pathExample = new File(pathToBase, "data/example/")).exists()) {
            return new File(pathExample.getPath(), path).getAbsolutePath();
        }
        return UtilIO.pathExampleURL(path).toString();
    }

    public static String path(String path) {
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase == null) {
            return path;
        }
        return new File(pathToBase, path).getAbsolutePath();
    }

    public static File getFileToBase() {
        return new File(UtilIO.getPathToBase());
    }

    public static String getPathToBase() {
        String[] files;
        File f;
        String path = new File(".").getAbsoluteFile().getParent();
        while (path != null && (f = new File(path)).exists() && (files = f.list()) != null) {
            boolean foundMain = false;
            boolean foundExamples = false;
            boolean foundIntegration = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("examples") == 0) {
                    foundExamples = true;
                    continue;
                }
                if (s.compareToIgnoreCase("integration") != 0) continue;
                foundIntegration = true;
            }
            if (foundMain && foundExamples && foundIntegration) {
                return path;
            }
            path = f.getParent();
        }
        return null;
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            String libraryPath = System.getProperty("java.library.path");
            libraryPath = libraryPath + ":" + s;
            System.setProperty("java.library.path", libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static void save(Object o, String fileName) {
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(o);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T load(String fileName) {
        try {
            FileInputStream fileIn = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            in.close();
            fileIn.close();
            return (T)obj;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                UtilIO.deleteRecursive(c);
            }
        }
        if (!f.delete()) {
            throw new RuntimeException("Failed to delete file: " + f);
        }
    }

    public static String readAsString(String path) {
        InputStream stream = UtilIO.openStream(path);
        if (stream == null) {
            System.err.println("Failed to open " + path);
            return null;
        }
        return UtilIO.readAsString(stream);
    }

    public static String readAsString(InputStream stream) {
        StringBuilder code = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                code.append(line).append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        String output = code.toString();
        String nl = System.getProperty("line.separator");
        if (nl.compareTo("\n") != 0) {
            output = output.replaceAll(nl, "\n");
        }
        return output;
    }

    public static String getSourcePath(String pkg, String app) {
        String path = "";
        if (pkg == null || app == null) {
            return path;
        }
        String pathToBase = UtilIO.getPathToBase();
        if (pathToBase != null) {
            if (pkg.contains("examples")) {
                path = new File(pathToBase, "examples/src/main/java/").getAbsolutePath();
            } else if (pkg.contains("demonstrations")) {
                path = new File(pathToBase, "demonstrations/src/main/java/").getAbsolutePath();
            } else {
                System.err.println("pkg must be to examples or demonstrations. " + pkg);
                return path;
            }
            String pathToCode = pkg.replace('.', '/') + "/" + app + ".java";
            return new File(path, pathToCode).getPath();
        }
        String pathToCode = pkg.replace('.', '/') + "/" + app + ".java";
        URL url = UtilIO.class.getClassLoader().getResource(pathToCode);
        if (url != null) {
            return url.toString();
        }
        return pathToCode;
    }

    public static String getGithubURL(String pkg, String app) {
        String dir;
        if (pkg == null || app == null) {
            return "";
        }
        String base = "0.33.1".contains("SNAPSHOT") ? "https://github.com/lessthanoptimal/BoofCV/blob/2ee5e27132eda564510b281b15413091d64fad90/" : "https://github.com/lessthanoptimal/BoofCV/blob/v0.33.1/";
        if ((pkg = pkg.replace('.', '/') + "/").contains("demonstrations")) {
            dir = "demonstrations/";
        } else if (pkg.contains("examples")) {
            dir = "examples/";
        } else {
            return "";
        }
        return base + dir + "src/main/java/" + pkg + app + ".java";
    }

    public static int indexOfSourceStart(String code) {
        int state = 0;
        int indexLineStart = 0;
        int previous = 0;
        boolean justEntered = false;
        StringBuilder buffer = new StringBuilder(1024);
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            if (state == 1) {
                if (justEntered) {
                    justEntered = false;
                    if (c == '*') {
                        return indexLineStart;
                    }
                }
                if (previous == 42 && c == '/') {
                    state = 0;
                }
            } else if (state == 0) {
                if (previous == 47 && c == '/') {
                    state = 2;
                } else if (previous == 47 && c == '*') {
                    state = 1;
                    justEntered = true;
                } else {
                    buffer.append(c);
                }
            }
            if (c == '\n') {
                if (buffer.toString().contains("class")) {
                    return indexLineStart;
                }
                buffer.delete(0, buffer.length());
                indexLineStart = i + 1;
                if (state == 2) {
                    state = 0;
                }
            }
            previous = c;
        }
        if (buffer.toString().contains("class")) {
            return indexLineStart;
        }
        return 0;
    }

    public static List<String> listByPrefix(String directory, String prefix, String suffix) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            try {
                URL url = new URL(directory);
                if (url.getProtocol().equals("file")) {
                    d = new File(url.getFile());
                } else if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarPrefix(url, prefix, suffix);
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory. " + directory);
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || prefix != null && !f.getName().startsWith(prefix) || suffix != null && !f.getName().endsWith(suffix)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listByRegex(String directory, String regex) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        File d = new File(directory);
        if (!d.isDirectory()) {
            try {
                URL url = new URL(directory);
                if (url.getProtocol().equals("file")) {
                    d = new File(url.getFile());
                } else if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarRegex(url, regex);
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory. " + directory);
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().matches(regex)) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listAll(String directory) {
        File[] files;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            URL url = new URL(directory);
            if (!url.getProtocol().equals("file")) {
                if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarPrefix(url, null, null);
                }
                throw new RuntimeException("Not sure what to do with this url. " + url.toString());
            }
            directory = url.getFile();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        for (File f : files = d.listFiles()) {
            if (f.isDirectory() || f.isHidden()) continue;
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static List<String> listAllMime(String directory, String type) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            URL url = new URL(directory);
            if (!url.getProtocol().equals("file")) {
                if (url.getProtocol().equals("jar")) {
                    return UtilIO.listJarMime(url, null, null);
                }
                throw new RuntimeException("Not sure what to do with this url. " + url.toString());
            }
            directory = url.getFile();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File d = new File(directory);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Must specify an directory");
        }
        File[] files = d.listFiles();
        if (files == null) {
            return ret;
        }
        for (File f : files) {
            if (f.isDirectory()) continue;
            try {
                String mimeType = Files.probeContentType(f.toPath());
                if (!mimeType.contains(type)) continue;
                ret.add(f.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collections.sort(ret);
        return ret;
    }

    private static List<String> listJarPrefix(URL url, String prefix, String suffix) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            if (prefix != null) {
                targetPath = targetPath + prefix;
            }
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || suffix != null && !ze.getName().endsWith(suffix)) continue;
                output.add("jar:file:" + jarfile.getName() + "!/" + ze.getName());
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private static List<String> listJarMime(URL url, String prefix, String type) {
        ArrayList<String> output = new ArrayList<String>();
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            if (prefix != null) {
                targetPath = targetPath + prefix;
            }
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                String path;
                String mimeType;
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || !(mimeType = fileNameMap.getContentTypeFor(path = "jar:file:" + jarfile.getName() + "!/" + ze.getName())).contains(type)) continue;
                output.add(path);
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    private static List<String> listJarRegex(URL url, String regex) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarfile = connection.getJarFile();
            String targetPath = connection.getEntryName() + "/";
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                String shortName;
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(targetPath) || ze.getName().length() == targetPath.length() || !(shortName = ze.getName().substring(targetPath.length())).matches(regex)) continue;
                output.add("jar:file:" + jarfile.getName() + "!/" + ze.getName());
            }
            jarfile.close();
            return output;
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }

    public static File[] findMatches(File directory, String regex) {
        Pattern p = Pattern.compile(regex);
        return directory.listFiles(file -> p.matcher(file.getName()).matches());
    }

    public static boolean validURL(URL url) {
        try {
            URLConnection c = url.openConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void copyToFile(InputStream in, File file) {
        try {
            if (in == null) {
                throw new RuntimeException("Input is null");
            }
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[0x100000];
            while (in.available() > 0) {
                int amount = in.read(buffer, 0, buffer.length);
                out.write(buffer, 0, amount);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

