/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.geo;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSnavely;
import boofcv.io.UtilIO;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.ejml.data.DMatrixRMaj;

public class CodecBundleAdjustmentInTheLarge {
    public SceneStructureMetric scene;
    public SceneObservations observations;

    public void parse(File file) throws IOException {
        int i;
        InputStream stream = UtilIO.openStream(file.getPath());
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String[] words = reader.readLine().split("\\s+");
        if (words.length != 3) {
            throw new IOException("Unexpected number of words on first line");
        }
        int numCameras = Integer.parseInt(words[0]);
        int numPoints = Integer.parseInt(words[1]);
        int numObservations = Integer.parseInt(words[2]);
        this.scene = new SceneStructureMetric(false);
        this.scene.initialize(numCameras, numCameras, numPoints);
        this.observations = new SceneObservations(numCameras);
        for (int i2 = 0; i2 < numObservations; ++i2) {
            words = reader.readLine().split("\\s+");
            if (words.length != 4) {
                throw new IOException("Unexpected number of words in obs");
            }
            int cameraID = Integer.parseInt(words[0]);
            int pointID = Integer.parseInt(words[1]);
            float pixelX = Float.parseFloat(words[2]);
            float pixelY = Float.parseFloat(words[3]);
            if (pointID >= numPoints) {
                throw new RuntimeException("Out of bounds pointID");
            }
            if (cameraID >= numCameras) {
                throw new RuntimeException("Out of bounds cameraID");
            }
            this.observations.getView(cameraID).add(pointID, pixelX, pixelY);
        }
        Se3_F64 worldToCameraGL = new Se3_F64();
        Rodrigues_F64 rod = new Rodrigues_F64();
        for (int i3 = 0; i3 < numCameras; ++i3) {
            rod.unitAxisRotation.x = Double.parseDouble(reader.readLine());
            rod.unitAxisRotation.y = Double.parseDouble(reader.readLine());
            rod.unitAxisRotation.z = Double.parseDouble(reader.readLine());
            rod.theta = rod.unitAxisRotation.norm();
            if (rod.theta != 0.0) {
                rod.unitAxisRotation.divide(rod.theta);
            }
            worldToCameraGL.T.x = Double.parseDouble(reader.readLine());
            worldToCameraGL.T.y = Double.parseDouble(reader.readLine());
            worldToCameraGL.T.z = Double.parseDouble(reader.readLine());
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)rod, (DMatrixRMaj)worldToCameraGL.R);
            BundlePinholeSnavely camera = new BundlePinholeSnavely();
            camera.f = Double.parseDouble(reader.readLine());
            camera.k1 = Double.parseDouble(reader.readLine());
            camera.k2 = Double.parseDouble(reader.readLine());
            this.scene.setCamera(i3, false, (BundleAdjustmentCamera)camera);
            this.scene.setView(i3, false, worldToCameraGL);
            this.scene.connectViewToCamera(i3, i3);
        }
        Point3D_F64 P = new Point3D_F64();
        for (i = 0; i < numPoints; ++i) {
            P.x = Float.parseFloat(reader.readLine());
            P.y = Float.parseFloat(reader.readLine());
            P.z = Float.parseFloat(reader.readLine());
            this.scene.setPoint(i, P.x, P.y, P.z);
        }
        for (i = 0; i < this.observations.views.length; ++i) {
            SceneObservations.View v = this.observations.getView(i);
            for (int j = 0; j < v.point.size; ++j) {
                this.scene.connectPointToView(v.getPointId(j), i);
            }
        }
        reader.close();
        this.observations.checkOneObservationPerView();
    }

    public void save(File file) throws IOException {
        PrintStream writer = new PrintStream(file);
        writer.println(this.scene.views.length + " " + this.scene.points.length + " " + this.observations.getObservationCount());
        PointIndex2D_F64 o = new PointIndex2D_F64();
        for (int viewIdx = 0; viewIdx < this.observations.views.length; ++viewIdx) {
            SceneObservations.View view = this.observations.views[viewIdx];
            for (int obsIdx = 0; obsIdx < view.size(); ++obsIdx) {
                view.get(obsIdx, o);
                writer.printf("%d %d %.8f %.8f\n", viewIdx, o.index, o.x, o.y);
            }
        }
        Rodrigues_F64 axisAngle = new Rodrigues_F64();
        for (int viewIdx = 0; viewIdx < this.scene.views.length; ++viewIdx) {
            SceneStructureMetric.View view = this.scene.views[viewIdx];
            BundlePinholeSnavely camera = (BundlePinholeSnavely)this.scene.cameras[view.camera].getModel();
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)view.worldToView.R, (Rodrigues_F64)axisAngle);
            double axisX = axisAngle.unitAxisRotation.x * axisAngle.theta;
            double axisY = axisAngle.unitAxisRotation.y * axisAngle.theta;
            double axisZ = axisAngle.unitAxisRotation.z * axisAngle.theta;
            writer.printf("%.10f\n%.10f\n%.10f\n", axisX, axisY, axisZ);
            writer.printf("%.10f\n%.10f\n%.10f\n", view.worldToView.T.x, view.worldToView.T.y, view.worldToView.T.z);
            writer.printf("%.10f\n%.10f\n%.10f\n", camera.f, camera.k1, camera.k2);
        }
        for (int pointId = 0; pointId < this.scene.points.length; ++pointId) {
            SceneStructureCommon.Point p = this.scene.points[pointId];
            writer.printf("%.10f\n%.10f\n%.10f\n", p.coordinate[0], p.coordinate[1], p.coordinate[2]);
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        CodecBundleAdjustmentInTheLarge alg = new CodecBundleAdjustmentInTheLarge();
        alg.parse(new File("data/bundle_adjustment/ladybug/problem-49-7776-pre.txt"));
        System.out.println("Done!");
    }
}

