/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.BoofMjpegVideo;
import boofcv.io.video.VideoInterface;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.ImageStreamSequence;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class DynamicVideoInterface
implements VideoInterface {
    VideoInterface jcodec;
    VideoInterface ffmpeg;
    BoofMjpegVideo mjpeg = new BoofMjpegVideo();

    public DynamicVideoInterface() {
        try {
            this.ffmpeg = DynamicVideoInterface.loadManager("boofcv.io.ffmpeg.FfmpegVideo");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.jcodec = DynamicVideoInterface.loadManager("boofcv.io.jcodec.JCodecVideoInterface");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImageBase<T>> SimpleImageSequence<T> load(String fileName, ImageType<T> imageType) {
        URL url = UtilIO.ensureURL(fileName);
        if (url == null) {
            throw new RuntimeException("Can't open " + fileName);
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
            if (fileName.endsWith("mjpeg") || fileName.endsWith("MJPEG") || fileName.endsWith("mjpg") || fileName.endsWith("MJPG")) {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List<byte[]> data = codec.read(stream);
                JpegByteImageSequence<T> jpegByteImageSequence = new JpegByteImageSequence<T>(imageType, data, false);
                return jpegByteImageSequence;
            }
            if (fileName.endsWith("mpng") || fileName.endsWith("MPNG")) {
                ImageStreamSequence<T> codec = new ImageStreamSequence<T>(stream, true, imageType);
                return codec;
            }
            if (this.ffmpeg != null) {
                SimpleImageSequence<T> codec = this.ffmpeg.load(fileName, imageType);
                return codec;
            }
            try {
                if (this.jcodec != null && (fileName.endsWith(".mp4") || fileName.endsWith(".MP4"))) {
                    SimpleImageSequence<T> e = this.jcodec.load(fileName, imageType);
                    return e;
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            System.err.println("No working codec found for file: " + fileName);
        }
        catch (IOException e) {
            System.err.println("Error opening. " + e.getMessage());
            SimpleImageSequence<T> simpleImageSequence = null;
            return simpleImageSequence;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close stream. " + e.getMessage());
                }
            }
        }
        return null;
    }

    public static VideoInterface loadManager(String pathToManager) {
        try {
            Class<?> c = Class.forName(pathToManager);
            return (VideoInterface)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found.  Is it included in the class path?");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

