/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;

public class Blob
extends Core {
    private native long fbsCreateBlob();

    private native boolean fbsDestroyBlob(long var1);

    private native boolean fbsBlobWriteToFile(long var1, String var3);

    private native boolean fbsBlobCalculateChecksum(long var1, Long var3);

    private native String fbsBlobGetCStr(long var1);

    private native boolean fbsBlobGetDataPointer(long var1, Long var3, Integer var4);

    private native byte[] fbsBlobGetData(long var1);

    private native boolean fbsBlobLoadFromFile(long var1, String var3);

    private native boolean fbsBlobLoadFromMemory(long var1, long var3, int var5);

    private native boolean fbsBlobLoadFromMemoryArray(long var1, byte[] var3);

    public Blob() {
        this.internalHandle = this.fbsCreateBlob();
    }

    protected Blob(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyBlob(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void writeToFile(String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsBlobWriteToFile(this.internalHandle, filename)) {
            this.checkError(this.internalHandle);
        }
    }

    public long calculateChecksum() throws CustomException {
        Long checksum = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsBlobCalculateChecksum(this.internalHandle, checksum)) {
            this.checkError(this.internalHandle);
        }
        return checksum;
    }

    protected long getDataPointer() throws CustomException {
        Long data = new Long(0L);
        Integer dataSize = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsBlobGetDataPointer(this.internalHandle, data, dataSize)) {
            this.checkError(this.internalHandle);
        }
        return data;
    }

    public byte[] getData() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        return this.fbsBlobGetData(this.internalHandle);
    }

    public void readFromFile(String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsBlobLoadFromFile(this.internalHandle, filename)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setData(byte[] data) throws CustomException {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsBlobLoadFromMemoryArray(this.internalHandle, data)) {
            this.checkError(this.internalHandle);
        }
    }
}

