/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Point;
import com.l1id.sdk.foundation.Types;

public class FingerprintPosition
extends Core {
    private native long fbsCreateFingerprintPosition();

    private native boolean fbsDestroyFingerprintPosition(long var1);

    private native boolean fbsFingerprintPositionSetPosition(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native boolean fbsFingerprintPositionGetPosition(long var1, Integer var3, Integer var4, Integer var5, Integer var6, Integer var7, Integer var8, Integer var9, Integer var10, Integer var11);

    public FingerprintPosition() {
        this.internalHandle = this.fbsCreateFingerprintPosition();
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyFingerprintPosition(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void setPosition(Point leftTop, Point leftBottom, Point rightTop, Point rightBottom, Types.Instance instance) throws CustomException {
        if (leftTop == null || leftBottom == null || rightBottom == null || rightTop == null) {
            throw new IllegalArgumentException("At least one point is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Instance is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsFingerprintPositionSetPosition(this.internalHandle, leftTop.getX(), leftTop.getY(), leftBottom.getX(), leftBottom.getY(), rightTop.getX(), rightTop.getY(), rightBottom.getX(), rightBottom.getY(), instance.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Point getLeftTop() throws CustomException {
        Point point = new Point();
        if (!this.fbsFingerprintPositionGetPosition(this.internalHandle, point.getX(), point.getY(), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0))) {
            this.checkError(this.internalHandle);
        }
        return point;
    }

    public Point getLeftBottom() throws CustomException {
        Point point = new Point();
        if (!this.fbsFingerprintPositionGetPosition(this.internalHandle, new Integer(0), new Integer(0), point.getX(), point.getY(), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0))) {
            this.checkError(this.internalHandle);
        }
        return point;
    }

    public Point getRightTop() throws CustomException {
        Point point = new Point();
        if (!this.fbsFingerprintPositionGetPosition(this.internalHandle, new Integer(0), new Integer(0), new Integer(0), new Integer(0), point.getX(), point.getY(), new Integer(0), new Integer(0), new Integer(0))) {
            this.checkError(this.internalHandle);
        }
        return point;
    }

    public Point getRightBottom() throws CustomException {
        Point point = new Point();
        if (!this.fbsFingerprintPositionGetPosition(this.internalHandle, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), point.getX(), point.getY(), new Integer(0))) {
            this.checkError(this.internalHandle);
        }
        return point;
    }

    public Types.Instance getInstance() throws CustomException {
        Integer instanceVal = new Integer(0);
        if (!this.fbsFingerprintPositionGetPosition(this.internalHandle, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), instanceVal)) {
            this.checkError(this.internalHandle);
        }
        Types.Instance instance = Types.Instance.valueOf(instanceVal);
        return instance;
    }
}

