/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.FingerprintPosition;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.Types;

public class FingerprintSegmentor
extends Core {
    private native long fbsCreateFingerprintSegmentor();

    private native boolean fbsDestroyFingerprintSegmentor(long var1);

    private native boolean fbsFingerprintSegmentorInit(long var1);

    private native boolean fbsFingerprintSegmentorCheckQuality(long var1, long var3, long var5);

    private native boolean fbsFingerprintSegmentorSegment(long var1, long var3, long var5, Integer var7, long[] var8, long[] var9, int var10, Integer var11, Integer var12, int[] var13, int var14, int[] var15);

    public FingerprintSegmentor() throws CustomException {
        this.internalHandle = this.fbsCreateFingerprintSegmentor();
        this.initialize();
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyFingerprintSegmentor(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    private void initialize() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsFingerprintSegmentorInit(this.internalHandle)) {
            this.checkError(this.internalHandle);
        }
    }

    public void checkQuality(Image fingerImage, ImageDescriptor imageDescriptor) throws CustomException {
        if (fingerImage == null) {
            throw new IllegalArgumentException("fingerImage is null");
        }
        if (imageDescriptor == null) {
            throw new IllegalArgumentException("fingerImage is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsFingerprintSegmentorCheckQuality(this.internalHandle, fingerImage.getHandle(), imageDescriptor.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public FingerprintSegmentOutput segment(Image slapImageA, ImageDescriptor slapDescriptorA, int outputDPIA, Types.Instance[] missingPositionsA) throws CustomException {
        int i;
        int numFingersL = 0;
        if (slapImageA == null) {
            throw new IllegalArgumentException("slapImage is null");
        }
        if (slapDescriptorA == null) {
            throw new IllegalArgumentException("slapDescriptor is null");
        }
        switch (slapDescriptorA.getInstance()) {
            case FingerPlainRightSlap: {
                numFingersL = 4;
                break;
            }
            case FingerPlainLeftSlap: {
                numFingersL = 4;
                break;
            }
            case FingerPlainThumbs: {
                numFingersL = 2;
                break;
            }
            default: {
                throw new CustomException("Descriptor Instance not allowed for segment(): " + (Object)((Object)slapDescriptorA.getInstance()));
            }
        }
        FingerprintSegmentOutput fingerprintSegmentorOutputL = new FingerprintSegmentOutput(numFingersL);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        long[] positions = new long[numFingersL];
        long[] segmentedImages = new long[numFingersL];
        int[] missingPositions = new int[numFingersL];
        int nMissingFingersA = 0;
        if (missingPositionsA != null) {
            nMissingFingersA = missingPositionsA.length;
            for (i = 0; i < missingPositionsA.length; ++i) {
                missingPositions[i] = missingPositionsA[i].getNumericValue();
            }
        }
        for (i = 0; i < numFingersL; ++i) {
            ((FingerprintSegmentOutput)fingerprintSegmentorOutputL).segImages[i] = new Image();
            segmentedImages[i] = fingerprintSegmentorOutputL.segImages[i].getHandle();
            ((FingerprintSegmentOutput)fingerprintSegmentorOutputL).fingerpPositions[i] = new FingerprintPosition();
            positions[i] = fingerprintSegmentorOutputL.fingerpPositions[i].getHandle();
        }
        if (!this.fbsFingerprintSegmentorSegment(this.internalHandle, slapImageA.getHandle(), slapDescriptorA.getHandle(), fingerprintSegmentorOutputL.numFinger, positions, segmentedImages, outputDPIA, fingerprintSegmentorOutputL.confidence, fingerprintSegmentorOutputL.handedness, fingerprintSegmentorOutputL.fingerQualityArray, nMissingFingersA, missingPositions)) {
            this.checkError(this.internalHandle);
        }
        return fingerprintSegmentorOutputL;
    }

    public class FingerprintSegmentOutput {
        private Integer numFinger = null;
        private Integer confidence = null;
        private Integer handedness = null;
        private Image[] segImages = null;
        private FingerprintPosition[] fingerpPositions = null;
        private int[] fingerQualityArray = null;

        public FingerprintSegmentOutput(int numFinger) {
            this.numFinger = new Integer(numFinger);
            this.confidence = new Integer(0);
            this.handedness = new Integer(0);
            this.segImages = new Image[numFinger];
            this.fingerpPositions = new FingerprintPosition[numFinger];
            this.fingerQualityArray = new int[numFinger];
        }

        public int getNumFinger() {
            return this.numFinger;
        }

        public int getConfidence() {
            return this.confidence;
        }

        public int getHandedness() {
            return this.handedness;
        }

        public Image[] getSlapImages() {
            return this.segImages;
        }

        public FingerprintPosition[] getFingerprintPositions() {
            return this.fingerpPositions;
        }

        public int[] getFingerQuality() {
            return this.fingerQualityArray;
        }
    }
}

