/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Types;

public class IdRecord
extends Core {
    private native long fbsCreateIdRecord();

    private native boolean fbsDestroyIdRecord(long var1);

    private native boolean fbsIdRecordSerializeIn(long var1, long var3);

    private native boolean fbsIdRecordReadFromFile(long var1, String var3);

    private native boolean fbsIdRecordWriteToFile(long var1, String var3);

    private native boolean fbsIdRecordSerializeOut(long var1, Long var3);

    private native boolean fbsIdRecordExistBioRecord(long var1, int var3, int var4, Boolean var5);

    private native boolean fbsIdRecordSetPersonId(long var1, long var3);

    private native boolean fbsIdRecordSetTransactionId(long var1, long var3);

    private native boolean fbsIdRecordGetNumberOfSamples(long var1, int var3, int var4, Integer var5);

    private native boolean fbsIdRecordGetSampleIdByIndex(long var1, int var3, int var4, int var5, Long var6);

    private native boolean fbsIdRecordDeleteSample(long var1, int var3, int var4, long var5);

    private native boolean fbsIdRecordAddSerializedSample(long var1, int var3, int var4, long var5, long var7);

    private native boolean fbsIdRecordGetSerializedSample(long var1, int var3, int var4, long var5, Long var7);

    private native boolean fbsIdRecordExistAlgorithmOfSampleId(long var1, int var3, int var4, long var5, int var7, Boolean var8);

    private native boolean fbsIdRecordAddSerializedTemplateBlock(long var1, int var3, int var4, long var5, int var7, long var8);

    private native boolean fbsIdRecordGetSerializedTemplateBlock(long var1, int var3, int var4, long var5, int var7, Long var8);

    private native boolean fbsIdRecordSetSID(long var1, byte[] var3);

    private native boolean fbsIdRecordGetChecksum(long var1, Integer var3);

    private native boolean fbsIdRecordValidate(long var1, Boolean var3);

    private native boolean fbsIdRecordToXml(long var1, Long var3);

    private native boolean fbsIdRecordGetPersonId(long var1, Long var3);

    private native boolean fbsIdRecordGetTransactionId(long var1, Long var3);

    private native boolean fbsIdRecordGetSampleQuality(long var1, int var3, int var4, long var5, Float var7);

    private native boolean fbsIdRecordConvertToGalleryAndProbe(long var1);

    private native boolean fbsIdRecordIsTemplateCreationType(long var1, int var3, int var4, long var5, int var7, Boolean var8);

    private native boolean fbsIdRecordAddRawTemplateBlock(long var1, int var3, int var4, long var5, int var7, int var8, long var9);

    private native boolean fbsIdRecordGetRawTemplateBlock(long var1, int var3, int var4, long var5, int var7, int var8, long var9);

    private native byte[] fbsIdRecordGetSID(long var1);

    public IdRecord() {
        this.internalHandle = this.fbsCreateIdRecord();
    }

    protected IdRecord(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyIdRecord(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void serializeIn(Blob blob) throws CustomException {
        if (blob == null) {
            throw new IllegalArgumentException("blob is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordSerializeIn(this.internalHandle, blob.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public void readFromFile(String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordReadFromFile(this.internalHandle, filename)) {
            this.checkError(this.internalHandle);
        }
    }

    public void writeToFile(String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordWriteToFile(this.internalHandle, filename)) {
            this.checkError(this.internalHandle);
        }
    }

    public Blob serializeOut() throws CustomException {
        Long blobHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordSerializeOut(this.internalHandle, blobHande)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHande);
        return blob;
    }

    public boolean existBioRecord(Types.Modality modality, Types.Instance instance) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Boolean outExist = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordExistBioRecord(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), outExist)) {
            this.checkError(this.internalHandle);
        }
        return outExist;
    }

    public void setPersonId(long personId) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordSetPersonId(this.internalHandle, personId)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setTransactionId(long transactionId) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordSetTransactionId(this.internalHandle, transactionId)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getNumberOfSamples(Types.Modality modality, Types.Instance instance) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Integer outNumberOfSamples = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetNumberOfSamples(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), outNumberOfSamples)) {
            this.checkError(this.internalHandle);
        }
        return outNumberOfSamples;
    }

    public long getSampleIdByIndex(Types.Modality modality, Types.Instance instance, int index) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Long sampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetSampleIdByIndex(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), index, sampleId)) {
            this.checkError(this.internalHandle);
        }
        return sampleId;
    }

    public void deleteSample(Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordDeleteSample(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId)) {
            this.checkError(this.internalHandle);
        }
    }

    public void addSerializedSample(Types.Modality modality, Types.Instance instance, long sampleId, Blob blob) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (blob == null) {
            throw new IllegalArgumentException("blob is null.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordAddSerializedSample(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, blob.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public Blob getSerializedSample(Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Long blobHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetSerializedSample(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, blobHande)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHande);
        return blob;
    }

    public void addRawTemplateBlob(Types.Modality mod, Types.Instance inst, long sampleId, Types.Algorithm algo, Types.TemplateCreationType type, Blob blob) throws CustomException {
        if (mod == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (inst == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (algo == null) {
            throw new IllegalArgumentException("algorithm is null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null.");
        }
        if (blob == null) {
            throw new IllegalArgumentException("blob is null.");
        }
        int modInt = mod.getNumericValue();
        int instInt = inst.getNumericValue();
        int algoInt = algo.getNumericValue();
        int typeInt = type.getNumericValue();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordAddRawTemplateBlock(this.internalHandle, modInt, instInt, sampleId, algoInt, typeInt, blob.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public Blob getRawTemplateBlob(Types.Modality mod, Types.Instance inst, long sampleId, Types.Algorithm algo, Types.TemplateCreationType type) throws CustomException {
        if (mod == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (inst == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (algo == null) {
            throw new IllegalArgumentException("algorithm is null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null.");
        }
        int modInt = mod.getNumericValue();
        int instInt = inst.getNumericValue();
        int algoInt = algo.getNumericValue();
        int typeInt = type.getNumericValue();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Blob blob = new Blob();
        if (!this.fbsIdRecordGetRawTemplateBlock(this.internalHandle, modInt, instInt, sampleId, algoInt, typeInt, blob.getHandle())) {
            this.checkError(this.internalHandle);
        }
        return blob;
    }

    public boolean existAlgorithmOfSampleId(Types.Modality modality, Types.Instance instance, long sampleId, Types.Algorithm algorithm) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null.");
        }
        Boolean outExist = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordExistAlgorithmOfSampleId(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, algorithm.getNumericValue(), outExist)) {
            this.checkError(this.internalHandle);
        }
        return outExist;
    }

    public void addSerializedTemplateBlock(Types.Modality modality, Types.Instance instance, long sampleId, Types.Algorithm algorithm, Blob blob) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null.");
        }
        if (blob == null) {
            throw new IllegalArgumentException("blob is null.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (blob.getHandle() == 0L) {
            throw new CustomException("internal blob handle is NULL");
        }
        if (!this.fbsIdRecordAddSerializedTemplateBlock(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, algorithm.getNumericValue(), blob.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public Blob getSerializedTemplateBlock(Types.Modality modality, Types.Instance instance, long sampleId, Types.Algorithm algorithm) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long blobHandle = new Long(0L);
        if (!this.fbsIdRecordGetSerializedTemplateBlock(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, algorithm.getNumericValue(), blobHandle)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHandle);
        return blob;
    }

    public void setSID(byte[] sid_data) throws CustomException {
        if (sid_data == null) {
            throw new IllegalArgumentException("sid_data is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordSetSID(this.internalHandle, sid_data)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getChecksum() throws CustomException {
        Integer idRecordChecsum = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetChecksum(this.internalHandle, idRecordChecsum)) {
            this.checkError(this.internalHandle);
        }
        return idRecordChecsum;
    }

    public boolean validate() throws CustomException {
        Boolean validate = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordValidate(this.internalHandle, validate)) {
            this.checkError(this.internalHandle);
        }
        return validate;
    }

    public String toXML() throws CustomException {
        Long blobHandle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordToXml(this.internalHandle, blobHandle)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHandle);
        return new String(blob.getData());
    }

    public long getPersonId() throws CustomException {
        Long personId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetPersonId(this.internalHandle, personId)) {
            this.checkError(this.internalHandle);
        }
        return personId.intValue();
    }

    public long getTransactionId() throws CustomException {
        Long transactionId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsIdRecordGetTransactionId(this.internalHandle, transactionId)) {
            this.checkError(this.internalHandle);
        }
        return transactionId.intValue();
    }

    public Float getSampleQuality(Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Float quality = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is null");
        }
        if (!this.fbsIdRecordGetSampleQuality(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, quality)) {
            this.checkError(this.internalHandle);
        }
        quality = Float.valueOf(quality.floatValue());
        return quality;
    }

    public boolean isTemplateCreationType(Types.Modality modality, Types.Instance instance, long sampleId, Types.TemplateCreationType templateCreationType) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        if (templateCreationType == null) {
            throw new IllegalArgumentException("templateCreationType is null.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Boolean isRequestedType = false;
        if (!this.fbsIdRecordIsTemplateCreationType(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, templateCreationType.getNumericValue(), isRequestedType)) {
            this.checkError(this.internalHandle);
        }
        return isRequestedType;
    }

    public byte[] getSID() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        byte[] data = this.fbsIdRecordGetSID(this.internalHandle);
        if (data == null) {
            this.checkError(this.internalHandle);
        }
        return data;
    }
}

