/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Point;
import com.l1id.sdk.foundation.Roi;
import com.l1id.sdk.foundation.Types;
import com.l1id.sdk.foundation.WriteImageDescriptor;

public class Image
extends Core {
    private native long fbsCreateImage();

    private native boolean fbsImageClone(long var1, Long var3);

    private native boolean fbsDestroyImage(long var1);

    private native boolean fbsImageRead(long var1, String var3);

    private native boolean fbsImageLoadRaw(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native boolean fbsImageReadMem(long var1, byte[] var3, long var4);

    private native boolean fbsImageReadBlob(long var1, long var3, long var5);

    private native boolean fbsImageGetBitCount(long var1, Integer var3);

    private native boolean fbsImageWriteBlob(long var1, int var3, long var4, Long var6);

    private native boolean fbsImageGetGrayscaleBlob(long var1, Long var3);

    private native boolean fbsImageGetRgbBlob(long var1, Long var3);

    private native boolean fbsImageGenerateToken(long var1, long var3, int var5, Long var6);

    private native boolean fbsImageWriteJpegTokenBlob(long var1, long var3, Long var5);

    private native boolean fbsImageCrop(long var1, Integer var3, Integer var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Long var13);

    private native boolean fbsImageRoiCrop(long var1, long var3, Long var5);

    private native boolean fbsImageRotate(long var1, int var3, int var4, float var5, Long var6);

    private native boolean fbsImageResize(long var1, int var3, int var4, Long var5);

    private native boolean fbsImageMirror(long var1, Long var3);

    private native boolean fbsImageGetHeight(long var1, Integer var3);

    private native boolean fbsImageGetWidth(long var1, Integer var3);

    private native boolean fbsImageConvertToGray(long var1);

    private native boolean fbsImageWrite(long var1, int var3, long var4, String var6);

    public Image() {
        this.internalHandle = this.fbsCreateImage();
    }

    Image(Long handle) {
        this.internalHandle = handle;
    }

    public Image clone() {
        Long imageHande = new Long(0L);
        try {
            if (this.internalHandle == 0L) {
                throw new CustomException("internal handle is NULL");
            }
            if (!this.fbsImageClone(this.internalHandle, imageHande)) {
                this.checkError(this.internalHandle);
            }
            return new Image(imageHande);
        }
        catch (CustomException e) {
            return new Image();
        }
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyImage(this.internalHandle);
        this.internalHandle = 0L;
    }

    protected void finalize() {
        this.dispose();
    }

    public void readFromFile(String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageRead(this.internalHandle, filename)) {
            this.checkError(this.internalHandle);
        }
    }

    public byte[] getRawGrayScaleData() throws CustomException {
        Long blobHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageGetGrayscaleBlob(this.internalHandle, blobHande)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHande);
        return blob.getData();
    }

    public void loadRaw(byte[] data, int w, int h, Types.ImageChannelSequence channelSequence, Types.ImageDataOrder dataOrder) throws CustomException {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        if (channelSequence == null) {
            throw new IllegalArgumentException("channelSequence is null");
        }
        if (dataOrder == null) {
            throw new IllegalArgumentException("dataOrder is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageLoadRaw(this.internalHandle, data, w, h, channelSequence.getNumericValue(), dataOrder.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public void readBlob(byte[] blob, long checksum) throws CustomException {
        if (blob == null) {
            throw new IllegalArgumentException("blob is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageReadMem(this.internalHandle, blob, checksum)) {
            this.checkError(this.internalHandle);
        }
    }

    public void readBlob(Blob blob, long checksum) throws CustomException {
        if (blob == null) {
            throw new IllegalArgumentException("blob is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageReadBlob(this.internalHandle, blob.getHandle(), checksum)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getBitCount() throws CustomException {
        Integer bitcount = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageGetBitCount(this.internalHandle, bitcount)) {
            this.checkError(this.internalHandle);
        }
        return bitcount;
    }

    public Blob writeToBlob(Types.ImageFormat format, WriteImageDescriptor writeImageDesc) throws CustomException {
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (writeImageDesc == null) {
            throw new IllegalArgumentException("writeImageDesc is null");
        }
        Long blobHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageWriteBlob(this.internalHandle, format.getNumericValue(), writeImageDesc.getHandle(), blobHande)) {
            this.checkError(this.internalHandle);
        }
        Blob blob = new Blob(blobHande);
        return blob;
    }

    public Image crop(Roi roi) throws CustomException {
        if (roi == null) {
            throw new IllegalArgumentException("roi is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long outImageHandle = new Long(0L);
        if (!this.fbsImageRoiCrop(this.internalHandle, roi.getHandle(), outImageHandle)) {
            this.checkError(this.internalHandle);
        }
        Image outImageL = new Image(outImageHandle);
        return outImageL;
    }

    public Image rotate(Point point, float angle) throws CustomException {
        if (point == null) {
            throw new IllegalArgumentException("point is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long outImageHandle = new Long(0L);
        if (!this.fbsImageRotate(this.internalHandle, point.getX(), point.getY(), angle, outImageHandle)) {
            this.checkError(this.internalHandle);
        }
        Image outImageL = new Image(outImageHandle);
        return outImageL;
    }

    public Image resize(int width, int height) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long outImageHandle = new Long(0L);
        if (!this.fbsImageResize(this.internalHandle, width, height, outImageHandle)) {
            this.checkError(this.internalHandle);
        }
        Image outImageL = new Image(outImageHandle);
        return outImageL;
    }

    public Image mirror() throws CustomException {
        Long imageHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageMirror(this.internalHandle, imageHande)) {
            this.checkError(this.internalHandle);
        }
        Image image = new Image(imageHande);
        return image;
    }

    public int getHeight() throws CustomException {
        Integer height = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageGetHeight(this.internalHandle, height)) {
            this.checkError(this.internalHandle);
        }
        return height;
    }

    public int getWidth() throws CustomException {
        Integer width = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageGetWidth(this.internalHandle, width)) {
            this.checkError(this.internalHandle);
        }
        return width;
    }

    public void convertToGray() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageConvertToGray(this.internalHandle)) {
            this.checkError(this.internalHandle);
        }
    }

    public void writeToFile(Types.ImageFormat format, WriteImageDescriptor descriptor, String filename) throws CustomException {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("filename is null or empty.");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null.");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageWrite(this.internalHandle, format.getNumericValue(), descriptor.getHandle(), filename)) {
            this.checkError(this.internalHandle);
        }
    }
}

