/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.ImageDescriptor;
import com.l1id.sdk.foundation.Quality;
import com.l1id.sdk.foundation.Types;

public class ImageCollection
extends Core {
    private native long fbsCreateImageCollection();

    private native boolean fbsDestroyImageCollection(long var1);

    private native boolean fbsImageCollectionAddImage(long var1, long var3, Long var5, Long var6);

    private native boolean fbsImageCollectionGetImage(long var1, int var3, int var4, long var5, Long var7);

    private native boolean fbsImageCollectionGetImageDescriptor(long var1, int var3, int var4, long var5, Long var7);

    private native boolean fbsImageCollectionGetSampleId(long var1, int var3, Long var4, Long var5, Long var6);

    private native boolean fbsImageCollectionGetSize(long var1, Integer var3);

    private native boolean fbsImageCollectionGetStatus(long var1, Integer var3);

    private native boolean fbsImageCollectionGetModalityQuality(long var1, int var3, Long var4);

    private native boolean fbsImageCollectionAddSample(long var1, long var3, Long var5);

    public ImageCollection() {
        this.internalHandle = this.fbsCreateImageCollection();
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyImageCollection(this.internalHandle);
        this.internalHandle = 0L;
    }

    protected void finalize() {
        this.dispose();
    }

    public void addImage(long sampleId, Image image, ImageDescriptor imageDescriptor) throws CustomException {
        if (image == null) {
            throw new IllegalArgumentException("image is null.");
        }
        if (imageDescriptor == null) {
            throw new IllegalArgumentException("imageDescriptor is null.");
        }
        Long imageHandle = new Long(image.getHandle());
        Long imageDescHandle = new Long(imageDescriptor.getHandle());
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionAddImage(this.internalHandle, sampleId, imageHandle, imageDescHandle)) {
            this.checkError(this.internalHandle);
        }
        image.setHandle(0L);
        imageDescriptor.setHandle(0L);
    }

    public Image getImage(Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Long imageHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionGetImage(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, imageHande)) {
            this.checkError(this.internalHandle);
        }
        Image image = new Image(imageHande);
        return image;
    }

    public ImageDescriptor getImageDescriptor(Types.Modality modality, Types.Instance instance, long sampleId) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance is null.");
        }
        Long imagedescHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionGetImageDescriptor(this.internalHandle, modality.getNumericValue(), instance.getNumericValue(), sampleId, imagedescHande)) {
            this.checkError(this.internalHandle);
        }
        ImageDescriptor imagedesc = new ImageDescriptor(imagedescHande);
        return imagedesc;
    }

    public long getSampleId(int index) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long mod = new Long(0L);
        Long inst = new Long(0L);
        Long sampleId = new Long(0L);
        if (!this.fbsImageCollectionGetSampleId(this.internalHandle, index, mod, inst, sampleId)) {
            this.checkError(this.internalHandle);
        }
        return sampleId;
    }

    public Types.Modality getModality(int index) throws CustomException {
        Long sampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long mod = new Long(0L);
        Long inst = new Long(0L);
        if (!this.fbsImageCollectionGetSampleId(this.internalHandle, index, mod, inst, sampleId)) {
            this.checkError(this.internalHandle);
        }
        return Types.Modality.valueOf(mod.intValue());
    }

    public Types.Instance getInstance(int index) throws CustomException {
        Long sampleId = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long mod = new Long(0L);
        Long inst = new Long(0L);
        if (!this.fbsImageCollectionGetSampleId(this.internalHandle, index, mod, inst, sampleId)) {
            this.checkError(this.internalHandle);
        }
        return Types.Instance.valueOf(inst.intValue());
    }

    public int getSize() throws CustomException {
        Integer size = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionGetSize(this.internalHandle, size)) {
            this.checkError(this.internalHandle);
        }
        return size;
    }

    public Types.Status getStatus() throws CustomException {
        Integer statusO = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionGetStatus(this.internalHandle, statusO)) {
            this.checkError(this.internalHandle);
        }
        Types.Status status = Types.Status.valueOf(statusO);
        return status;
    }

    public Quality getModalilityQuality(Types.Modality modality) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        Quality quality = new Quality();
        Long qualityHande = new Long(quality.getHandle());
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionGetModalityQuality(this.internalHandle, modality.getNumericValue(), qualityHande)) {
            this.checkError(this.internalHandle);
        }
        return quality;
    }

    public void addStandardFingerTemplate(long sampleId, Blob standardTemplate, Types.StandardTemplateType standardType, ImageDescriptor descriptor) throws CustomException {
        if (standardTemplate == null) {
            throw new IllegalArgumentException("standardTemplate is null");
        }
        if (standardType == null) {
            throw new IllegalArgumentException("standardType is null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null");
        }
        descriptor.setStandardTemplate(standardTemplate, standardType);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageCollectionAddSample(this.internalHandle, sampleId, new Long(descriptor.getHandle()))) {
            this.checkError(this.internalHandle);
        }
        descriptor.setHandle(0L);
    }
}

