/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Blob;
import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Image;
import com.l1id.sdk.foundation.LandmarkList;
import com.l1id.sdk.foundation.Quality;
import com.l1id.sdk.foundation.RotationAngle;
import com.l1id.sdk.foundation.Types;

public class ImageDescriptor
extends Core {
    private native long fbsCreateImageDescriptor();

    private native boolean fbsDestroyImageDescriptor(long var1);

    private native boolean fbsImageDescriptorSetModality(long var1, int var3);

    private native boolean fbsImageDescriptorGetModality(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetInstance(long var1, int var3);

    private native boolean fbsImageDescriptorSetDPI(long var1, int var3);

    private native boolean fbsImageDescriptorGetDPI(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetMaxMinutiaCount(long var1, int var3);

    private native boolean fbsImageDescriptorGetMaxMinutiaCount(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetImpressionType(long var1, int var3);

    private native boolean fbsImageDescriptorGetImpressionType(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetManualLandmarkList(long var1, long var3);

    private native boolean fbsImageDescriptorGetManualLandmarkList(long var1, Long var3);

    private native boolean fbsImageDescriptorSetAlgorithms(long var1, int[] var3, int var4);

    private native int[] fbsImageDescriptorGetAlgorithms(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetQualityProfile(long var1, int var3);

    private native boolean fbsImageDescriptorGetQualityProfile(long var1, Integer var3);

    private native boolean fbsImageDescriptorGetStatus(long var1, Integer var3);

    private native boolean fbsImageDescriptorGetAutoLandmarkList(long var1, Long var3);

    private native boolean fbsImageDescriptorGetQuality(long var1, Long var3);

    private native boolean fbsImageDescriptorSetL2MNativeTemplate(long var1, long var3);

    private native boolean fbsImageDescriptorGetYouthFlag(long var1, Boolean var3);

    private native boolean fbsImageDescriptorSetYouthFlag(long var1, boolean var3);

    private native boolean fbsImageDescriptorSetFingerPalmRotationAngle(long var1, int var3, int var4);

    private native boolean fbsImageDescriptorGetFingerPalmRotationAngle(long var1, Integer var3, Integer var4);

    private native boolean fbsImageDescriptorGetFingerPalmRotationTolerance(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetFingerPalmRotationTolerance(long var1, int var3);

    private native boolean fbsImageDescriptorSetSlapAlgorithm(long var1, int var3);

    private native boolean fbsImageDescriptorGetSlapAlgorithm(long var1, Integer var3);

    private native boolean fbsImageDescriptorSetL2MNativeTemplateBlock(long var1, long var3);

    private native boolean fbsImageDescriptorSetStandardTemplate(long var1, long var3, int var5);

    private native boolean fbsImageDescriptorSetEnableLandmarkModification(long var1, boolean var3);

    private native boolean fbsImageDescriptorGetEnableLandmarkModification(long var1, Boolean var3);

    private native boolean fbsImageDescriptorSetIrisOutputISOImageType(long var1, int var3);

    private native boolean fbsImageDescriptorGetIrisOutputISOImage(long var1, Long var3);

    private native boolean fbsImageDescriptorGetInstance(long var1, Integer var3);

    protected ImageDescriptor(Long handle) {
        this.internalHandle = handle;
    }

    public ImageDescriptor(Types.Modality modality) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        this.internalHandle = this.fbsCreateImageDescriptor();
        this.setModality(modality);
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyImageDescriptor(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void setModality(Types.Modality modality) throws CustomException {
        if (modality == null) {
            throw new IllegalArgumentException("modality is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetModality(this.internalHandle, modality.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.Modality getModality() throws CustomException {
        Integer modalityordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetModality(this.internalHandle, modalityordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.Modality modality = Types.Modality.valueOf(modalityordinal);
        return modality;
    }

    public void setInstance(Types.Instance instance) throws CustomException {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetInstance(this.internalHandle, instance.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.Instance getInstance() throws CustomException {
        Integer instanceordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetInstance(this.internalHandle, instanceordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.Instance instance = Types.Instance.valueOf(instanceordinal);
        return instance;
    }

    public void setDPI(int dpi) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetDPI(this.internalHandle, dpi)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getDPI() throws CustomException {
        Integer dpi = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetDPI(this.internalHandle, dpi)) {
            this.checkError(this.internalHandle);
        }
        return dpi;
    }

    public void setMaxMinutiaCount(int minutiaCount) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetMaxMinutiaCount(this.internalHandle, minutiaCount)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getMaxMinutiaCount() throws CustomException {
        Integer minutiaCount = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetMaxMinutiaCount(this.internalHandle, minutiaCount)) {
            this.checkError(this.internalHandle);
        }
        return minutiaCount;
    }

    public void setImpressionType(Types.FingerPalmImpressionType impressionType) throws CustomException {
        if (impressionType == null) {
            throw new IllegalArgumentException("impressionType is smaller than 0.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetImpressionType(this.internalHandle, impressionType.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.FingerPalmImpressionType getImpressionType() throws CustomException {
        Integer impressionTypeordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetImpressionType(this.internalHandle, impressionTypeordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.FingerPalmImpressionType impressionType = Types.FingerPalmImpressionType.valueOf(impressionTypeordinal);
        return impressionType;
    }

    public void setManualLandmarkList(LandmarkList landmarkList) throws CustomException {
        if (landmarkList == null) {
            throw new IllegalArgumentException("landmarkList is smaller than 0.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetManualLandmarkList(this.internalHandle, landmarkList.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public LandmarkList getManualLandmarkList() throws CustomException {
        Long landmarkListHande = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetManualLandmarkList(this.internalHandle, landmarkListHande)) {
            this.checkError(this.internalHandle);
        }
        LandmarkList landmarkList = new LandmarkList(landmarkListHande);
        return landmarkList;
    }

    public void setAlgorithms(Types.Algorithm[] algorithmsToGenerate) throws CustomException {
        if (algorithmsToGenerate == null) {
            throw new IllegalArgumentException("algorithmsToGenerate is smaller than 0.");
        }
        int len = algorithmsToGenerate.length;
        int[] algorithmsToInitializeordinal = new int[len];
        for (int i = 0; i < len; ++i) {
            Types.Algorithm algo = algorithmsToGenerate[i];
            algorithmsToInitializeordinal[i] = algo.getNumericValue();
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetAlgorithms(this.internalHandle, algorithmsToInitializeordinal, algorithmsToInitializeordinal.length)) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.Algorithm[] getAlgorithms() throws CustomException {
        Integer numberOfAlgorithms = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        int[] algorithmsInt = this.fbsImageDescriptorGetAlgorithms(this.internalHandle, numberOfAlgorithms);
        if (algorithmsInt == null) {
            this.checkError(this.internalHandle);
        }
        Types.Algorithm[] algorithm = new Types.Algorithm[algorithmsInt.length];
        for (int i = 0; i < algorithmsInt.length; ++i) {
            Types.Algorithm value;
            int j = algorithmsInt[i];
            algorithm[i] = value = Types.Algorithm.valueOf(j);
        }
        return algorithm;
    }

    public void setQualityProfile(Types.QualityProfile qualityProfile) throws CustomException {
        if (qualityProfile == null) {
            throw new IllegalArgumentException("qualityProfile is smaller than 0.");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetQualityProfile(this.internalHandle, qualityProfile.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.QualityProfile getQualityProfile() throws CustomException {
        Integer qualityProfileordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetQualityProfile(this.internalHandle, qualityProfileordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.QualityProfile qualityProfile = Types.QualityProfile.valueOf(qualityProfileordinal);
        return qualityProfile;
    }

    public Types.Status getStatus() throws CustomException {
        Integer statusordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetStatus(this.internalHandle, statusordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.Status status = Types.Status.valueOf(statusordinal);
        return status;
    }

    public LandmarkList getAutoLandmarkList() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        LandmarkList lm = null;
        Long landMark = new Long(0L);
        if (!this.fbsImageDescriptorGetAutoLandmarkList(this.internalHandle, landMark)) {
            this.checkError(this.internalHandle);
        }
        lm = landMark != 0L ? new LandmarkList(landMark) : new LandmarkList();
        return lm;
    }

    public Quality getQuality() throws CustomException {
        Long retHandle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetQuality(this.internalHandle, retHandle)) {
            this.checkError(this.internalHandle);
        }
        Quality quality = new Quality(retHandle);
        return quality;
    }

    public void setYouthFlag(boolean youthFlag) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetYouthFlag(this.internalHandle, youthFlag)) {
            this.checkError(this.internalHandle);
        }
    }

    public boolean getYouthFlag() throws CustomException {
        Boolean youthFlag = new Boolean(false);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetYouthFlag(this.internalHandle, youthFlag)) {
            this.checkError(this.internalHandle);
        }
        return youthFlag;
    }

    public void setFingerPalmRotationAngle(RotationAngle rotationAngle) throws CustomException {
        if (rotationAngle == null) {
            throw new IllegalArgumentException("rotationAngle is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetFingerPalmRotationAngle(this.internalHandle, rotationAngle.getAngle(), rotationAngle.getConfidence().getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public RotationAngle getFingerPalmRotationAngle() throws CustomException {
        RotationAngle rotationAngle = new RotationAngle();
        Integer angleConfidence = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetFingerPalmRotationAngle(this.internalHandle, rotationAngle.getAngle(), angleConfidence)) {
            this.checkError(this.internalHandle);
        }
        rotationAngle.setConfidence(Types.FingerPalmAngleConfidence.valueOf(angleConfidence));
        return rotationAngle;
    }

    public void setFingerPalmRotationTolerance(int tolerance) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetFingerPalmRotationTolerance(this.internalHandle, tolerance)) {
            this.checkError(this.internalHandle);
        }
    }

    public int getFingerPalmRotationTolerance() throws CustomException {
        Integer tolerance = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetFingerPalmRotationTolerance(this.internalHandle, tolerance)) {
            this.checkError(this.internalHandle);
        }
        return tolerance;
    }

    public void setSlapAlgorithm(Types.SlapSegType slapAlgorithm) throws CustomException {
        if (slapAlgorithm == null) {
            throw new IllegalArgumentException("slapAlgorithm is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetSlapAlgorithm(this.internalHandle, slapAlgorithm.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.SlapSegType getSlapAlgorithm() throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Integer algo = new Integer(0);
        if (!this.fbsImageDescriptorGetSlapAlgorithm(this.internalHandle, algo)) {
            this.checkError(this.internalHandle);
        }
        Types.SlapSegType slap = Types.SlapSegType.valueOf(algo);
        return slap;
    }

    public void setStandardTemplate(Blob standardTemplate, Types.StandardTemplateType standardType) throws CustomException {
        if (standardTemplate == null) {
            throw new IllegalArgumentException("standardTemplate is null");
        }
        if (standardType == null) {
            throw new IllegalArgumentException("standardType is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetStandardTemplate(this.internalHandle, standardTemplate.getHandle(), standardType.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public void setIrisOutputISOImageType(Types.StandardIrisImageType isoType) throws CustomException {
        if (isoType == null) {
            throw new IllegalArgumentException("isoType is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorSetIrisOutputISOImageType(this.internalHandle, isoType.getNumericValue())) {
            this.checkError(this.internalHandle);
        }
    }

    public Image getIrisOutputISOImage() throws CustomException {
        Long imageHandle = new Long(0L);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorGetIrisOutputISOImage(this.internalHandle, imageHandle)) {
            this.checkError(this.internalHandle);
        }
        Image image = new Image(imageHandle);
        return image;
    }
}

