/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.ImageDescriptor;

public class ImageDescriptorList
extends Core {
    private native long fbsCreateImageDescriptorList();

    private native boolean fbsDestroyImageDescriptorList(long var1);

    private native boolean fbsImageDescriptorListGetSize(long var1, Integer var3);

    private native boolean fbsImageDescriptorListAt(long var1, int var3, Long var4);

    public ImageDescriptorList() {
        this.internalHandle = this.fbsCreateImageDescriptorList();
    }

    protected ImageDescriptorList(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyImageDescriptorList(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public int length() throws CustomException {
        Integer size = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsImageDescriptorListGetSize(this.internalHandle, size)) {
            this.checkError(this.internalHandle);
        }
        return size;
    }

    public ImageDescriptor at(int index) throws CustomException {
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        Long outDescHandle = new Long(0L);
        if (!this.fbsImageDescriptorListAt(this.internalHandle, index, outDescHandle)) {
            this.checkError(this.internalHandle);
        }
        ImageDescriptor desc = new ImageDescriptor(outDescHandle);
        return desc;
    }
}

