/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.Point;
import com.l1id.sdk.foundation.Types;

public class LandmarkList
extends Core {
    private native long fbsCreateLandmarkListHandle();

    private native boolean fbsDestroyLandmarkListHandle(long var1);

    private native boolean fbsLandmarkListAddFaceLandmark(long var1, int var3, int var4, Integer var5);

    private native boolean fbsLandmarkListGetFaceLandmark(long var1, int var3, Integer var4, Integer var5, Integer var6);

    private native boolean fbsLandmarkListGetPosition(long var1, int var3, Integer var4, Integer var5, Integer var6);

    private native boolean fbsLandmarkListGetRadius(long var1, int var3, Integer var4, Integer var5);

    private native boolean fbsLandmarkListGetNumberOfLandmarks(long var1, Integer var3);

    private native boolean fbsLandmarkListGetRollAngle(long var1, Float var3);

    private native boolean fbsLandmarkListGetEyeDistance(long var1, Float var3);

    public LandmarkList() {
        this.internalHandle = this.fbsCreateLandmarkListHandle();
    }

    protected LandmarkList(Long handle) {
        this.internalHandle = handle;
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyLandmarkListHandle(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void addFaceLandmark(Point point, Types.LandmarkType type) throws CustomException {
        if (point == null) {
            throw new IllegalArgumentException("point is null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null.");
        }
        Integer landmarkTypeordinal = new Integer(type.getNumericValue());
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListAddFaceLandmark(this.internalHandle, point.getX(), point.getY(), landmarkTypeordinal)) {
            this.checkError(this.internalHandle);
        }
    }

    public Types.LandmarkType getType(int index) throws CustomException {
        Integer landmarkTypeordinal = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetPosition(this.internalHandle, index, new Integer(0), new Integer(0), landmarkTypeordinal)) {
            this.checkError(this.internalHandle);
        }
        Types.LandmarkType lm = Types.LandmarkType.valueOf(landmarkTypeordinal);
        return lm;
    }

    public Point getPosition(int index) throws CustomException {
        Point point = new Point();
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetPosition(this.internalHandle, index, point.getX(), point.getY(), new Integer(0))) {
            this.checkError(this.internalHandle);
        }
        return point;
    }

    public int getIrisRadius(int index) throws CustomException {
        Integer landmarkType = new Integer(0);
        Integer radius = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetRadius(this.internalHandle, index, radius, landmarkType)) {
            this.checkError(this.internalHandle);
        }
        return radius;
    }

    public int length() throws CustomException {
        Integer numberOfLandmarks = new Integer(0);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetNumberOfLandmarks(this.internalHandle, numberOfLandmarks)) {
            this.checkError(this.internalHandle);
        }
        return numberOfLandmarks;
    }

    public float getRollAngle() throws CustomException {
        Float angle = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetRollAngle(this.internalHandle, angle)) {
            this.checkError(this.internalHandle);
        }
        return angle.floatValue();
    }

    public float getEyeDistance() throws CustomException {
        Float eyeDistance = new Float(0.0f);
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsLandmarkListGetEyeDistance(this.internalHandle, eyeDistance)) {
            this.checkError(this.internalHandle);
        }
        return eyeDistance.floatValue();
    }
}

