/*
 * Decompiled with CFR 0.152.
 */
package com.l1id.sdk.foundation;

import com.l1id.sdk.foundation.Core;
import com.l1id.sdk.foundation.CustomException;
import com.l1id.sdk.foundation.ProbeSampleDescriptor;
import com.l1id.sdk.foundation.TemplateMatcherConfiguration;
import com.l1id.sdk.foundation.Types;

public class ProbeDescriptor
extends Core {
    private native long fbsCreateProbeDescriptor();

    private native boolean fbsDestroyProbeDescriptor(long var1);

    private native boolean fbsProbeDescriptorSetQueryLanguage(long var1, int[] var3);

    private native boolean fbsProbeDescriptorSetPersonList(long var1, int var3, long[] var4, int var5);

    private native boolean fbsProbeDescriptorSetTransactionList(long var1, int var3, long[] var4, int var5);

    private native boolean fbsProbeDescriptorSetConfiguration(long var1, Long var3);

    private native boolean fbsProbeDescriptorAddSampleDesctiptor(long var1, Long var3);

    private native boolean fbsProbeDescriptorEnableMissanalysis(long var1, boolean var3);

    private native boolean fbsProbeDescriptorSetIdForMissanalysis(long var1, long var3);

    public ProbeDescriptor() {
        this.internalHandle = this.fbsCreateProbeDescriptor();
    }

    @Override
    public void dispose() {
        if (jdebugLevel > 8L) {
            System.out.println("finalize : " + this.getClass().toString() + " :: " + this.internalHandle);
        }
        this.fbsDestroyProbeDescriptor(this.internalHandle);
        this.internalHandle = 0L;
    }

    public void finalize() {
        this.dispose();
    }

    public void setPersonList(Types.ListType listtype, long[] personlist) throws CustomException {
        if (listtype == null) {
            throw new IllegalArgumentException("listtype is null");
        }
        if (personlist == null) {
            throw new IllegalArgumentException("personlist is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsProbeDescriptorSetPersonList(this.internalHandle, listtype.getNumericValue(), personlist, personlist.length)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setTransactionList(Types.ListType listtype, long[] transactionlist) throws CustomException {
        if (listtype == null) {
            throw new IllegalArgumentException("listtype is null");
        }
        if (transactionlist == null) {
            throw new IllegalArgumentException("transactionlist is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsProbeDescriptorSetTransactionList(this.internalHandle, listtype.getNumericValue(), transactionlist, transactionlist.length)) {
            this.checkError(this.internalHandle);
        }
    }

    public void setConfiguration(TemplateMatcherConfiguration configuration) throws CustomException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsProbeDescriptorSetConfiguration(this.internalHandle, configuration.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }

    public void addSampleDescriptor(ProbeSampleDescriptor descriptor) throws CustomException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null");
        }
        if (this.internalHandle == 0L) {
            throw new CustomException("internal handle is NULL");
        }
        if (!this.fbsProbeDescriptorAddSampleDesctiptor(this.internalHandle, descriptor.getHandle())) {
            this.checkError(this.internalHandle);
        }
    }
}

